/* Copyright 2008 we-lab-doc! (http://www.we-lab-doc.com/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.we_lab_doc.spacecard.utils 
 
/**
 * @author Shigeru GOUGI
 * @since 0.1
 *        <p/>
 *        Created: February 20, 2008
 */ 
class StringUtils {
	private StringUtils() {}
	//////////////////////////////////////////
	static String toMD5(String s) {
		assert s
		def md = java.security.MessageDigest.getInstance("MD5")
		def result = md.digest(s.getBytes())
		return result.encodeBase64()
	}
	static String toSHA1(String s) {
		assert s
		def md = java.security.MessageDigest.getInstance("SHA1")
		def dig = md.digest(s.getBytes())
		return dig.encodeBase64()
	}
	static String toFirstLetterUpperCase(String str) {
		return str.size() == 1 ? str.toUpperCase() : "${str[0].toUpperCase()}${str[1..-1]}"		
	}
	static boolean isNullOrBlank(String str) {
		return str == null || str.length() == 0
	}
	static boolean isNotBlank(String str) {
		return !isNullOrBlank(str)
	}	
}
