/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class ExpressionStatementNode
extends Node {
    public Node expr;
    public BitSet gen_bits;
    public ReferenceValue ref;
    public TypeValue expected_type;
    public boolean is_var_stmt;
    private boolean skip = false;

    public ExpressionStatementNode(Node node) {
        this.expr = node;
        this.gen_bits = null;
        this.ref = null;
        this.expected_type = null;
        this.is_var_stmt = false;
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public BitSet getGenBits() {
        return BitSet.or(this.expr.getGenBits(), this.gen_bits);
    }

    public BitSet getKillBits() {
        BitSet bitSet = this.expr.getKillBits();
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.or(bitSet, BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits));
            }
            return BitSet.or(bitSet, this.gen_bits);
        }
        return bitSet;
    }

    public String toString() {
        return "ExpressionStatement";
    }

    public ReferenceValue getRef(Context context) {
        if (this.ref == null) {
            this.ref = new ReferenceValue(context, null, "_cv", ObjectValue.internalNamespace);
        }
        return this.ref;
    }

    public void expectedType(TypeValue typeValue) {
        this.expected_type = typeValue;
        this.expr.expectedType(typeValue);
    }

    public void isVarStatement(boolean bl) {
        this.is_var_stmt = bl;
    }

    public boolean isVarStatement() {
        return this.is_var_stmt;
    }

    public boolean isExpressionStatement() {
        return true;
    }

    public boolean isAttribute() {
        return this.expr.isAttribute();
    }

    public void voidResult() {
        this.expr.voidResult();
    }

    public boolean isConfigurationName() {
        return this.expr.isConfigurationName();
    }

    public void skipNode(boolean bl) {
        this.skip = bl;
    }

    public boolean skip() {
        return this.skip;
    }
}

