/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.css20;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class CSS20Attribute {
    private final List familyNames;
    private final CSSWeightValue weight;
    private final CSSStyleValue style;
    private final CSSVariantValue variant;
    private final CSSStretchValue stretch;
    private final double pointSize;
    private final double opticalSize;

    public CSS20Attribute(String[] stringArray, CSSStyleValue cSSStyleValue, CSSVariantValue cSSVariantValue, CSSStretchValue cSSStretchValue, CSSWeightValue cSSWeightValue, double d, double d2) {
        this.familyNames = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.familyNames.add(i, stringArray[i]);
        }
        this.weight = cSSWeightValue;
        this.style = cSSStyleValue;
        this.variant = cSSVariantValue;
        this.stretch = cSSStretchValue;
        this.pointSize = d;
        this.opticalSize = d2;
    }

    public CSS20Attribute(String[] stringArray, CSSStyleValue cSSStyleValue, CSSVariantValue cSSVariantValue, CSSStretchValue cSSStretchValue, CSSWeightValue cSSWeightValue, double d) {
        this(stringArray, cSSStyleValue, cSSVariantValue, cSSStretchValue, cSSWeightValue, d, d);
    }

    public CSS20Attribute(CSS20Attribute cSS20Attribute) {
        this.familyNames = new ArrayList(cSS20Attribute.familyNames);
        this.weight = cSS20Attribute.weight;
        this.style = cSS20Attribute.style;
        this.variant = cSS20Attribute.variant;
        this.stretch = cSS20Attribute.stretch;
        this.pointSize = cSS20Attribute.pointSize;
        this.opticalSize = cSS20Attribute.opticalSize;
    }

    public List getFamilyNamesList() {
        return new ArrayList(this.familyNames);
    }

    public String[] getFamilyNames() {
        return (String[])this.familyNames.toArray();
    }

    public CSSStyleValue getStyle() {
        return this.style;
    }

    public int getWeight() {
        return this.weight.getValue();
    }

    public CSSVariantValue getVariant() {
        return this.variant;
    }

    public CSSStretchValue getStretch() {
        return this.stretch;
    }

    public double getPointSize() {
        return this.pointSize;
    }

    public double getOpticalSize() {
        return this.opticalSize;
    }

    public static final class CSSWeightValue
    implements Serializable {
        public static final CSSWeightValue W100 = new CSSWeightValue(100);
        public static final CSSWeightValue W200 = new CSSWeightValue(200);
        public static final CSSWeightValue W300 = new CSSWeightValue(300);
        public static final CSSWeightValue W400 = new CSSWeightValue(400);
        public static final CSSWeightValue W500 = new CSSWeightValue(500);
        public static final CSSWeightValue W600 = new CSSWeightValue(600);
        public static final CSSWeightValue W700 = new CSSWeightValue(700);
        public static final CSSWeightValue W800 = new CSSWeightValue(800);
        public static final CSSWeightValue W900 = new CSSWeightValue(900);
        public static final CSSWeightValue NORMAL = W400;
        public static final CSSWeightValue BOLD = W700;
        static final CSSWeightValue[] weightValues = new CSSWeightValue[]{W100, W200, W300, W400, W500, W600, W700, W800, W900};
        static final long serialVersionUID = 1L;
        private int value;

        private CSSWeightValue(int n) {
            this.value = n;
        }

        private Object readResolve() {
            return CSSWeightValue.getWeightValue(this.value);
        }

        protected static CSSWeightValue getWeightValue(int n) {
            for (int i = 0; i < weightValues.length; ++i) {
                if (CSSWeightValue.weightValues[i].value != n) continue;
                return weightValues[i];
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }

        public static CSSWeightValue parse(String string) {
            if (string.equalsIgnoreCase("bold")) {
                return BOLD;
            }
            if (string.equalsIgnoreCase("normal")) {
                return NORMAL;
            }
            return CSSWeightValue.getWeightValue(Integer.parseInt(string));
        }
    }

    public static final class CSSVariantValue
    implements Serializable {
        public static final CSSVariantValue NORMAL = new CSSVariantValue("normal", 1);
        public static final CSSVariantValue SMALL_CAPS = new CSSVariantValue("small-caps", 2);
        private static final CSSVariantValue[] variantValues = new CSSVariantValue[]{NORMAL, SMALL_CAPS};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSVariantValue(String string, int n) {
            this.name = string;
            this.value = n;
        }

        private Object readResolve() {
            return CSSVariantValue.getVariantValue(this.value);
        }

        public static CSSVariantValue parse(String string) {
            for (int i = 0; i < variantValues.length; ++i) {
                if (!CSSVariantValue.variantValues[i].name.equalsIgnoreCase(string)) continue;
                return variantValues[i];
            }
            return null;
        }

        protected static CSSVariantValue getVariantValue(int n) {
            for (int i = 0; i < variantValues.length; ++i) {
                if (CSSVariantValue.variantValues[i].value != n) continue;
                return variantValues[i];
            }
            return null;
        }
    }

    public static final class CSSStyleValue
    implements Serializable {
        public static final CSSStyleValue NORMAL = new CSSStyleValue("normal", 1);
        public static final CSSStyleValue OBLIQUE = new CSSStyleValue("oblique", 2);
        public static final CSSStyleValue ITALIC = new CSSStyleValue("italic", 3);
        private static final CSSStyleValue[] styleValues = new CSSStyleValue[]{NORMAL, OBLIQUE, ITALIC};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSStyleValue(String string, int n) {
            this.name = string;
            this.value = n;
        }

        private Object readResolve() {
            return CSSStyleValue.getStyleValue(this.value);
        }

        public static CSSStyleValue parse(String string) {
            for (int i = 0; i < styleValues.length; ++i) {
                if (!CSSStyleValue.styleValues[i].name.equalsIgnoreCase(string)) continue;
                return styleValues[i];
            }
            return null;
        }

        protected static CSSStyleValue getStyleValue(int n) {
            for (int i = 0; i < styleValues.length; ++i) {
                if (CSSStyleValue.styleValues[i].value != n) continue;
                return styleValues[i];
            }
            return null;
        }
    }

    public static final class CSSStretchValue
    implements Serializable {
        public static final CSSStretchValue ULTRACONDENSED = new CSSStretchValue("ultracondensed", 100);
        public static final CSSStretchValue EXTRACONDENSED = new CSSStretchValue("extracondensed", 200);
        public static final CSSStretchValue CONDENSED = new CSSStretchValue("condensed", 300);
        public static final CSSStretchValue SEMICONDENSED = new CSSStretchValue("semicondensed", 400);
        public static final CSSStretchValue NORMAL = new CSSStretchValue("normal", 500);
        public static final CSSStretchValue SEMIEXPANDED = new CSSStretchValue("semiexpanded", 600);
        public static final CSSStretchValue EXPANDED = new CSSStretchValue("expanded", 700);
        public static final CSSStretchValue EXTRAEXPANDED = new CSSStretchValue("extraexpanded", 800);
        public static final CSSStretchValue ULTRAEXPANDED = new CSSStretchValue("ultraexpanded", 900);
        private static final CSSStretchValue[] stretchValues = new CSSStretchValue[]{ULTRACONDENSED, EXTRACONDENSED, CONDENSED, SEMICONDENSED, NORMAL, SEMIEXPANDED, EXPANDED, EXTRAEXPANDED, ULTRAEXPANDED};
        static final long serialVersionUID = 1L;
        private String name;
        private int value;

        private CSSStretchValue(String string, int n) {
            this.name = string;
            this.value = n;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return CSSStretchValue.getStretchValue(this.value);
        }

        int getValue() {
            return this.value;
        }

        public static CSSStretchValue parse(String string) {
            for (int i = 0; i < stretchValues.length; ++i) {
                if (!CSSStretchValue.stretchValues[i].name.equalsIgnoreCase(string)) continue;
                return stretchValues[i];
            }
            return null;
        }

        public static CSSStretchValue getStretchValue(int n) {
            for (int i = 0; i < stretchValues.length; ++i) {
                if (CSSStretchValue.stretchValues[i].value != n) continue;
                return stretchValues[i];
            }
            return null;
        }
    }
}

