/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.abc.Attributes;
import flex2.compiler.abc.Class;
import flex2.compiler.abc.MetaData;
import flex2.compiler.abc.Method;
import flex2.compiler.abc.Namespace;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.BytecodeEmitter;
import flex2.compiler.as3.binding.TypeAnalyzer;
import flex2.compiler.common.Configuration;
import flex2.compiler.css.StyleConflictException;
import flex2.compiler.css.Styles;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameList;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.oem.ProgressMeter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import macromedia.asc.util.ContextStatics;

public final class SymbolTable {
    public static final String internalNamespace = "internal";
    public static final String privateNamespace = "private";
    public static final String protectedNamespace = "protected";
    public static final String publicNamespace = "";
    public static final String unnamedPackage = "";
    public static final String[] VISIBILITY_NAMESPACES;
    public static final String NOTYPE = "*";
    public static final String STRING = "String";
    public static final String BOOLEAN = "Boolean";
    public static final String NUMBER = "Number";
    public static final String INT = "int";
    public static final String UINT = "uint";
    public static final String NAMESPACE = "Namespace";
    public static final String FUNCTION = "Function";
    public static final String CLASS = "Class";
    public static final String ARRAY = "Array";
    public static final String OBJECT = "Object";
    public static final String XML = "XML";
    public static final String XML_LIST = "XMLList";
    public static final String REGEXP = "RegExp";
    public static final String EVENT = "flash.events:Event";
    private static final NoType NoTypeClass;
    private final Map classTable = new HashMap(300);
    private final Styles styles = new Styles();
    public final ContextStatics perCompileData;
    private final QNameMap qNameTable;
    private final Map multiNames;
    public final BytecodeEmitter emitter;
    private Context context;
    private boolean suppressWarnings;
    private final Map rbNames;
    private final Map rbNameTable;
    public int tick = 0;
    public int currentPercentage = 0;
    private TypeAnalyzer typeAnalyzer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SymbolTable(boolean bang, int dialect, boolean suppressWarnings) {
        this.perCompileData = new ContextStatics();
        this.perCompileData.use_static_semantics = bang;
        this.perCompileData.dialect = dialect;
        this.perCompileData.languageID = macromedia.asc.util.Context.getLanguageID(Locale.getDefault().getCountry().toUpperCase());
        ContextStatics.useVerboseErrors = false;
        this.qNameTable = new QNameMap(300);
        this.multiNames = new HashMap(1024);
        macromedia.asc.util.Context cx = new macromedia.asc.util.Context(this.perCompileData);
        this.emitter = new BytecodeEmitter(cx, null, false);
        cx.setEmitter(this.emitter);
        this.typeAnalyzer = new TypeAnalyzer(this);
        this.rbNames = new HashMap();
        this.rbNameTable = new HashMap();
    }

    public SymbolTable(Object contextStatics) {
        this.perCompileData = (ContextStatics)contextStatics;
        this.qNameTable = new QNameMap(300);
        this.multiNames = new HashMap(1024);
        macromedia.asc.util.Context cx = new macromedia.asc.util.Context(this.perCompileData);
        this.emitter = new BytecodeEmitter(cx, null, false);
        cx.setEmitter(this.emitter);
        this.typeAnalyzer = new TypeAnalyzer(this);
        this.rbNames = new HashMap();
        this.rbNameTable = new HashMap();
    }

    public void adjustProgress() {
        ProgressMeter meter = ThreadLocalToolkit.getProgressMeter();
        for (int i = this.currentPercentage + 1; meter != null && i <= 100; ++i) {
            meter.percentDone(i);
        }
    }

    public void registerClass(String className, Class cls) {
        if (!$assertionsDisabled && className.indexOf(47) != -1) {
            throw new AssertionError();
        }
        this.classTable.put(className, cls);
    }

    public Class getClass(String className) {
        if (!$assertionsDisabled && className != null && className.indexOf(47) != -1) {
            throw new AssertionError();
        }
        if (className != null) {
            return NOTYPE.equals(className) ? NoTypeClass : (Class)this.classTable.get(className);
        }
        return null;
    }

    public void registerStyles(Styles newStyles) throws StyleConflictException {
        this.styles.addStyles(newStyles);
    }

    public MetaData getStyle(String styleName) {
        if (styleName != null) {
            return this.styles.getStyle(styleName);
        }
        return null;
    }

    public Styles getStyles() {
        return this.styles;
    }

    void registerQNames(QNameList qNames, Source source) {
        int size = qNames.size();
        for (int i = 0; i < size; ++i) {
            QName qN = (QName)qNames.get(i);
            this.qNameTable.put(qN, source);
        }
    }

    public void registerQName(QName qName, Source source) {
        Source old = (Source)this.qNameTable.get(qName);
        if (old == null) {
            this.qNameTable.put(new QName(qName), source);
        } else if (!old.getName().equals(source.getName()) && !$assertionsDisabled) {
            throw new AssertionError((Object)(qName + " defined in " + old + " and " + source.getName()));
        }
    }

    public void registerResourceBundle(String rbName, Source source) {
        this.rbNameTable.put(rbName, source);
    }

    public Source findSourceByQName(QName qName) {
        return (Source)this.qNameTable.get(qName);
    }

    public Source findSourceByQName(String namespaceURI, String localPart) {
        return (Source)this.qNameTable.get(namespaceURI, localPart);
    }

    public Source findSourceByResourceBundleName(String rbName) {
        return (Source)this.rbNameTable.get(rbName);
    }

    void registerMultiName(MultiName multiName, QName qName) {
        this.multiNames.put(multiName, qName);
    }

    void registerResourceBundleName(String rbName, QName[] qNames) {
        this.rbNames.put(rbName, qNames);
    }

    public QName isMultiNameResolved(MultiName multiName) {
        return (QName)this.multiNames.get(multiName);
    }

    public QName[] isResourceBundleResolved(String rbName) {
        return (QName[])this.rbNames.get(rbName);
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = new Context();
        }
        return this.context;
    }

    public void cleanClassTable() {
        Iterator i = this.classTable.keySet().iterator();
        while (i.hasNext()) {
            Class c = (Class)this.classTable.get(i.next());
            c.setTypeTable(null);
        }
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public boolean getSuppressWarningsIncremental() {
        return this.suppressWarnings;
    }

    public static SymbolTable newSymbolTable(Configuration configuration) {
        return new SymbolTable(configuration.getCompilerConfiguration().strict(), configuration.getCompilerConfiguration().dialect(), configuration.getCompilerConfiguration().suppressWarningsInIncremental());
    }

    public void register(String rbName, QName[] qNames, Source source) {
        if (source != null) {
            int length;
            this.registerResourceBundleName(rbName, qNames);
            this.registerResourceBundle(rbName, source);
            int n = length = qNames == null ? 0 : qNames.length;
            for (int i = 0; i < length; ++i) {
                this.registerQName(qNames[i], source);
            }
        }
    }

    static {
        $assertionsDisabled = !SymbolTable.class.desiredAssertionStatus();
        VISIBILITY_NAMESPACES = new String[]{"", protectedNamespace, internalNamespace, privateNamespace};
        NoTypeClass = new NoType();
    }

    static class NoType
    implements Class {
        static final /* synthetic */ boolean $assertionsDisabled;

        NoType() {
        }

        public Variable getVariable(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        public QName[] getVariableNames() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Method getMethod(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        public QName[] getMethodNames() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Method getGetter(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        public QName[] getGetterNames() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Method getSetter(String[] namespaces, String name, boolean inherited) {
            return null;
        }

        public QName[] getSetterNames() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Namespace getNamespace(String nsName) {
            return null;
        }

        public String getName() {
            return SymbolTable.NOTYPE;
        }

        public String getSuperTypeName() {
            return null;
        }

        public String[] getInterfaceNames() {
            return null;
        }

        public Attributes getAttributes() {
            return null;
        }

        public List getMetaData(boolean inherited) {
            return null;
        }

        public List getMetaData(String name, boolean inherited) {
            return null;
        }

        public boolean implementsInterface(String interfaceName) {
            return false;
        }

        public boolean isSubclassOf(String baseName) {
            return false;
        }

        public boolean isInterface() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return false;
        }

        public void setTypeTable(Object typeTable) {
        }

        static {
            $assertionsDisabled = !(class$flex2$compiler$SymbolTable == null ? (class$flex2$compiler$SymbolTable = SymbolTable.class$("flex2.compiler.SymbolTable")) : class$flex2$compiler$SymbolTable).desiredAssertionStatus();
        }
    }
}

