/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flash.util.FileUtils;
import flash.util.Trace;
import flex.messaging.config.ConfigurationException;
import flex2.compiler.API;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.Source;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.CommandLineConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.FileConfigurator;
import flex2.compiler.config.SystemPropertyConfigurator;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.CompilerControl;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.CompcConfiguration;
import flex2.tools.Compiler;
import flex2.tools.ToolsConfiguration;
import flex2.tools.oem.Logger;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.ProgressMeter;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import flex2.tools.oem.internal.ApplicationData;
import flex2.tools.oem.internal.BuilderLogger;
import flex2.tools.oem.internal.LibraryCompilerConfiguration;
import flex2.tools.oem.internal.LinkerConfiguration;
import flex2.tools.oem.internal.OEMConfiguration;
import flex2.tools.oem.internal.OEMConsole;
import flex2.tools.oem.internal.OEMLogAdapter;
import flex2.tools.oem.internal.OEMPathResolver;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OEMUtil {
    public static final LocalizationManager setupLocalizationManager() {
        LocalizationManager l10n = new LocalizationManager();
        l10n.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager(l10n);
        return l10n;
    }

    public static final void init(Logger logger, MimeMappings mimeMappings, ProgressMeter meter, PathResolver resolver, CompilerControl cc) {
        API.useAS3();
        API.usePathResolver(resolver != null ? new OEMPathResolver(resolver) : null);
        OEMUtil.setupLocalizationManager();
        ThreadLocalToolkit.setLogger(new OEMLogAdapter(logger));
        ThreadLocalToolkit.setMimeMappings(mimeMappings);
        ThreadLocalToolkit.setProgressMeter(meter);
        ThreadLocalToolkit.setCompilerControl(cc);
    }

    public static final void clean() {
        API.removePathResolver();
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setLocalizationManager(null);
        ThreadLocalToolkit.setMimeMappings(null);
        ThreadLocalToolkit.setProgressMeter(null);
        ThreadLocalToolkit.setCompilerControl(null);
    }

    public static final String load(InputStream in, String cacheName) throws IOException {
        File temp = null;
        if (cacheName == null) {
            temp = FileUtil.createTempFile(in);
            temp.deleteOnExit();
        } else {
            temp = FileUtil.openFile(cacheName);
            FileUtil.writeBinaryFile(temp, in);
        }
        return FileUtil.getCanonicalPath(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final long save(OutputStream out, String cacheName, ApplicationData data) throws IOException {
        block12: {
            if (cacheName == null) {
                cacheName = OEMUtil.load(new ByteArrayInputStream(new byte[0]), null);
            }
            if (cacheName == null) return 0L;
            if (data == null) return 0L;
            File dead = FileUtil.openFile(cacheName);
            if (dead != null && dead.exists()) {
                dead.delete();
            }
            RandomAccessFile cacheFile = null;
            try {
                cacheFile = new RandomAccessFile(cacheName, "rw");
                API.persistCompilationUnits(data.fileSpec, data.sourceList, data.sourcePath, data.resources, data.bundlePath, data.sources, data.units, data.checksum, data.cmdChecksum, data.linkChecksum, data.swcChecksum, data.swcDefSignatureChecksums, data.swcFileChecksums, "", cacheFile);
                Object var6_5 = null;
                if (cacheFile == null) break block12;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (cacheFile == null) throw throwable;
                try {
                    cacheFile.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ex) {}
            cacheFile.close();
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(cacheName));
            FileUtil.streamOutput(in, out);
            Object var9_11 = null;
            if (in == null) return new File(cacheName).length();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {
            return new File(cacheName).length();
        }
        ((InputStream)in).close();
        return new File(cacheName).length();
    }

    public static final OEMConfiguration getApplicationConfiguration(String[] args, boolean keepLinkReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings) {
        return OEMUtil.getApplicationConfiguration(args, keepLinkReport, logger, resolver, mimeMappings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final OEMConfiguration getApplicationConfiguration(String[] args, boolean keepLinkReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings, boolean processDefaults) {
        if (!processDefaults) {
            return new OEMConfiguration(null, null);
        }
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(ApplicationCompilerConfiguration.class, ApplicationCompilerConfiguration.getAliases());
            cfgbuf.setDefaultVar("file-specs");
            DefaultsConfigurator.loadDefaults(cfgbuf);
            Configuration obj = Compiler.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "oem", args, cfgbuf, ApplicationCompilerConfiguration.class, "file-specs");
            ApplicationCompilerConfiguration configuration = (ApplicationCompilerConfiguration)obj;
            configuration.keepLinkReport(keepLinkReport);
            OEMConfiguration oEMConfiguration = new OEMConfiguration(cfgbuf, configuration);
            return oEMConfiguration;
        }
        catch (flex2.compiler.config.ConfigurationException ex) {
            Compiler.processConfigurationException(ex, "oem");
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (ConfigurationException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        finally {
            OEMUtil.clean();
        }
    }

    public static final OEMConfiguration getLibraryConfiguration(String[] args, boolean keepLinkReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings) {
        return OEMUtil.getLibraryConfiguration(args, keepLinkReport, logger, resolver, mimeMappings, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final OEMConfiguration getLibraryConfiguration(String[] args, boolean keepLinkReport, Logger logger, PathResolver resolver, MimeMappings mimeMappings, boolean processDefaults) {
        if (!processDefaults) {
            return new OEMConfiguration(null, null);
        }
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(LibraryCompilerConfiguration.class, LibraryCompilerConfiguration.getAliases());
            DefaultsConfigurator.loadOEMCompcDefaults(cfgbuf);
            Configuration obj = Compiler.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "oem", args, cfgbuf, LibraryCompilerConfiguration.class, null);
            LibraryCompilerConfiguration configuration = (LibraryCompilerConfiguration)obj;
            configuration.keepLinkReport(keepLinkReport);
            OEMConfiguration oEMConfiguration = new OEMConfiguration(cfgbuf, configuration);
            return oEMConfiguration;
        }
        catch (flex2.compiler.config.ConfigurationException ex) {
            Compiler.processConfigurationException(ex, "oem");
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (ConfigurationException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        finally {
            OEMUtil.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final OEMConfiguration getLinkerConfiguration(String[] args, boolean keepLinkReport, Logger logger, MimeMappings mimeMappings, PathResolver resolver, Configuration c, Set newLinkerOptions, Set includes, Set excludes) {
        OEMUtil.init(logger, mimeMappings, null, resolver, null);
        try {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(LinkerConfiguration.class, LinkerConfiguration.getAliases());
            DefaultsConfigurator.loadDefaults(cfgbuf);
            Configuration obj = Compiler.processConfiguration(ThreadLocalToolkit.getLocalizationManager(), "oem", args, cfgbuf, LinkerConfiguration.class, null);
            LinkerConfiguration configuration = (LinkerConfiguration)obj;
            configuration.setOriginalConfiguration(c, newLinkerOptions, includes, excludes);
            configuration.keepLinkReport(keepLinkReport);
            OEMConfiguration oEMConfiguration = new OEMConfiguration(cfgbuf, configuration);
            return oEMConfiguration;
        }
        catch (flex2.compiler.config.ConfigurationException ex) {
            Compiler.processConfigurationException(ex, "oem");
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (ConfigurationException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(ex.getMessage());
            OEMConfiguration oEMConfiguration = null;
            return oEMConfiguration;
        }
        finally {
            OEMUtil.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConfigurationBuffer getCommandLineConfigurationBuffer(Logger logger, PathResolver resolver, String[] args) {
        ConfigurationBuffer cfgbuf = null;
        try {
            OEMUtil.init(logger, null, null, resolver, null);
            cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, CommandLineConfiguration.getAliases());
            SystemPropertyConfigurator.load(cfgbuf, "flex");
            CommandLineConfigurator.parse(cfgbuf, null, args);
        }
        catch (flex2.compiler.config.ConfigurationException ex) {
            ThreadLocalToolkit.log(ex);
            cfgbuf = null;
        }
        finally {
            OEMUtil.clean();
        }
        return cfgbuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConfigurationBuffer getCompcConfigurationBuffer(Logger logger, PathResolver resolver, String[] args) {
        ConfigurationBuffer cfgbuf = null;
        try {
            OEMUtil.init(logger, null, null, resolver, null);
            cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
            SystemPropertyConfigurator.load(cfgbuf, "flex");
            CommandLineConfigurator.parse(cfgbuf, null, args);
        }
        catch (flex2.compiler.config.ConfigurationException ex) {
            ThreadLocalToolkit.log(ex);
            cfgbuf = null;
        }
        finally {
            OEMUtil.clean();
        }
        return cfgbuf;
    }

    public static String[] trim(String[] args, ConfigurationBuffer cfgbuf, Set excludes) {
        List positions = cfgbuf.getPositions();
        ArrayList<String> newArgs = new ArrayList<String>();
        int length = positions.size();
        for (int i = 0; i < length; ++i) {
            Object[] a = (Object[])positions.get(i);
            String var = (String)a[0];
            int iStart = (Integer)a[1];
            int iEnd = (Integer)a[2];
            if (excludes.contains(var)) continue;
            for (int j = iStart; j < iEnd; ++j) {
                newArgs.add(args[j]);
            }
        }
        args = new String[newArgs.size()];
        newArgs.toArray(args);
        return args;
    }

    public static final Logger getLogger(Logger logger, List messages) {
        return new BuilderLogger(logger == null ? new OEMConsole() : logger, messages);
    }

    public static final String formatConfigurationBuffer(ConfigurationBuffer cfgbuf) {
        return FileConfigurator.formatBuffer(cfgbuf, "flex-config", OEMUtil.setupLocalizationManager(), "flex2.configuration");
    }

    public static final Map getLicenseMap(ToolsConfiguration configuration) {
        return configuration.getLicensesConfiguration().getLicenseMap();
    }

    public static final void setGeneratedDirectory(CompilerConfiguration compilerConfig, File output) {
        if (compilerConfig.keepGeneratedActionScript()) {
            File canonical = FileUtils.canonicalFile((File)output);
            if (canonical != null) {
                output = canonical;
            }
            String parent = output.getParent();
            String generated = null;
            generated = parent == null ? new File("generated").getAbsolutePath() : FileUtils.addPathComponents((String)parent, (String)"generated", (char)File.separatorChar);
            compilerConfig.setGeneratedDirectory(generated);
            new File(generated).mkdirs();
        }
    }

    public static void saveSignatureChecksums(List units, ApplicationData data, Configuration config) {
        if (!config.isSwcChecksumEnabled()) {
            data.swcDefSignatureChecksums = null;
            return;
        }
        if (units != null) {
            data.swcDefSignatureChecksums = new HashMap();
            Iterator iter = units.iterator();
            while (iter.hasNext()) {
                CompilationUnit unit = (CompilationUnit)iter.next();
                Source source = unit == null ? null : unit.getSource();
                if (source == null || !source.isSwcScriptOwner() || source.isInternal()) continue;
                OEMUtil.addSignatureChecksumToData(data, unit);
            }
        }
    }

    public static void saveSwcFileChecksums(CompilerSwcContext swcContext, ApplicationData data, Configuration config) {
        if (!config.isSwcChecksumEnabled()) {
            data.swcFileChecksums = null;
            return;
        }
        data.swcFileChecksums = new HashMap();
        Iterator iter = swcContext.getFiles().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String filename = (String)entry.getKey();
            VirtualFile file = (VirtualFile)entry.getValue();
            data.swcFileChecksums.put(filename, new Long(file.getLastModified()));
        }
    }

    public static boolean isRecompilationNeeded(ApplicationData data, CompilerSwcContext swcContext, OEMConfiguration config) {
        boolean result;
        int checksum = OEMUtil.calculateChecksum(data, swcContext, config);
        if (checksum != data.checksum) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: calculated checksum differs from last checksum, recompile");
            }
            data.checksum = checksum;
            return true;
        }
        if (!config.configuration.isSwcChecksumEnabled()) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, swc-checksum disabled, incremental compile");
            }
            return false;
        }
        Map signatureChecksums = data.swcDefSignatureChecksums;
        if (signatureChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, signatureChecksums is null, incremental compile");
            }
        } else {
            Iterator iter = signatureChecksums.entrySet().iterator();
            while (iter.hasNext()) {
                Source source;
                Map.Entry entry = iter.next();
                QName qName = (QName)entry.getKey();
                Long dataSignatureChecksum = (Long)entry.getValue();
                Long swcSignatureChecksum = swcContext.getChecksum(qName);
                if (swcSignatureChecksum == null && qName != null && (source = swcContext.getSource(qName.getNamespace(), qName.getLocalPart())) != null) {
                    swcSignatureChecksum = new Long(source.getLastModified());
                }
                if (Trace.swcChecksum && dataSignatureChecksum == null) {
                    throw new IllegalStateException("dataSignatureChecksum should never be null");
                }
                if (dataSignatureChecksum != null && swcSignatureChecksum == null) {
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                if (dataSignatureChecksum != null) {
                    if (dataSignatureChecksum.longValue() == swcSignatureChecksum.longValue()) continue;
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                return true;
            }
        }
        boolean bl = result = !OEMUtil.areSwcFileChecksumsEqual(data, swcContext);
        if (Trace.swcChecksum) {
            Trace.trace((String)("isRecompilationNeeded: " + (result ? "recompile" : "incremental compile")));
        }
        return result;
    }

    public static int calculateChecksum(ApplicationData data, CompilerSwcContext swcContext, OEMConfiguration config) {
        int checksum = config.cfgbuf.checksum_ts();
        if (!config.configuration.isSwcChecksumEnabled() || data.swcDefSignatureChecksums == null || data.swcDefSignatureChecksums.size() == 0) {
            checksum += swcContext.checksum();
        }
        return checksum;
    }

    private static void addSignatureChecksumToData(ApplicationData data, CompilationUnit unit) {
        Long signatureChecksum = unit.getSignatureChecksum();
        if (signatureChecksum == null) {
            SwcScript script = (SwcScript)unit.getSource().getOwner();
            signatureChecksum = new Long(script.getLastModified());
        }
        if (data.swcDefSignatureChecksums != null) {
            Iterator iter = unit.topLevelDefinitions.iterator();
            while (iter.hasNext()) {
                QName qname = (QName)iter.next();
                data.swcDefSignatureChecksums.put(qname, signatureChecksum);
            }
        }
    }

    private static boolean areSwcFileChecksumsEqual(ApplicationData data, CompilerSwcContext swcContext) {
        if (data.swcFileChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: no file checksum map, not equal");
            }
            return false;
        }
        Map swcFiles = swcContext.getFiles();
        Set dataSet = data.swcFileChecksums.entrySet();
        if (swcFiles.size() < dataSet.size()) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: less files than before, not equal");
            }
            return false;
        }
        Iterator iter = dataSet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String filename = (String)entry.getKey();
            Long dataFileLastModified = (Long)entry.getValue();
            Long swcFileLastModified = null;
            VirtualFile swcFile = (VirtualFile)swcFiles.get(filename);
            if (swcFile != null) {
                swcFileLastModified = new Long(swcFile.getLastModified());
            }
            if (dataFileLastModified.equals(swcFileLastModified)) continue;
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: not equal");
                Trace.trace((String)("filename = " + filename));
                Trace.trace((String)("last modified1 = " + dataFileLastModified));
                Trace.trace((String)("last modified2 = " + swcFileLastModified));
            }
            return false;
        }
        if (Trace.swcChecksum) {
            Trace.trace((String)"areSwcFileChecksumsEqual: equal");
        }
        return true;
    }
}

