/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.ByteWriter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NonCachedRandomAccessFileByteWriter
implements ByteWriter {
    private RandomAccessFile file;

    public NonCachedRandomAccessFileByteWriter(RandomAccessFile file) throws IOException {
        this.file = file;
    }

    public void write(long position, byte[] b, int offset, int length) throws IOException {
        this.file.seek(position);
        this.file.write(b, offset, length);
    }

    public void write(long position, int b) throws IOException {
        this.file.seek(position);
        this.file.write(b);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.file.close();
    }

    public String toString() {
        return this.file.toString();
    }

    public int read(long position) throws IOException {
        if (position < 0L || position >= this.length()) {
            return -1;
        }
        this.file.seek(position);
        return this.file.read();
    }

    public int read(long position, byte[] b, int offset, int length) throws IOException {
        if (position < 0L || position >= this.file.length()) {
            return -1;
        }
        this.file.seek(position);
        return this.file.read(b, offset, (int)Math.min((long)length, this.file.length() - position));
    }
}

