/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.flex;

import coldfusion.eventgateway.flex.rmi.CFToFlexProxyServer;
import coldfusion.eventgateway.flex.rmi.FlexToCFProxy;
import coldfusion.flex.rmi.DataServicesRMIRegistry;
import flex.messaging.Destination;
import flex.messaging.FlexContext;
import flex.messaging.FlexRemoteCredentials;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.config.ConfigMap;
import flex.messaging.config.ConfigurationException;
import flex.messaging.log.Log;
import flex.messaging.log.Logger;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.services.MessageService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.ServiceException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;

public class CFEventGatewayAdapter
extends ServiceAdapter {
    public static final String GATEWAYID = "gatewayid";
    public static final String GATEWAYHOST = "gatewayhost";
    public static final String ALLOWEDIPS = "allowedIPs";
    private final String REMOTE_USERNAME = "remote-username";
    private final String REMOTE_PASSWORD = "remote-password";
    private final String CFUSERNAME = "CFusername";
    private final String CFPASSWORD = "CFpassword";
    private String LOG_CATEGORY = "Message.coldfusion";
    private Logger log = Log.getLogger((String)this.LOG_CATEGORY);
    private String gatewayid;
    private String host = null;
    private boolean localCF = true;
    private FlexToCFProxy localCFProxy;
    private int rmiport = DataServicesRMIRegistry.getDefaultPort();
    private String[] allowedIPs = null;
    private String username;
    private String password;

    public CFEventGatewayAdapter() {
        super(false);
    }

    public void initialize(String id, ConfigMap properties) {
        super.initialize(id, properties);
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.log.info("[CFEventGatewayAdapter] Configuring ColdFusion Event Gateway adapter for destination " + this.getDestination().getId());
        this.gatewayid = properties.getPropertyAsString(GATEWAYID, this.gatewayid);
        if (this.gatewayid != null) {
            this.gatewayid = this.gatewayid.trim();
        }
        this.host = properties.getPropertyAsString(GATEWAYHOST, this.host);
        if (this.host != null) {
            this.localCF = false;
            this.host = this.host.trim();
        }
        this.username = properties.getPropertyAsString("remote-username", this.username);
        this.password = properties.getPropertyAsString("remote-password", this.password);
        String iplist = properties.getProperty(ALLOWEDIPS);
        if (iplist != null) {
            StringTokenizer tok = new StringTokenizer(iplist, ",");
            String[] ipArray = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                ipArray[i++] = tok.nextToken().trim();
            }
            this.allowedIPs = ipArray.length > 0 ? ipArray : null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(Message message) {
        Service service;
        FlexRemoteCredentials creds;
        FlexSession session;
        String gwid = this.gatewayid;
        if ("*".equals(this.gatewayid)) {
            Object o = message.getHeader(GATEWAYID);
            if (!(o instanceof String)) throw new MessageException("Message header 'gatewayid' required in message when sending to destination '" + this.getDestination().getId() + "'");
            gwid = (String)o;
        } else {
            message.setHeader(GATEWAYID, (Object)gwid);
        }
        AsyncMessage asyncMessage = (AsyncMessage)message;
        this.log.debug("[CFEventGatewayAdapter] Sending message to ColdFusion Event Gateway '" + gwid + "':\n" + asyncMessage.toString());
        if (this.username != null) {
            asyncMessage.setHeader("CFusername", (Object)this.username);
            asyncMessage.setHeader("CFpassword", (Object)this.password);
        }
        if ((session = FlexContext.getFlexSession()) != null && (creds = session.getRemoteCredentials((service = (Service)this.getDestination().getParent()).getId(), this.getDestination().getId())) != null) {
            asyncMessage.setHeader("CFusername", (Object)creds.getUsername());
            asyncMessage.setHeader("CFpassword", creds.getCredentials());
        }
        FlexToCFProxy proxy = this.findCFProxy(gwid);
        try {
            boolean ok = proxy.sendToCFGateway(asyncMessage);
            return ok;
        }
        catch (Throwable ex) {
            throw new MessageException("Unable to send message to CF Gateway '" + gwid + "': " + ex.getMessage(), ex);
        }
    }

    public void send(AsyncMessage flexMessage) {
        if (flexMessage != null) {
            this.log.debug("[CFEventGatewayAdapter] Received message from ColdFusion Event Gateway:\n" + flexMessage.toString());
            MessageService service = (MessageService)this.getDestination().getParent();
            service.serviceMessageFromAdapter((Message)flexMessage, true);
        }
    }

    public void setupAdapterControl(Destination destination) {
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        this.setManaged(false);
        super.start();
        if (this.localCF) {
            this.setupLocalProxy();
        } else {
            DataServicesRMIRegistry.startRegistry();
            this.registerAdapter();
        }
    }

    public void stop() {
        super.stop();
        if (!this.localCF) {
            this.unregisterAdapter();
        }
    }

    protected void validate() {
        if (this.isValid()) {
            return;
        }
        if (this.gatewayid == null) {
            ConfigurationException err = new ConfigurationException();
            err.setMessage("Destination [" + this.getDestination().getId() + "]: Unable to find <gatewayid> property - don't know where to send messages");
            throw err;
        }
        super.validate();
    }

    private void registerAdapter() throws MessageException {
        try {
            CFToFlexProxyServer proxy = new CFToFlexProxyServer(this);
            String name = "//localhost:" + this.rmiport + "/" + "cfeventadapter/" + this.getDestination().getId();
            Naming.rebind(name, proxy);
            this.log.debug("[CFEventGatewayAdapter] Registered ColdFusion Event Gateway adapter at " + name);
        }
        catch (Exception e) {
            String msg = "Problem registering RMI proxy for destination '" + this.getDestination().getId() + "': " + e.toString();
            this.log.error(msg, (Throwable)e);
            throw new MessageException(msg, (Throwable)e);
        }
    }

    private void unregisterAdapter() throws MessageException {
        try {
            String name = "//localhost:" + this.rmiport + "/" + "cfeventadapter/" + this.getDestination().getId();
            Naming.unbind(name);
            this.log.debug("[CFEventGatewayAdapter] Unregistered ColdFusion Event Gateway adapter at " + name);
        }
        catch (Exception e) {
            String msg = "Problem unregistering RMI proxy for destination '" + this.getDestination().getId() + "': " + e.toString();
            this.log.debug(msg, (Throwable)e);
        }
    }

    private void setupLocalProxy() {
        try {
            Class<?> pClass = Class.forName("coldfusion.eventgateway.flex.FlexGatewayLocalProxy");
            this.localCFProxy = (FlexToCFProxy)pClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            ServiceException se = new ServiceException();
            se.setDetails("[CFEventGatewayAdapter] Unable to find ColdFusion in this server, perhaps you need to set <gatewayhost> in the '" + this.getDestination().getId() + "' destination config?");
            throw se;
        }
        catch (Exception e) {
            ServiceException se = new ServiceException();
            se.setDetails("[CFEventGatewayAdapter] Unable to create ColdFusion proxy class: " + e);
            se.setRootCause((Throwable)e);
            throw se;
        }
    }

    private synchronized FlexToCFProxy findCFProxy(String gwid) throws MessageException {
        if (this.localCF) {
            if (this.localCFProxy == null) {
                throw new MessageException("Unable to find ColdFusion in this server, perhaps you need to set <gatewayhost> in the '" + this.getDestination().getId() + "' destination config?");
            }
            return this.localCFProxy;
        }
        String name = "//" + this.host + ":" + this.rmiport + "/" + "cfeventgateway/" + gwid;
        try {
            return (FlexToCFProxy)Naming.lookup(name);
        }
        catch (NotBoundException nbe) {
            String msg = "Unable to find ColdFusion gateway '" + gwid + "' in RMI registry" + (this.host != null ? " on host " + this.host : "") + ". The gateway may not be running.";
            throw new MessageException(msg);
        }
        catch (RemoteException remex) {
            if (this.host != null && !this.host.equals("localhost") && !this.host.equals("127.0.0.1")) {
                throw new MessageException("Unable to contact the RMI registry on host " + this.host + " to look for gateway " + gwid + ": " + remex.toString());
            }
            try {
                DataServicesRMIRegistry.forceStartRegistry();
                this.registerAdapter();
                return (FlexToCFProxy)Naming.lookup(name);
            }
            catch (Exception e) {
                throw new MessageException("Unable to find gateway '" + gwid + "' in RMI registry: " + e.toString(), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new MessageException("Unable to find gateway '" + gwid + "' in RMI registry: " + e.toString(), (Throwable)e);
        }
    }

    public boolean verifyHost(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            String remote = addr.getHostAddress();
            if (this.allowedIPs != null && this.allowedIPs.length > 0) {
                for (int i = 0; i < this.allowedIPs.length; ++i) {
                    if (!this.allowedIPs[i].equals(remote)) continue;
                    return true;
                }
            } else {
                InetAddress localhost = InetAddress.getLocalHost();
                if (localhost.getHostAddress().equals(remote)) {
                    return true;
                }
            }
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

