/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePathBase;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.QName;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class SourcePath
extends SourcePathBase {
    protected final List directories = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourcePath(VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean allowSourcePathOverlap) {
        this(mimeTypes, allowSourcePathOverlap);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        SourcePath.addPathElements(classPath, this.directories, allowSourcePathOverlap, this.warnings);
    }

    public SourcePath(String[] mimeTypes, boolean allowSourcePathOverlap) {
        super(mimeTypes, allowSourcePathOverlap);
    }

    public void addPathElements(VirtualFile[] classPath) {
        SourcePath.addPathElements(classPath, this.directories, this.allowSourcePathOverlap, this.warnings);
    }

    private Source newSource(File file, File pathRoot, String namespaceURI, String localPart) {
        return new Source((VirtualFile)new LocalFile(file), new LocalFile(pathRoot), namespaceURI.replace('.', '/'), localPart, this, false, false);
    }

    boolean checkPreference(Source s) {
        if (!$assertionsDisabled && s.getOwner() != this) {
            throw new AssertionError();
        }
        String relativePath = this.constructRelativePath(s);
        String pathRoot = s.getPathRoot().getName();
        if (relativePath == null) {
            return true;
        }
        boolean thisPath = false;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            File f = null;
            if (pathRoot.equals(FileUtil.getCanonicalPath(d))) {
                thisPath = true;
            }
            try {
                f = this.findFile(d, relativePath, this.mimeTypes);
            }
            catch (CompilerException ex) {
                this.removeSource(s);
                return false;
            }
            if (f == null || thisPath) continue;
            this.removeSource(s);
            return false;
        }
        return true;
    }

    protected Source findFile(String className, String namespaceURI, String localPart) throws CompilerException {
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        Source s = null;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            File f = this.findFile(d, p, this.mimeTypes);
            if (f == null) continue;
            s = this.newSource(f, d, namespaceURI, localPart);
            this.sources.put(className, s);
            return s;
        }
        return null;
    }

    public boolean hasPackage(String packageName) {
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            if (!this.hasDirectory(d, packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefinition(QName qName) {
        String className = this.constructClassName(qName.getNamespace(), qName.getLocalPart());
        if (this.misses.contains(className)) {
            return false;
        }
        if (this.hits.contains(className)) {
            return true;
        }
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = (File)this.directories.get(i);
            try {
                File f = this.findFile(d, p, this.mimeTypes);
                if (f == null) continue;
                this.hits.add(className);
                return true;
            }
            catch (CompilerException ex) {
                // empty catch block
            }
        }
        this.misses.add(className);
        return false;
    }

    private boolean hasDirectory(File dir, String packageName) {
        if (packageName.length() == 0) {
            return true;
        }
        String relativePath = packageName.replace('.', File.separatorChar);
        String fullPath = dir.getPath() + File.separator + relativePath;
        if (this.dirs.get(fullPath) == NO_DIR) {
            return false;
        }
        boolean result = new File(dir, relativePath).isDirectory();
        this.dirs.put(fullPath, result ? fullPath : NO_DIR);
        return result;
    }

    public List getPaths() {
        return this.directories;
    }

    static {
        $assertionsDisabled = !SourcePath.class.desiredAssertionStatus();
    }
}

