/*
 * Decompiled with CFR 0.152.
 */
package flex.webtier.services.logging;

import flash.localization.LocalizationManager;
import flex.webtier.services.ServiceFactory;
import flex.webtier.services.logging.Logger;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.io.FileUtil;
import flex2.compiler.util.AbstractLogger;
import flex2.compiler.util.ThreadLocalToolkit;

public class WebtierIntegratedLogger
extends AbstractLogger
implements flex2.compiler.Logger {
    private Logger webtierLogger;
    private static final String lineSeparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WebtierIntegratedLogger() {
        this.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
        this.webtierLogger = ServiceFactory.getLogger();
    }

    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    public void log(ILocalizableMessage m, String source) {
        if (m.getLevel() == "warning" ? !this.webtierLogger.isWarningEnabled() : !this.webtierLogger.isInfoEnabled()) {
            return;
        }
        String prefix = this.formatPrefix(this.getLocalizationManager(), m);
        boolean found = true;
        LocalizationManager loc = this.getLocalizationManager();
        String text = loc.getLocalizedTextString((Object)m);
        if (text == null) {
            text = m.getClass().getName();
            found = false;
        }
        String exText = this.formatExceptionDetail(m, loc);
        if (m.getPath() != null && m.getLine() != -1) {
            exText = exText + lineSeparator + lineSeparator + (source == null ? this.getLineText(m.getPath(), m.getLine()) : source);
        }
        if (m.getColumn() != -1) {
            exText = exText + lineSeparator + this.getLinePointer(m.getColumn(), source);
        }
        if (m.getLevel() == "info") {
            this.logInfo(prefix + text + exText);
        } else if (m.getLevel() == "warning") {
            this.logWarning(prefix + text + exText);
        } else {
            this.logError(prefix + text + exText);
        }
        if (!$assertionsDisabled && !found) {
            throw new AssertionError((Object)("Localized text missing for " + m.getClass().getName()));
        }
    }

    public void logDebug(String debug) {
        if (this.webtierLogger.isDebugEnabled()) {
            this.webtierLogger.logDebug(debug);
        }
    }

    public void logDebug(String path, String debug) {
        this.logDebug(path + lineSeparator + lineSeparator + debug);
    }

    public void logDebug(String path, int line, String debug) {
        this.logDebug(path + "(" + line + "):" + " " + debug);
    }

    public void logDebug(String path, int line, int col, String debug) {
        this.logDebug(path + "(" + line + "): " + this.COL + ": " + col + " " + debug);
    }

    public void logInfo(String info) {
        if (this.webtierLogger.isInfoEnabled()) {
            this.webtierLogger.logInfo(info);
        }
    }

    public void logInfo(String path, int line, String info) {
        this.logInfo(path, line, info);
    }

    public void logInfo(String path, String info) {
        this.logInfo(path + lineSeparator + lineSeparator + info);
    }

    public void logInfo(String path, int line, int col, String info) {
        this.logInfo(path + "(" + line + "): " + this.COL + ": " + col + " " + info);
    }

    public void logWarning(String warning) {
        if (this.webtierLogger.isWarningEnabled()) {
            this.webtierLogger.logWarning(warning);
        }
    }

    public void logWarning(String path, String warning) {
        this.logWarning(path + lineSeparator + lineSeparator + warning);
    }

    public void logWarning(String path, String warning, int errorCode) {
        this.logWarning(path, warning);
    }

    public void logWarning(String path, int line, String warning) {
        if (this.webtierLogger.isWarningEnabled()) {
            this.logWarning(path + "(" + line + "):" + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + this.getLineText(path, line));
        }
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        this.logWarning(path, line, warning);
    }

    public void logWarning(String path, int line, int col, String warning) {
        if (this.webtierLogger.isWarningEnabled()) {
            String lineText = this.getLineText(path, line);
            this.logWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        if (this.webtierLogger.isWarningEnabled()) {
            this.logWarning(path + "(" + line + "): " + this.COL + ": " + col + " " + this.WARNING + ": " + warning + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
        }
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        this.logWarning(path, line, col, warning, source);
    }

    public void logError(String error) {
        this.webtierLogger.logError(error);
    }

    public void logError(String path, String error) {
        this.logError(path + lineSeparator + lineSeparator + this.ERROR + ": " + error);
    }

    public void logError(String path, String error, int errorCode) {
        this.logError(path, error);
    }

    public void logError(String path, int line, String error) {
        this.logError(path + "(" + line + "): " + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + this.getLineText(path, line));
    }

    public void logError(String path, int line, String error, int errorCode) {
        this.logError(path, line, error);
    }

    public void logError(String path, int line, int col, String error) {
        String lineText = this.getLineText(path, line);
        this.logError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + lineText + lineSeparator + this.getLinePointer(col, lineText));
    }

    public void logError(String path, int line, int col, String error, String source) {
        this.logError(path + "(" + line + "): " + this.COL + ": " + col + " " + this.ERROR + ": " + error + lineSeparator + lineSeparator + source + lineSeparator + this.getLinePointer(col, source));
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        this.logError(path, line, col, error, source);
    }

    private String getLineText(String path, int line) {
        String text = null;
        try {
            text = FileUtil.readLine((String)path, (int)line);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return text;
    }

    private String getLinePointer(int col, String source) {
        if (col <= 0) {
            return "^";
        }
        StringBuffer b = new StringBuffer(col);
        for (int i = 0; i < col - 1; ++i) {
            if (source != null && i < source.length() && source.charAt(i) == '\t') {
                b.append('\t');
                continue;
            }
            b.append(' ');
        }
        b.append('^');
        return b.toString();
    }

    public void includedFileAffected(String path) {
    }

    public void needsCompilation(String path, String reason) {
    }

    public void includedFileUpdated(String path) {
    }

    public int errorCount() {
        return -1;
    }

    public int warningCount() {
        return -1;
    }

    static {
        $assertionsDisabled = !WebtierIntegratedLogger.class.desiredAssertionStatus();
        lineSeparator = System.getProperty("line.separator");
    }
}

