/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.SparseArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GlyphNames {
    static Object mutex = new Object();
    static final Map aglNameList;
    static final Map dingbatNameList;
    static final SparseArray charTable;
    static final SparseArray dingbatCharTable;
    static /* synthetic */ Class class$com$adobe$fontengine$font$opentype$GlyphNames;

    public static String resolveUSVWithAGNCNameTable(int n) {
        List list = (List)charTable.get(n);
        if (list == null) {
            return null;
        }
        GlyphNameEntry glyphNameEntry = (GlyphNameEntry)list.get(0);
        return glyphNameEntry.getName();
    }

    public static String resolveUSVToAGNCName(int n) {
        String string = GlyphNames.resolveUSVWithAGNCNameTable(n);
        if (string == null) {
            string = GlyphNames.generateUPlusName(n);
        }
        return string;
    }

    public static String generateUPlusName(int n) {
        if (n >= 0 && n <= 0x10FFFF) {
            String string = Integer.toHexString(n).toUpperCase();
            switch (string.length()) {
                case 1: {
                    return "u000" + string;
                }
                case 2: {
                    return "u00" + string;
                }
                case 3: {
                    return "u0" + string;
                }
            }
            return "u" + string;
        }
        return null;
    }

    public static List resolveAGNCName(String string, boolean bl) {
        ArrayList arrayList = new ArrayList();
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        String[] stringArray = string.split("_");
        for (int i = 0; i < stringArray.length; ++i) {
            if ((!bl ? GlyphNames.resolveGlyphList(stringArray[i], arrayList) : GlyphNames.resolveDingbatsList(stringArray[i], arrayList)) || GlyphNames.resolveUniName(stringArray[i], arrayList)) continue;
            GlyphNames.resolveUPlusName(stringArray[i], arrayList);
        }
        return arrayList;
    }

    public static int[] resolveAGNCNameIntoArray(String string, boolean bl) {
        List list = GlyphNames.resolveAGNCName(string, bl);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = (Integer)list.get(i);
        }
        return nArray;
    }

    public static String getAGNCNameSuffix(String string) {
        int n = string.indexOf(46);
        if (n == -1 || n == string.length() - 1) {
            return null;
        }
        return string.substring(n + 1, string.length());
    }

    private static boolean resolveUPlusName(String string, List list) {
        if (string.matches("^u(([\\dA-F]{4})|([1-9A-F][\\dA-F]{4})|(1[\\dA-F]{5}))")) {
            list.add(new Integer(Integer.parseInt(string.substring(1), 16)));
            return true;
        }
        return false;
    }

    private static boolean resolveUniName(String string, List list) {
        int n = 0;
        if (string.matches("^uni([\\dA-F]{4})+")) {
            for (int i = 3; i < string.length(); i += 4) {
                int n2 = Integer.parseInt(string.substring(i, i + 4), 16);
                if (n2 >= 0 && n2 <= 55295 || n2 >= 57344 && n2 <= 65535) {
                    list.add(new Integer(n2));
                    ++n;
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    list.remove(list.size() - 1);
                }
                break;
            }
        }
        return n != 0;
    }

    private static boolean resolveGlyphList(String string, List list) {
        GlyphNameEntry glyphNameEntry = (GlyphNameEntry)aglNameList.get(string);
        if (glyphNameEntry == null) {
            return false;
        }
        list.add(glyphNameEntry.getUSV());
        return true;
    }

    private static boolean resolveDingbatsList(String string, List list) {
        GlyphNameEntry glyphNameEntry = (GlyphNameEntry)dingbatNameList.get(string);
        if (glyphNameEntry == null) {
            return false;
        }
        list.add(glyphNameEntry.getUSV());
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((class$com$adobe$fontengine$font$opentype$GlyphNames == null ? (class$com$adobe$fontengine$font$opentype$GlyphNames = GlyphNames.class$("com.adobe.fontengine.font.opentype.GlyphNames")) : class$com$adobe$fontengine$font$opentype$GlyphNames).getResourceAsStream("agnc"));
            aglNameList = (Map)objectInputStream.readObject();
            charTable = (SparseArray)objectInputStream.readObject();
            dingbatNameList = (Map)objectInputStream.readObject();
            dingbatCharTable = (SparseArray)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new RuntimeException("cannot load AFE AGNC resources", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("cannot load AFE AGNC resources", classNotFoundException);
        }
    }

    protected static class GlyphNameEntry
    implements Serializable {
        static final long serialVersionUID = 1L;
        protected Integer usv;
        protected String name;

        protected GlyphNameEntry(Integer n, String string) {
            this.usv = n;
            this.name = string;
        }

        protected GlyphNameEntry(int n, String string) {
            this.usv = new Integer(n);
            this.name = string;
        }

        protected Integer getUSV() {
            return this.usv;
        }

        protected String getName() {
            return this.name;
        }

        public String toString() {
            return "[ " + this.usv + ", " + this.name + " ]";
        }
    }
}

