<?php
/*
 * framework-spider
 * util/File.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
/**
 * ファイルシステムに関するユーティリティ関数群を提供する静的メソッドクラス
 */
class util_File {
	/**
	 * 指定フォルダ以下のフォルダとファイルを指定フォルダ化にコピーします
	 * @param $resource_dir コピー元フォルダパス
	 * @param $destination_dir コピー先フォルダパス
	 */
	function copyDirFiles( $resource_dir, $destination_dir, $force=false ) {
		if( is_dir( $resource_dir ) && is_dir($destination_dir) ) {
			if ($dh = opendir($resource_dir)) {
				while (($file_name = readdir($dh)) !== false) {
					if( preg_match('/^\\./',$file_name) == 0 ) {
						$file_absolute_path	= $resource_dir.DIRECTORY_SEPARATOR.$file_name;
						$file_type			= filetype($file_absolute_path);
						$destination_path	= $destination_dir.DIRECTORY_SEPARATOR.$file_name;
						if( preg_match('/^[dD][iI][rR]/', filetype($file_absolute_path) ) ) {
							// フォルダの場合なければ作成する
							if( !file_exists($destination_path) ) {
								if( @mkdir( $destination_path, SPIDER_PERMITTION_DATA_FOLDER ) ) {
									@chmod( $destination_path, SPIDER_PERMITTION_DATA_FOLDER );
								} else {
									return false;
								}
							}
							// 再帰呼び出し
							if( !util_File::copyDirFiles( $file_absolute_path, $destination_path ) ) {
								return false;
							}
						} else if( preg_match('/^[fF][iI][lL][eE]/', filetype($file_absolute_path) ) ) {
							// 対象がファイルの場合なければコピー
							if( $force || !file_exists($destination_path) ) {
								if( @copy( $file_absolute_path, $destination_path ) ) {
									@chmod( $destination_path, SPIDER_PERMITTION_DATA_FOLDER );
								} else {
									return false;
								}
							}
						}
					}
				}
				@closedir( $dh );
			}
		} else {
			return false;
		}
		return true;
	}
	/**
	 * spiderアプリケーション内の絶対ファイルパスをアプリケーションURIに変換します
	 */
	function path2suri( $absolutePath ) {
		$basePath		= str_replace(DIRECTORY_SEPARATOR,'/',SPIDER_BASE_PATH);
		$absolutePath	= str_replace(DIRECTORY_SEPARATOR,'/',$absolutePath);
		if( strlen($absolutePath) >= strlen($basePath) ) {
			$retUri		= str_replace($basePath,'',$absolutePath);
			if( preg_match('/\\/$/',$retUri) > 0 ) { $retUri	= preg_replace('/\\/$/','',$retUri); }
			if( preg_match('/^\\//',$retUri) == 0 ) { $retUri	= '/'.$retUri; }
			return $retUri;
		}
		return false;
	}
	/**
	 * spiderアプリケーション内のURIからファイル絶対パスに変換します
	 */
	function suri2path( $uri ) {
		$absolutePath	= str_replace(DIRECTORY_SEPARATOR,'/',SPIDER_BASE_PATH);
		if( preg_match('/\\/$/',$absolutePath) > 0 ) {
			$absolutePath	= preg_replace('/\\/$/','',$absolutePath);
		}
		if( '/' == $uri ) {
		} else {
			$absolutePath	.= $uri;
		}
		$absolutePath	= str_replace('/',DIRECTORY_SEPARATOR,$absolutePath);
		return $absolutePath;
	}
	/**
	 * スタティックメソッド
	 * ファイルパスを指定して拡大・縮小画像を作成します
	 */
	function resizeImage( $srcPath, $distPath, $maxWidth, $maxHeight, $fillColor=null, $quality=100, $srcType=null, $distType=null ) {
		// 元ファイルの画像確認
		if( !file_exists($srcPath) ) {
			return false;
		}
		// 元画像情報取得
		$imageInfoHash	= getimagesize($srcPath);
		if( $imageInfoHash === false ) {
			return false;
		}
		// 情報を取得できたらサイズ変更処理開始
		$orgWidth	= $imageInfoHash[0];
		$orgHeight	= $imageInfoHash[1];
		$orgType	= $imageInfoHash[2];
		// 変換元と変換後形式は入力値を優先
		if( IMAGETYPE_GIF == $srcType || IMAGETYPE_JPEG == $srcType || IMAGETYPE_PNG == $srcType ) {
		} else {
			$srcType	= $orgType;
		}
		if( IMAGETYPE_GIF == $distType || IMAGETYPE_JPEG == $distType || IMAGETYPE_PNG == $distType ) {
		} else {
			$distType	= $srcType;
		}
		// 出力クオリティの調整
		if( preg_match('/^(100|[0-9]{1,2})$/',$quality) == 0 ) {
			$quality	= 100;
		}
		if( IMAGETYPE_PNG == $distType ) {
			// PNGは圧縮率0-9に調整
			$quality	= 10 - floor( $quality / 10 );
		}
		// 入力された幅高さの調整
		if( is_null($maxWidth) || $maxWidth < 1 ) {
			$maxWidth	= $orgWidth;
		}
		if( is_null($maxHeight) || $maxHeight < 1 ) {
			$maxHeight	= $orgHeight;
		}
		// 作成画像サイズ
		$regWidth	= $orgWidth;
		$regHeight	= $orgHeight;
		// 指定最大サイズから作成画像の幅高さを算出
		if( $maxWidth >= $maxHeight ) {
			// 最大幅の方が大きい場合、小さいほう$maxHeightに合わせる
			$regHeight	= $maxHeight;
			$regWidth	= ceil($maxHeight * ( $orgWidth / $orgHeight ));
			if( $regWidth > $maxWidth ) {
				$regWidth	= $maxWidth;
				$regHeight	= ceil($orgHeight * ( $regWidth / $orgWidth ));
			}
		} else {
			// 最大高さの方が大きい場合、小さいほう$maxWidthに合わせる
			$regWidth	= $maxWidth;
			$regHeight	= ceil($maxWidth * ( $orgHeight / $orgWidth ));
			if( $regHeight > $maxWidth ) {
				$regHeight	= $maxWidth;
				$regWidth	= ceil($regWidth * ( $regHeight / $orgHeight ));
			}
		}
		if( $regHeight == $orgHeight && $regWidth == $orgWidth ) {
			// リサイズの必要なし。処理しない
			return true;
		}
		
		// リサイズ処理
		$orgImage = null;
		$thumbImage	= null;
		if( IMAGETYPE_PNG == $srcType ) {
			$orgImage	= imagecreatefrompng($srcPath);
			$thumbImage	= imagecreatetruecolor( $regWidth, $regHeight );
		} else if( IMAGETYPE_GIF == $srcType ) {
			$orgImage	= imagecreatefromgif($srcPath);
			$thumbImage	= imagecreate( $regWidth, $regHeight );
		} else if( IMAGETYPE_JPEG == $srcType ) {
			$orgImage	= imagecreatefromjpeg($srcPath);
			$thumbImage	= imagecreatetruecolor( $regWidth, $regHeight );
		}
		if( is_null($orgImage) ) {
			$thumbImage	= null;
			return false;
		}
		// サイズ変更
		$posX		= 0;
		$posY		= 0;
		$isExistTrans		= false;
		// fill
		if( preg_match('/^[0-9a-fA-F]{6}$/',$fillColor) > 0 ) {
			// 背景色指定
			if( IMAGETYPE_GIF == $srcType ) {
				$thumbImage	= imagecreate( $maxWidth, $maxHeight );
			} else {
				$thumbImage	= imagecreatetruecolor( $maxWidth, $maxHeight );
			}
			$colR		= hexdec( substr($fillColor, 0, 2) );
			$colG		= hexdec( substr($fillColor, 2, 2) );
			$colB		= hexdec( substr($fillColor, 4, 2) );
			$fillColor	= imagecolorallocate( $thumbImage, $colR, $colG, $colB );
			imagefill( $thumbImage, 0, 0, $fillColor );
			$posX		= ( $maxWidth - $regWidth ) / 2;
			$posY		= ( $maxHeight - $regHeight ) / 2;
		} else {
			// 背景色未指定
			if( IMAGETYPE_GIF == $srcType ) {
				$thumbImage	= imagecreate( $regWidth, $regHeight );
			} else {
				$thumbImage	= imagecreatetruecolor( $regWidth, $regHeight );
			}
			if( IMAGETYPE_JPEG != $srcType ) {
				// 元画像の透明色を取得して背景色を透明に設定
				imagealphablending($thumbImage,false);
				imageSaveAlpha($thumbImage,true);
				$transX	= 0;
				$transY	= 0;
				$transeColorIndex	= @imagecolortransparent($orgImage);
				if( $transeColorIndex !== false ) {
					for( $transX=0; $transX<$orgWidth; $transX++ ) {
						for( $transY=0; $transY<$orgHeight; $transY++ ) {
							if( imagecolorat($orgImage,$transX,$transY) == $transeColorIndex ) {
								$isExistTrans	= true;
								break;
							}
						}
						if( $isExistTrans ) {
							break;
						}
					}
					if( $isExistTrans ) {
						$transX	= ceil($transX * ($regWidth/$orgWidth));
						$transY	= ceil($transY * ($regHeight/$orgHeight));
						$rgb = imagecolorat($thumbImage,$transX,$transY);
						$r = ($rgb >> 16) & 0xFF;
						$g = ($rgb >> 8) & 0xFF;
						$b = $rgb & 0xFF;
						$transColor	= imagecolorclosest($thumbImage, $r, $g, $b); 
						imagefill($thumbImage,0,0,$transColor);
						imagecolortransparent($thumbImage,$transColor);
					}
				}
			}
		}
		// エラーがないならリサイズ
		imagecopyresampled($thumbImage, $orgImage
			, $posX, $posY					// サムネイル側開始位置
			, 0, 0							// オリジナル側開始位置
			, $regWidth, $regHeight			// サムネイル側終了位置
			, $orgWidth, $orgHeight );		// オリジナル側終了位置
		if( IMAGETYPE_JPEG != $srcType && $isExistTrans ) {
			$rgb = imagecolorat($thumbImage,$transX,$transY);
			$r = ($rgb >> 16) & 0xFF;
			$g = ($rgb >> 8) & 0xFF;
			$b = $rgb & 0xFF;
			$transColor	= imagecolorclosest($thumbImage, $r, $g, $b); 
			imagefill($thumbImage,0,0,$transColor);
			imagecolortransparent($thumbImage,$transColor);
		}
		// ファイル作成
		if( IMAGETYPE_PNG == $distType ) {
			imagepng( $thumbImage, $distPath, $quality );
		} else if( IMAGETYPE_GIF == $distType ) {
			imagegif( $thumbImage, $distPath );
		} else {
			imagejpeg( $thumbImage, $distPath, $quality );
		}
		$orgImage	= null;
		$thumbImage	= null;
		return true;
	}
}
?>