<?php
/*
 * system/login/UserAdministrator.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'AbstractUser.class.php');
/**
 * システム管理者情報を保持するsystem_login_AbstractUserクラスの実装オブジェクトクラス
 * @package system
 * @subpackage login
 * @category DAO
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_UserAdministrator extends system_login_AbstractUser {
	/** ユニークユーザーID	*/
	var $userId			= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
	/** ログインID	*/
	var $loginId		= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_ID;
	/** ログインパスワード	*/
	var $loginPassword	= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_PASSWORD;
	/** 管理者表示名	*/
	var $viewName		= SYSTEM_LOGIN_ADMINISTRATOR_NAME;
	/**
	 * コンストラクタ
	 */
    function system_login_UserAdministrator() {
    }
	/**
	 * ログインIDからユーザーを読み込むメソッドの実装
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUser( & $request, $loginId ) {
		if( $this->load($request) ) {
			if( $loginId == $this->loginId ) {
				return true;
			}
		}
		return false;
	}
	/**
	 * ユーザーユニークIDからユーザーを読み込むメソッドの実装
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUserByUniqueId( & $request, $uniqueId ) {
		if( $this->load($request) ) {
			if( $uniqueId == $this->userId ) {
				return true;
			}
		}
		return false;
	}
	/**
	 * メールアドレスからユーザーを読み込むメソッドの実装
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $loginId ログインID
	 * @return boolean 一意のユーザを読み込むことができればtrue
	 */
	function loadLoginUserByEmail( & $request, $email ) {
		if( $this->load($request) ) {
			require_once(dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'PackageConfig.class.php');
			$packageConfigObject	= new system_PackageConfig();
			if( $packageConfigObject->load( $request ) ) {
				if( $email == $packageConfigObject->definitionHash['SYSTEM_MAIL_FROM_ADDRESS'] ) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	/**
	 * ユーザー固有のIDを取得します
	 */
	function getUniqueId() {
		return $this->userId;
	}
	/**
	 * ログインIDを取得します
	 */
	function getLoginId(){
		return $this->loginId;
	}
	/**
	 * ログインパスワードを取得します
	 */
	function getLoginPassword(){
		return $this->loginPassword;
	}
	/**
	 * ログインパスワードを照合します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @param string $inputPassword 入力されたパスワード
	 * @return boolean パスワードが一致したらtrue
	 */
	function confirmPassword( & $request, $inputPassword ) {
		if( $this->loginPassword == $this->encodePassword($request,$inputPassword) ) {
			return true;
		} else if( $inputPassword == $this->decodePassword( $request, $this->loginPassword ) ){
			return true;
		} else if( $this->loginPassword == $inputPassword ) {
			return true;
		}
		return false;
	}
	/**
	 * ログインパスワードをランダムに再発行します
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスオブジェクトの参照
	 * @return mixed 新しく発行したパスワード文字列。再発行に失敗したらfalse。
	 */
	function renewPassword( & $request ) {
		$newPassword			= parent::renewPassword( $request );
		$this->loginPassword	= $this->encodePassword($request,$newPassword);
		require_once(dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'PackageConfig.class.php');
		$sysConfigObject	= new system_PackageConfig();
		if( $sysConfigObject->load($request) ) {
			$sysConfigObject->definitionHash['SYSTEM_ADMIN_LOGIN_PASSWORD']	= $newPassword;
			if( $sysConfigObject->save( $request ) ) {
				return $newPassword;
			}
		}
		return false;
	}
	/**
	 * ログイン者の表示名称を取得します
	 */
	function getUserViewName() {
		return $this->viewName;
	}
	/**
	 * システムグループレベルを取得します
	 * SYSTEM_LOGIN_USER_ADMINISTRATORS 0 管理者グループ
	 * SYSTEM_LOGIN_USER_POWERS パワーユーザーグループ
	 * SYSTEM_LOGIN_USER_USERS 一般ユーザーグループ
	 * SYSTEM_LOGIN_USER_GUEST ゲストユーザー グループ
	 */
	function getLoginGroupLevel(){
		return SYSTEM_LOGIN_USER_ADMINISTRATORS;
	}
	/**
	 * 指定のパッケージIDを利用する権限があるか確認します
	 */
	function hasPackagePermittion( $packageId ) {
		// システム管理者なので常に全てtrueを返す
		return true;
	}
	/**
	 * 指定のURIを表示する権限があるか確認します
	 */
	function hasUriPermittion( $uri ) {
		return true;
	}
	//
	// データ扱いの権限に関するメソッド
	//
	/**
	 * 本オブジェクトのデータを渡されたAbstractUserが閲覧できるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canViewData( & $request, $abstractUser ) {
		return true;
	}
	/**
	 * 渡されたAbstractDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		return true;
	}
	//
	// AbstractUserのオーバーライドとオーバーロード
	//
	/**
	 * データ保存区分と固有IDから保存データを本オブジェクトのメンバ値に読み込むメソッドのオーバーロード
	 * @param object $request spider_HttpRequestクラスのインスタンス
	 * @param string $uniqueId 固有ID
	 * @return boolean 読み込みに成功したらtrue, 失敗したらfalse
	 */
	function load( & $request ) {
		$systemDefineFile	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php';
		if( parent::load( $request, SYSTEM_LOGIN_ADMINISTRATOR_USER_ID ) ) {
			return true;
		} else if( file_exists($systemDefineFile) ) {
			// 定義ファイルがあれば読み込み
			require_once($systemDefineFile);
			$this->userId	= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
			if( defined('SYSTEM_ADMIN_LOGIN_ID') ) {
				$this->loginId	= SYSTEM_ADMIN_LOGIN_ID;
			}
			if( defined('SYSTEM_ADMIN_LOGIN_PASSWORD') ) {
				$this->loginPassword	= SYSTEM_ADMIN_LOGIN_PASSWORD;
			}
			if( defined('SYSTEM_MAIL_FROM_NAME') ) {
				$this->viewName	= SYSTEM_MAIL_FROM_NAME;
			}
			return true;
		} else {
			// ファイルがなければデフォルト値
			$this->userId			= SYSTEM_LOGIN_ADMINISTRATOR_USER_ID;
			$this->loginId			= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_ID;
			$this->loginPassword	= SYSTEM_LOGIN_ADMINISTRATOR_LOGIN_PASSWORD;
			$this->viewName			= SYSTEM_LOGIN_ADMINISTRATOR_NAME;
			return true;
		}
	}
}
?>