<?php
/*
 * search/scripts/reminder.cmd.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 * 
 * ７日前リマインドメールを送信するコマンドスクリプト
 * 2009/07/07
 */
// コマンド共通モジュール取り込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'spider'
.DIRECTORY_SEPARATOR.'spider.cmd.php');
// データベース接続クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'Connect.class.php');
// 文字操作ユーティリティ
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php');
// メール送信クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'Mail.class.php');
// メール送信クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'mail'
.DIRECTORY_SEPARATOR.'Mime.class.php');
// システム設定クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
// 会員パッケージ設定クラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
// 会員DAOクラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'DaoMember.class.php');
// 会員パッケージメールアドレス一時保存テーブルクラス
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'DaoMemberRegistTemporary.class.php');
// 会員メールテンプレートDAOクラスの読み込み
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'DaoMemberMailTemplate.class.php');
// ショッピング設定クラス
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php');

// メール送信可能な設定を通過したかのフラグ
$canSendMail	= false;
// スクリプト実行ログファイルURI
$scriptLogUri	= '/shopping/scripts/reminder/'.date('Y').'/'.date('m').'.log';
//
// 処理開始
//
$systemPackageConfigObject	= new system_PackageConfig();
if( $systemPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$GLOBALS['request']->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
}
$memberPackageConfigObject	= new member_PackageConfig();
if( $memberPackageConfigObject->load($GLOBALS['request']) ) {
} else {
	$GLOBALS['request']->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
}
// メール送信オブジェクト作成
$mailClassName	= '';
$mailSendOptions		= array();
if( defined('MEMBER_MAIL_SEND_METHOD') && strlen(MEMBER_MAIL_SEND_METHOD) > 0 ) {
	// 会員パッケージの設定
	if( is_array($GLOBALS['SYSTEM_SEND_METHOD'][MEMBER_MAIL_SEND_METHOD]) ) {
		$mailClassName	= $GLOBALS['SYSTEM_SEND_METHOD'][MEMBER_MAIL_SEND_METHOD]['class_name'];
		if( is_array($GLOBALS['MEMBER_MAIL_SEND_METHOD_OPTIONS']) ) {
			$mailSendOptions		= $GLOBALS['MEMBER_MAIL_SEND_METHOD_OPTIONS'];
		}
	}
}
if( strlen($mailClassName) == 0 ) {
	// 会員パッケージの設定がないならシステム設定の取得を試みる
	if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php') ) {
		require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'system.define.inc.php');
		if( defined('SYSTEM_MAIL_SEND_METHOD') && strlen(SYSTEM_MAIL_SEND_METHOD) > 0 ) {
			if( is_array($GLOBALS['SYSTEM_SEND_METHOD'][SYSTEM_MAIL_SEND_METHOD]) ) {
				$mailClassName	= $GLOBALS['SYSTEM_SEND_METHOD'][SYSTEM_MAIL_SEND_METHOD]['class_name'];
				if( is_array($GLOBALS['SYSTEM_MAIL_SEND_METHOD_OPTIONS']) ) {
					$mailSendOptions		= $GLOBALS['SYSTEM_MAIL_SEND_METHOD_OPTIONS'];
				}
			}
		}
	}
}
if( strlen($mailClassName) == 0 ) {
	$GLOBALS['request']->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
}

//
// メール送信可能状態での確認
//
if( $GLOBALS['request']->isError() ) {
	// ここまででエラーがある場合はログを記録して終了
	foreach( $GLOBALS['request']->errors as $error ) {
		$GLOBALS['request']->error( $receiveMail->from.' - '. $error, $scriptLogUri );
	}
	exit(0);
} else {
	// メール送信自体は可能な場合
	$canSendMail	= true;
}

//
// データベースに接続する
//
database2_Connect::execute( $GLOBALS['request'] );
$dbo	= $GLOBALS['request']->getAttribute('dbo');
$joinFormUrl	= $memberPackageConfigObject->definitionHash['MEMBER_REGIST_MAIL_URL'].$registKey;
list($protocol,$sp,$fqdn,$etc)	= explode('/',$joinFormUrl);
$baseUrl		= $protocol.'//'.$fqdn.'/';

//
// 一週間後が開始日の予約情報を確認
//
if( !$GLOBALS['request']->isError() ) {
	$nextWeekDate	= date('Y-m-d',strtotime('+7 day'));
	$sDateTime		= $nextWeekDate.' 00:00:00';
	$eDateTime		= $nextWeekDate.' 23:59:59';
	$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_ORDER
	.' WHERE status_flag = 10'
	.' AND order_id IN ( SELECT '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.order_id'
	.' FROM '.TABLE_NAME_SHOPPING_ORDER_ITEM
	.' WHERE '.TABLE_NAME_SHOPPING_ORDER_ITEM.'.svc_start_date BETWEEN '
	.$dbo->quote($sDateTime).' AND '.$dbo->quote($eDateTime).' )';
	$shoppingOrderObject	= new shopping_DaoShoppingOrder();
	$result			= $dbo->queryAll( $sql,$shoppingOrderObject,true );
	if ( false === $result ) {
		$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
	} else {
		foreach( $result as $shoppingOrderObject ){
			// 全ての予約情報にメール送信
				// 申し込み者へのメール通知
			$memberObject	= & $shoppingOrderObject->memberObject;
			$targetMail		= null;
			if( ( $shoppingOrderObject->mail_flag == 2 || $shoppingOrderObject->mail_flag == 12 )
			&& strlen($memberObject->mb_mail) > 0 ) {
				$targetMail	= $memberObject->mb_mail;
			} else if( strlen($memberObject->pc_mail) > 0 ) {
				$targetMail	= $memberObject->pc_mail;
			}
			if( strlen($targetMail) > 0 ){
				if( $shoppingOrderObject->sendInformationMail( $request, $targetMail, 'SHOPMAILSRVRMD', null, '', array(), null ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.failtomail',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		}
	}
}
//
// データベース切断
//
database2_Connect::post_process( $GLOBALS['request'] );
// ログを記録
if( $GLOBALS['request']->isError() ) {
	// エラーがあるならエラーログを記録
	$GLOBALS['request']->fatal( '[error]'.$receiveMail->from.' - '.implode(':',$GLOBALS['request']->errors), $scriptLogUri );
	exit(0);
} else {
	// エラーがないなら正常送信ログを記録
	$GLOBALS['request']->fatal( '[SENT OK]'.$receiveMail->from.' - '.implode(':',$GLOBALS['request']->errors), $scriptLogUri );
	exit(0);
}
?>