<?php
/*
 * shopping/product/unit/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_Confirm extends system_login_ModuleBase {
	function shopping_product_Confirm(){
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$productNumber		= stripslashes( $_GET['shpdn'] );
		$searchDataId		= stripslashes( $_GET['schdi'] );
		$sessionObjectName	= 'shopping.product.modify.object.'.$productNumber.'.'.$searchDataId;
		$sessionConfirmName	= 'shopping.product.modify.confirm.'.$productNumber.'.'.$searchDataId;
		// セッション上にあるなら一時アップロードファイルを削除
		$shoppingProductObject	= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductObject ) && is_object($shoppingProductObject->uploader) ) {
			$shoppingProductObject->uploader->deleteTempFiles( $request );
			$request->removeSession($sessionObjectName);
			$request->removeSession($sessionConfirmName);
		}
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$loginUserObject	= $this->getLoginUserObject( $request );

		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}

		if( !$request->isError() ) {
			if( strlen(trim($productNumber)) > 0 ) {
				// データ番号が指定されているなら編集の為読み込み
				if( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ) {
					if( false === $this->lockData( $request, $shoppingProductObject ) ) {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else if ( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel()
						&& $loginUserObject->getUniqueId() != $shoppingProductObject->owner_id ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else {
						// 検索データ連携
						if( $shoppingProductObject->loadSearchData( $request, $loginUserObject )
						&& !is_null($shoppingProductObject->searchDataObject) ){
							// 読み込みできたなら所有者は検索データに合わせる
							$shoppingProductObject->owner_id	= $shoppingProductObject->searchDataObject->owner_id;
						} else {
							// 関連検索データがない場合はログイン者のIDを所有者にする
							$shoppingProductObject->owner_id	= $loginUserObject->getUniqueId();
						}
					}
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array(''));
				}
			} else {
				// 検索データ連携
				$searchDataId	= $request->getParam('search_data_id','post');
				$shoppingProductObject->search_data_id	= $searchDataId;
				if( $shoppingProductObject->loadSearchData( $request, $loginUserObject )
				&& !is_null($shoppingProductObject->searchDataObject) ){
					// 読み込みできたなら所有者は検索データに合わせる
					$shoppingProductObject->owner_id	= $shoppingProductObject->searchDataObject->owner_id;
				} else {
					// 関連検索データがない場合はログイン者のIDを所有者にする
					$shoppingProductObject->owner_id	= $loginUserObject->getUniqueId();
				}
			}
	
			// 入力値のセットとチェック
			$product_id									= $request->getParam('product_id','post');
			$shoppingProductObject->product_name		= $request->getParam('product_name','post');
			$shoppingProductObject->product_kana		= $request->getParam('product_kana','post');
			$shoppingProductObject->product_kana		= $request->getParam('product_kana','post');

			$shoppingProductObject->memberViewableArray		= $_POST['member_viewable'];
			$shoppingProductObject->memberPurchasableArray	= $_POST['member_purchasable'];

			$shoppingProductObject->keywords			= $request->getParam('keywords','post');
			$shoppingProductObject->catch_copy			= $request->getParam('catch_copy','post');
			$shoppingProductObject->product_url			= $request->getParam('product_url','post');
			$shoppingProductObject->description			= $request->getParam('description','post');
			$shoppingProductObject->detail_comment		= $request->getParam('detail_comment','post');
			$shoppingProductObject->unit_string			= $request->getParam('unit_string','post');
			$shoppingProductObject->calendar_type			= $request->getParam('calendar_type','post');
			
			// オプション入力
			for( $n=1; $n<=5; $n++ ){
				$nName = 'option'.$n.'_name';
				$shoppingProductObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_items';
				$shoppingProductObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_explanation';
				$shoppingProductObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_calculate';
				$shoppingProductObject->$nName	= $request->getParam($nName,'post');
			}

			$shoppingProductObject->wholesaler_name		= $request->getParam('wholesaler_name','post');
			$shoppingProductObject->wholesaler_email	= $request->getParam('wholesaler_email','post');
			$shoppingProductObject->wholesaler_note		= $request->getParam('wholesaler_note','post');

			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインの場合のみ、商品IDをオブジェクトにセット
				if ( strlen(trim($product_id)) > 0 ) {
					$shoppingProductObject->product_id		= $product_id;
				}
				$shoppingProductObject->delivery_type		= $request->getParam('delivery_type','post');
				$shoppingProductObject->order_number		= $request->getParam('order_number','post');
			} else {
				// 管理者ログイン以外の場合は新規の場合のみ配送タイプ指定可能
				if( strlen($shoppingProductObject->product_number)==0){
					$shoppingProductObject->delivery_type		= $request->getParam('delivery_type','post');
				}
				// 順序番号は100以上のみ指定可能
				if( $request->getParam('order_number','post') > 100 ){
					$shoppingProductObject->order_number		= $request->getParam('order_number','post');
				}
			}
			// カテゴリIDの入力
			$shoppingProductObject->categoryIdArray	= $request->getParam('category_id','post','array');
			// 関連商品の入力
			$shoppingProductObject->relatedProductIdArray	= $request->getParam('related_product_id','post','array');
			// カナ・英数字変換
			$shoppingProductObject->convertKanaFields('KVas');
			// 入力値の妥当性検査を行う
			$shoppingProductObject->validate( $request );
			
			// 販売単位同時作成入力があるなら処理
			$this->setShoppingProductUnitObject( $request, $shoppingProductObject );

			// 削除ファイルの指示
			$delete_fileIdArray	= $_POST['delete_fileIdArray'];
			if( is_array( $delete_fileIdArray ) ) {
				$newFileIdArray	= array();
				foreach($shoppingProductObject->fileIdArray as $key => $tFileId ) {
					if( !in_array($tFileId,$delete_fileIdArray) ) {
						// 削除対象にないなら追加
						$newFileIdArray[$key]	= $tFileId;
					}
				}
				$shoppingProductObject->fileIdArray	= $newFileIdArray;
			}
			// ファイルアップロード
			if( !$request->isError() ) {
				$uploader	= new file_Uploader('productfiles');
				$shoppingProductObject->uploader	= & $uploader;
				if( $uploader->isUploaded() ) {
					if( $uploader->validate( $request ) ) {
						if( $uploader->upload( $request ) ) {
							// 商品画像0～99のキー分のみ画像マックスサイズまでリサイズする
							foreach( $uploader->fileBinObjectHash as $fileNumber => $fileBinObject ) {
								if( $fileNumber < 100 ) {
									// 登録一時URI
									$regTmpAPath	= system_DataFileWriter::getRealAbsolutePath( $request, $fileBinObject->registTmpUri, DIR_NAME_TMP );
									$imageInfoHash	= getimagesize($regTmpAPath);
									if( $imageInfoHash !== false
										&& ( $imageInfoHash[0] > SHOPPING_PRODUCT_IMAGE_MAX_WIDTH || $imageInfoHash[1] > SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT ) ) {
										// 最大登録サイズより大きいならリサイズ
										$localTmpPath	= DIR_PATH_TMP.'/shopping';
										if( !file_exists($localTmpPath) ) {
											if( @mkdir($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
												@chmod($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER);
											}
										}
										$localTmpPath	.= '/product';
										if( !file_exists($localTmpPath) ) {
											if( @mkdir($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
												@chmod($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER);
											}
										}
										$localTmpPath	.= '/'.basename($fileBinObject->registTmpUri);
										if( util_File::resizeImage( $regTmpAPath, $localTmpPath, SHOPPING_PRODUCT_IMAGE_MAX_WIDTH, SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT ) ) {
											system_DataFileWriter::import( $request, $fileBinObject->registTmpUri, $localTmpPath, DIR_NAME_TMP );
										} else {
											$request->addLocaledError('shopping.error.order.download.resize',SPIDER_LOG_LEVEL_ERROR,array($fileNumber+1));
										}
										@unlink($localTmpPath);
									}
								}
							}
						}
					}
				}
			}
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingProductObject);
		$request->setAttribute('shopping.product.product_object',		$shoppingProductObject);
	}
	/**
	 * 販売単位を同時作成する入力がある場合にオブジェクトに設定する（新規商品作成の場合のみ）
	 */
	function setShoppingProductUnitObject( & $request, & $shoppingProductObject ) {
		if( isset($_POST['unit_unit_name']) && isset($_POST['unit_price_standard']) && isset($_POST['unit_price_sell']) ) {
			$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
			if( is_object($shoppingProductObject->unitObjectArray[0]) ) {
				$shoppingProductUnitObject	= & $shoppingProductObject->unitObjectArray[0]; 
			} else {
				// 商品からの自動設定
				$shoppingProductUnitObject->product_id		= $shoppingProductObject->product_id;
				$shoppingProductUnitObject->unit_string		= $shoppingProductObject->unit_string;
				$shoppingProductUnitObject->delivery_type	= $shoppingProductObject->delivery_type;
				$shoppingProductUnitObject->owner_id		= $shoppingProductObject->owner_id;
				$shoppingProductUnitObject->order_number	= 0;
				$shoppingProductUnitObject->memberViewableArray		= $shoppingProductObject->memberViewableArray;
				$shoppingProductUnitObject->memberPurchasableArray	= $shoppingProductObject->memberPurchasableArray;
				if( defined('SHOPPING_RESERVE_ENABLE_START') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_START) > 0 ) {
					$shoppingProductUnitObject->rsv_permit_start	= SHOPPING_RESERVE_ENABLE_START;
				}
				if( defined('SHOPPING_RESERVE_ENABLE_LIMIT') && preg_match('/^[0-9]{1,3}$/',SHOPPING_RESERVE_ENABLE_LIMIT) > 0 ) {
					$shoppingProductUnitObject->rsv_permit_limit	= SHOPPING_RESERVE_ENABLE_LIMIT;
				}
			}
			// 入力を取得
			$unit_id											= $request->getParam('unit_unit_id','post');
			$shoppingProductUnitObject->unit_name				= $request->getParam('unit_unit_name','post');
			$shoppingProductUnitObject->unit_kana				= $request->getParam('unit_unit_kana','post');
			$shoppingProductUnitObject->delivery_weight			= $request->getParam('unit_delivery_weight','post');
			$shoppingProductUnitObject->price_standard			= $request->getParam('unit_price_standard','post');
			$shoppingProductUnitObject->price_sell				= $request->getParam('unit_price_sell','post');
			$shoppingProductUnitObject->cost					= $request->getParam('unit_cost','post');
			$shoppingProductUnitObject->price_monthly			= $request->getParam('unit_price_monthly','post');
			$shoppingProductUnitObject->stock					= $request->getParam('unit_stock','post');
			$shoppingProductUnitObject->stock_relation			= $request->getParam('unit_stock_relation','post');
			$shoppingProductUnitObject->stock_relation_count	= $request->getParam('unit_stock_relation_count','post');
			$shoppingProductUnitObject->stock_display			= $request->getParam('unit_stock_display','post');
			$shoppingProductUnitObject->present_point			= $request->getParam('unit_present_point','post');
			$shoppingProductUnitObject->discount_exception		= $request->getParam('unit_discount_exception','post');
			$shoppingProductUnitObject->stock_relation			= $request->getParam('unit_stock_relation','post');
			$shoppingProductUnitObject->max_at_once				= $request->getParam('unit_max_at_once','post');
			$shoppingProductUnitObject->default_start_time		= $request->getParam('unit_default_start_time','post');
			$shoppingProductUnitObject->service_term			= $request->getParam('unit_service_term','post');
			$shoppingProductUnitObject->description				= $request->getParam('unit_description','post');
			$shoppingProductUnitObject->detail_comment		= $request->getParam('unit_detail_comment','post');
			$shoppingProductUnitObject->calendar_type			= $request->getParam('unit_calendar_type','post');
			
			// 妥当性検査
			$shoppingProductUnitObject->validate( $request );
			if( is_object($shoppingProductObject->unitObjectArray[0]) ) {
			} else {
				// オブジェクトに設定
				$shoppingProductObject->unitObjectArray			= array();
				array_push($shoppingProductObject->unitObjectArray, $shoppingProductUnitObject );
			}
		}
	}
}
?>