<?php
/*
 * shopping/order/option/type/SelectDate.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'DaoShoppingOrderOption.class.php' );
class shopping_order_option_type_SelectDate extends shopping_DaoShoppingOrderOption {
	/**
	 * Constructor
	 */
	function shopping_order_option_type_SelectDate() {
	}
	/**
	 * 妥当性検査を行うメソッド
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 * @param $value 妥当性検査を行う入力値
	 * @return array エラーメッセージの配列
	 */
	function validate( & $request, $value ) {
		$errors	= array();
		if( $this->required ) {
			// 必須の場合
			if( !is_array($value) || count($value) == 0 ) {
				array_push( $errors, $this->optionName.'を選択してください。');
			} else if( count($value) < 3 ) {
				array_push( $errors, $this->optionName.'の年月日を全て選択してください。');
			} else if( preg_match('/^[12][0-9][0-9][0-9]$/',$value[0]) == 0 ){
				array_push( $errors, $this->optionName.'の年を正しく入力してください。');
			} else if( preg_match('/^[0-9]{1,2}$/',$value[1]) == 0 || $value[1] < 1 || $value[1] > 12 ){
				array_push( $errors, $this->optionName.'の月を正しく入力してください。');
			} else if( preg_match('/^[0-9]{1,2}$/',$value[2]) == 0 || $value[2] < 1 || $value[2] > 31 ){
				array_push( $errors, $this->optionName.'の日を正しく入力してください。');
			} else {
				if( !checkdate( $value[1], $value[2], $value[0] ) ) {
					array_push( $errors, $this->optionName.'を正しく入力してください。'.print_r($value,true));
				}
			}
		}
		return $errors;
	}
	/**
	 * 入力フォームを表示する抽象メソッド 
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 * @param $value 入力値
	 * @return strings 入力フォームHTML文字列
	 */
	function getInputForm( & $request, $value='', $background=null, $formNameNames=null, $formNameValue=null ) {
		$optionHash			= array();
		$this->options		= str_replace("\r\n","\n",$this->options);
		$this->options		= str_replace("\r","\n",$this->options);
		list( $startYear, $endYear )	= explode("\n",$this->options);
		if( preg_match('/^(|\\-)[0-9]{1,3}$/',$startYear) == 0 ) {
			$startYear	= 0;
		}
		if( preg_match('/^(|\\-)[0-9]{1,3}$/',$endYear) == 0 ) {
			$endYear	= 3;
		}
		if( $endYear < $startYear ) {
			$tmp		= $endYear;
			$endYear	= $startYear;
			$startYear	= $tmp;
		}
		
		if( !is_array($value) ) {
			if( strlen($value) > 0 ) {
				$value	= explode('/',$value);
			}
		}

		$inputNameName	= 'option_names';
		if( !is_null($formNameNames) || strlen($formNameNames) > 0 ) {
			$inputNameName	= $formNameNames;
		}
		$inputNameValue	= 'option_values';
		if( !is_null($formNameValue) || strlen($formNameValue) > 0 ) {
			$inputNameValue	= $formNameValue;
		}
		$strings	= '<input type="hidden" name="'.$inputNameName.'['.$this->optionNumber.']" value="'.$this->optionName.'" />';
		// 年
		$strings	.= '<select name="'.$inputNameValue.'['.$this->optionNumber.'][]"';
		if( strlen($background) > 0 ) {
			$strings	.= ' style="background-color:'.$background.';"';
		}
		$strings	.= '>';
		if( $this->required ) {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>必須</option>';
		} else {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>選択</option>';
		}
		for( $i=date('Y')+$startYear; $i<=date('Y')+$endYear; $i++ ) {
			$strings	.= '<option value="'.$i.'"';
			if( is_array($value) && $value[0] == $i ) {
				$strings	.= ' selected';
			}
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>'.$i.'</option>';
		}
		$strings	.= '</select>年';
		// 月
		$strings	.= '<select name="'.$inputNameValue.'['.$this->optionNumber.'][]"';
		if( strlen($background) > 0 ) {
			$strings	.= ' style="background-color:'.$background.';"';
		}
		$strings	.= '>';
		if( $this->required ) {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>必須</option>';
		} else {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>選択</option>';
		}
		for( $i=1; $i<=12; $i++ ) {
			$strings	.= '<option value="'.sprintf('%02d',$i).'"';
			if( is_array($value) && $value[1] == sprintf('%02d',$i) ) {
				$strings	.= ' selected';
			}
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>'.sprintf('%02d',$i).'</option>';
		}
		$strings	.= '</select>月';
		// 日
		$strings	.= '<select name="'.$inputNameValue.'['.$this->optionNumber.'][]"';
		if( strlen($background) > 0 ) {
			$strings	.= ' style="background-color:'.$background.';"';
		}
		$strings	.= '>';
		if( $this->required ) {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>必須</option>';
		} else {
			$strings	.= '<option value=""';
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>選択</option>';
		}
		for( $i=1; $i<=31; $i++ ) {
			$strings	.= '<option value="'.sprintf('%02d',$i).'"';
			if( is_array($value) && $value[2] == sprintf('%02d',$i) ) {
				$strings	.= ' selected';
			}
			if( strlen($background) > 0 ) {
				$strings	.= ' style="background-color:'.$background.';"';
			}
			$strings	.= '>'.sprintf('%02d',$i).'</option>';
		}
		$strings	.= '</select>日';
		
		return $strings;
	}
}
?>