<?php
/*
 * shopping/order/TransferCart.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * ログイン・ログアウト時に買い物かごの選択商品を引き継ぐモジュール
 */
class shopping_order_TransferCart extends system_login_ModuleBase {
	var $shoppingOrderObject	= null;
	function shopping_order_TransferCart() {
	}
	function execute( & $request ) {
		$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT;
		$loginUserObject		= $this->getLoginUserObject( $request );
		$this->shoppingOrderObject	= null;
		if( $request->existsSession($sessionObjectName) ) {
			// セッションに存在するなら
			$this->shoppingOrderObject	= $request->getSession($sessionObjectName);
		}
	}
	/**
	 * モジュールの後処理を行います。
	 * @param $request 
	 */
	function post_process( & $request ) {
		$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT;
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( !is_null($this->shoppingOrderObject) ) {
			$this->shoppingOrderObject->memberObject	= null;
			if( $this->isLogin($request)
			&& SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel()) {
				$this->shoppingOrderObject->memberObject	= $loginUserObject;
			}
			$request->setSession($sessionObjectName,$this->shoppingOrderObject,SPIDER_SESSION_SCOPE_GLOBAL);
		}
	}
}
?>