<?php
/*
 * shopping/calendar/Add.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_calendar_AddTerm extends system_login_ModuleBase {
	
	function shopping_calendar_AddTerm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$startTime		= $request->getParam('start_time','post');
		$closeTime		= $request->getParam('close_time','post');
		$startDate		= $request->getParam('start_date','post');
		$closeDate		= $request->getParam('close_date','post');
		$productId		= $request->getParam('product_id','post');
		$unitId				= $request->getParam('unit_id','post');
		$priceSell		= $request->getParam('price_sell','post');
		$stock				= $request->getParam('stock','post');
		$scheduleNote	= $request->getParam('schedule_note','post');
		// 妥当性検査
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( strlen($startDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.startdayrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDateFormat($startDate) ) {
			$request->addLocaledError('shopping.error.calendar.startdayoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($closeDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.enddayrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDateFormat($closeDate) ) {
			$request->addLocaledError('shopping.error.calendar.enddayoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($startTime) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.starthourrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableTimeFormat($startTime) ) {
			$request->addLocaledError('shopping.error.calendar.starthouroutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($closeTime) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.endhourrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableTimeFormat($closeTime) ) {
			$request->addLocaledError('shopping.error.calendar.endhouroutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($productId) > 0 ) {
			// 商品指定があるなら存在チェック
			if( strlen($productId) > 16 ) {
				$request->addLocaledError('shopping.error.product.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById($shoppingProductObject,$productId) ) {
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		}
		if( strlen($unitId) > 0 ) {
			// 販売単位指定があるなら存在チェック
			if( strlen($unitId) > 16 ) {
				$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( $dbo->loadById($shoppingProductUnitObject,$unitId) ) {
					if( preg_match('/^[0-9]{0,6}$/',$priceSell) == 0 ) {
						$priceSell	= null;
						$request->addLocaledError('shopping.error.calendar.invalidprice',SPIDER_LOG_LEVEL_ERROR,array());
					}
					if( preg_match('/^[0-9]{0,6}$/',$stock) == 0 ) {
						$stock	= null;
						$request->addLocaledError('shopping.error.calendar.invalidstock',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$priceSell	= null;
		}
		// 問題ないならインサート
		if( $request->isError() ) {
		} else {
			for( $targetTime=strtotime($startDate); $targetTime<=strtotime($closeDate); $targetTime=$targetTime+(60*60*24)){
				$targetStartDatetime	= date('Y-m-d '.$startTime,$targetTime);
				$targetCloseDatetime	= date('Y-m-d '.$closeTime,$targetTime);
				$sql	= '';
				$priceSellVal	= $priceSell;
				if( is_null($priceSellVal) || strlen($priceSellVal)==0) {
					$priceSellVal	= 'NULL';
				}
				$stockVal	= $stock;
				if( is_null($stockVal) || strlen($stockVal)==0) {
					$stockVal	= 'NULL';
				}
				$unitIdVal	= $dbo->quote($unitId);
				if( is_null($unitId) || strlen($unitId)==0) {
					$unitIdVal	= 'NULL';
				}
				$productIdVal	= $dbo->quote($productId);
				if( is_null($productId) || strlen($productId)==0) {
					$productIdVal	= 'NULL';
				}
				// 重複時間に設定しようとしていないか確認する
				$sql	= 'SELECT COUNT(schedule_number) FROM '.TABLE_NAME_SHOPPING_CALENDAR
				.' WHERE ('
				.' start_date BETWEEN '.$dbo->quote($targetStartDatetime).' AND '.$dbo->quote($targetCloseDatetime)
				.' OR '
				.' close_date BETWEEN '.$dbo->quote($targetStartDatetime).' AND '.$dbo->quote($targetCloseDatetime).')';
				if( is_null($unitId) || strlen($unitId)==0){
					$sql	.= ' AND (unit_id='.$dbo->quote('').' OR unit_id IS NULL )';
				} else {
					$sql	.= ' AND unit_id='.$dbo->quote($unitId);
				}
				
				if( is_null($productId) || strlen($productId)==0){
					$sql	.= ' AND (product_id='.$dbo->quote('').' OR product_id IS NULL )';
				} else {
					$sql	.= ' AND product_id='.$dbo->quote($productId);
				}
				$depCount	= $dbo->queryOne($sql);
				if( false === $depCount ){
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
				} else if( $depCount > 0 ){
				} else {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_CALENDAR.'(start_date,close_date,product_id,unit_id,price_sell,stock,schedule_note) VALUES ('
					.$dbo->quote($targetStartDatetime).','.$dbo->quote($targetCloseDatetime).','.$productIdVal.','.$unitIdVal.','.$priceSellVal.','.$stockVal.','.$dbo->quote($scheduleNote).')';
					if( $dbo->query($sql) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array($sql));
					}
				}
			}
		}
		$request->setAttribute('shopping.calendar.startDate', $startDate);
		$request->setAttribute('shopping.calendar.closeDate', $closeDate);
		$request->setAttribute('shopping.calendar.startTime', $startTime);
		$request->setAttribute('shopping.calendar.closeTime', $closeTime);
		$request->setAttribute('shopping.calendar.scheduleNote', $scheduleNote);
		$request->setAttribute('shopping.calendar.productId', $productId);
		$request->setAttribute('shopping.calendar.unitId', $unitId);
		$request->setAttribute('shopping.calendar.priceSell', $priceSell);
	}
}
?>