<?php
/*
 * member/member/correspond/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_Execute extends system_login_ModuleBase {
	function member_member_correspond_Execute() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$memberId					= trim(stripslashes( $_GET['mi'] ));
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$sessionObjectName			= 'member.member.correspond.modify.object.'.$memberId.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.modify.confirm.'.$memberId.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= $request->getSession($sessionObjectName);
		$compareCorrespondObject	= spider_Controller::createObject('member_DaoMemberCorrespond');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$comfirmResult				= $request->getSession($sessionConfirmName);

		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($correspondObject) != get_class($compareCorrespondObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
			// 変更者のIDを登録
			$correspondObject->modifier_id	= $loginUserObject->getUniqueId();
			if( strlen(trim($correspondObject->correspond_id)) > 0 ) {
				// IDが設定済みなら更新
				$correspondObject->updated_date	= date('Y-m-d H:i:s');
				if( $correspondObject->canEditData( $request, $loginUserObject ) ) {
					if( $this->lockData( $request, $correspondObject ) ) {
						if( $dbo->update($correspondObject,false) ) {
						} else {
							$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
						}
						$this->unlockData( $request, $correspondObject );
					} else {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// IDがないならインサート
				if( !$dbo->setNextId( $correspondObject, 'MBAAAAAA{num:8}' ) ) {
					$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(""));
				} else {
					$correspondObject->modifier_id		= $loginUserObject->getUniqueId();
					$correspondObject->owner_id			= $loginUserObject->getUniqueId();
					$correspondObject->updated_date		= date('Y-m-d H:i:s');
					$correspondObject->registered_date	= date('Y-m-d H:i:s');
					if( $dbo->insert($correspondObject) ){
					} else {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.correspond.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.correspondObject',$correspondObject);
	}
}
?>