<?php
/*
 * member/member/bank/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Hiroki Koga
 * Last Update: 2010-09-14
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_bank_Execute extends system_login_ModuleBase {
	function member_member_bank_Execute() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.member.Load' );
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$accountId				= stripslashes( $_GET['aci'] );
		$sessionObjectName		= 'member.member.bank.modify.object.'.$accountId;
		$sessionConfirmName		= 'member.member.bank.modify.confirm.'.$accountId;
		$bankAccountObject		= $request->getSession($sessionObjectName);
		$compareBankAccoutObject	= spider_Controller::createObject('member_DaoMemberBankAccount');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$comfirmResult			= $request->getSession($sessionConfirmName);
		
		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($bankAccountObject) != get_class($compareBankAccoutObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 読み込めたら編集可能か確認
			if( $bankAccountObject->canEditData( $request, $loginUserObject ) ) {
				// 変更者のIDを登録
				$bankAccountObject->modifier_id	= $loginUserObject->getUniqueId();
				$bankAccountObject->convertKanaFields( 'KVa' );
				$bankAccountObject->updated_date	= date('Y-m-d H:i:s');
				if( strlen(trim($bankAccountObject->account_number)) > 0 ) {
					// 更新
					if( $dbo->update($bankAccountObject,false) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
					}
				} else {
					// 新規
					if( $dbo->setNextId( $bankAccountObject, 'MBAA{num:4}' ) ) {
						$bankAccountObject->owner_id			= $loginUserObject->getUniqueId();
						$bankAccountObject->registered_date	= date('Y-m-d H:i:s');
						if( $dbo->insert($bankAccountObject) ){
						} else {
							$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(""));
						}
					} else {
						$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(""));
					}
				}
			} else {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.bank.memberBankAccoutObject',$bankAccountObject);
	}
}
?>