<?php
/*
 * member/member/Select.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 選択操作用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Select extends system_login_ModuleBase {
	function member_member_Select(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$command			= $request->getParam('command','post');
		$memberId			= $request->getParam('member_id','post');
		$page_rows			= $request->getParam('pr','get');
		$page_number		= $request->getParam('pn','get');
		if ( !is_numeric( $page_number ) || $page_number < 1 ) {
			$page_number	= 1;
		}
		if ( !is_numeric( $page_rows ) || $page_rows < 1 ) {
			$page_rows		= 20;
		} else if ( $page_rows > 100 ) {
			$page_rows		= 20;
		}
		// セッションから選択リストを取得する。ハッシュ[member_id]=>[handle_name]
		$sessionSelectedHash			= $request->getSession( MEMBER_SESSION_NAME_SELECTED_LIST );
		if( !is_array($sessionSelectedHash) ) {
			$sessionSelectedHash		= array();
		}
		
		// ページ計算
		$total_count	= count($sessionSelectedHash );
		$total_page		= ceil( $total_count / $page_rows );
		$offset			= $page_rows * ( $page_number - 1 );
		
		// 入力された会員IDの整理
		$input_member_id_array		= array();
		if( is_array($memberId) ) {
			foreach( $memberId as $mid ) {
				if( strlen(trim($mid)) > 0 ) {
					array_push( $input_member_id_array, $mid );
				}
			}
		} else {
			$memberId	= trim(stripslashes($memberId));
			if( strlen($memberId) > 0 ) {
				array_push( $input_member_id_array, $memberId );
			}
		}
		
		// コマンドが指定されているならコマンド操作
		if( preg_match('/([aA][dD][dD]|[sS][eE][lL][eE][cC][tT])/',$command ) > 0 ) {
			// 追加コマンドの場合
			if( count($input_member_id_array) == 0 ) {
				$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				foreach( $input_member_id_array as $mid ) {
					$member_name	= $sessionSelectedHash[$mid];
					if( !is_null($member_name) || strlen($member_name) > 0 ) {
						// すでにある場合は何もしない
					} else {
						$memberObject	= spider_Controller::createObject('member_DaoMember');
						if( $dbo->loadById( $memberObject, $mid ) && $memberObject->status_flag < 200 ) {
							// 会員が存在するならリストに追加
							$key	= $mid;
							$value	= $memberObject->getUserViewName();
							$sessionSelectedHash[$key]	= $value;
						} else {
							$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
				}
			}
		} else if( preg_match('/([dD][rR][oO][pP]|[dD][eE][lL][eE][tT][eE])/',$command ) > 0 ) {
			// 削除コマンドの場合
			foreach( $input_member_id_array as $mid ) {
				unset( $sessionSelectedHash[$mid] );
			}
		}
		
		// 選択済み会員オブジェクトリストを作成
		$memberObject_array	= array();
		$i = 0;
		foreach( $sessionSelectedHash as $memberId => $handle_name ) {
			if( $i >= $offset && $i<$offset+$page_rows ) {
				$memberObject	= spider_Controller::createObject('member_DaoMember');
				if( $dbo->loadById( $memberObject, $memberId ) ){
					array_push( $memberObject_array, $memberObject );
				}
			} else if( $i>=$offset+$page_rows) {
				break;
			}
			$i++;
		}
		
		// 属性およびセッションを再登録
		$request->setSession( MEMBER_SESSION_NAME_SELECTED_LIST, $sessionSelectedHash, SPIDER_SESSION_SCOPE_GLOBAL );
		$last_search_uri			= $request->getSession( MEMBER_SESSION_NAME_LAST_SEARCH_LIST_URI );
		if( is_null($last_search_uri) || strlen($last_search_uri) == 0 ) {
			$last_search_uri	= './index.php';
		}
		$request->setAttribute('member.member.select.selected_hash',$sessionSelectedHash);
		$request->setAttribute('member.member.select.selected_member_object_array',$memberObject_array);
		$request->setAttribute('member.member.select.last_search_uri',$last_search_uri);
		$request->setAttribute('member.member.select.total_count', $total_count );
		$request->setAttribute('member.member.select.total_page', $total_page );
		$request->setAttribute('member.member.select.page_number', $page_number );
		$request->setAttribute('member.member.select.page_rows', $page_rows );

		$has_next_page	= false;
		if( $page_number < $total_page ) {
			$has_next_page	= true;
		}
		$request->setAttribute('member.member.select.has_next_page', $has_next_page );
		$has_prev_page	= false;
		if( $page_number > 1 ) {
			$has_prev_page	= true;
		}
		$request->setAttribute('member.member.select.has_prev_page', $has_prev_page );
	}
}
?>