<?php
/*
 * member/member/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 編集フォーム表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Form extends system_login_ModuleBase {
	function member_member_Form() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberNumber			= stripslashes( $_GET['mn'] );
		$sessionObjectName		= 'member.member.modify.object.'.$memberNumber;
		$sessionConfirmName		= 'member.member.modify.confirm.'.$memberNumber;
		$memberObject			= $request->getSession($sessionObjectName);
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( get_class($compareMemberObject) == get_class($memberObject) ){
			// セッションに登録済みならそのまま利用する
			$memberObject->optimize();
		} else {
			// セッションにないなら作成する
			$memberObject			= spider_Controller::createObject('member_DaoMember');
			if( strlen(trim($memberNumber)) > 0 ) {
				// 顧客番号が指定されているなら編集のため読み込み
				if( $dbo->loadByNumber( $memberObject, $memberNumber ) ){
					// 読み込めたら編集可能か確認
					if( $memberObject->canEditData( $request, $loginUserObject ) ) {
						$memberObject->optimize();
						$memberObject->pc_mail_retype	= $memberObject->pc_mail;
						$memberObject->mb_mail_retype	= $memberObject->mb_mail;
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// IDが指定されていないなら新規作成
				if( defined('MEMBER_INITIAL_POINT') ) {
					$memberObject->point		= MEMBER_INITIAL_POINT;
				}
				// 一時コードが指定されている場合
				$temporaryId	= trim(stripslashes($_GET['tkey']));
				if( strlen($temporaryId) > 0 ) {
					// 1日以上前に記録されたデータは削除する(エラーは気にしない)
					$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_REGIST_TEMPORARY.' WHERE registered_date<'.$dbo->quote(date('Y-m-d H:i:s',strtotime('-1 day')));
					$dbo->query($sql);
					// 確認する
					$registTemporaryObject	= spider_Controller::createObject('member_DaoMemberRegistTemporary');
					if( $dbo->loadById($registTemporaryObject,$temporaryId) ) {
						$memberObject->mb_mail			= $registTemporaryObject->email;
						$memberObject->mb_mail_retype	= $registTemporaryObject->email;
					} else {
						$request->addLocaledError('member.error.join.nosavedmail',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		if( !$request->isError() ) {
			// member_idが設定済みならロック処理
			if( strlen($memberObject->member_id ) > 0 ) {
				if( false === $this->lockData( $request, $memberObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		
		$request->setAttribute('member.member.memberObject',$memberObject);
	}
}
?>