<?php
/*
 * member/member/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
if( file_exists(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'admin'
.DIRECTORY_SEPARATOR.'DaoAdminMember.class.php') ) {
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'admin'
.DIRECTORY_SEPARATOR.'DaoAdminMember.class.php' );
}
/**
 * spider : 会員テーブル操作 入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Confirm extends system_login_ModuleBase {
	function member_member_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberNumber			= stripslashes( $_GET['mn'] );
		$temporaryId			= trim(stripslashes($_GET['tkey']));		
		$sessionObjectName		= 'member.member.modify.object.'.$memberNumber;
		$sessionConfirmName		= 'member.member.modify.confirm.'.$memberNumber;
		$memberObject			= spider_Controller::createObject('member_DaoMember');
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		if( strlen(trim($memberNumber)) > 0 ) {
			// 会員IDが指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $memberObject, $memberNumber ) ) {
				// 読み込めたら編集可能か確認
				if( $memberObject->canEditData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					return false;
				}
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}
		// 1日以上前に記録された一時アドレスデータは削除する(エラーは気にしない)
		$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_REGIST_TEMPORARY.' WHERE registered_date<'.$dbo->quote(date('Y-m-d H:i:s',strtotime('-1 day')));
		$dbo->query($sql);
		
		if( strlen($temporaryId) > 0 ) {
			// 一時キーを伴うアクセスの場合はメール一時保存テーブルからメールアドレスを取り出す(携帯のみ)
			$registTemporaryObject	= spider_Controller::createObject('member_DaoMemberRegistTemporary');
			if( $dbo->loadById($registTemporaryObject,$temporaryId) ) {
				$memberObject->mb_mail					= $registTemporaryObject->email;
				$memberObject->mb_mail_retype			= $registTemporaryObject->email;
				$memberObject->isMobileMailValidated	= true;
			} else {
				$request->addLocaledError('member.error.join.nosavedmail',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if(strlen($memberObject->member_number)==0){
			if( ( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() )
			&& ( !defined('MEMBER_PERMIT_REGIST_BY_USER') || preg_match('/^[tT](|[rR][uU][eE])$/',MEMBER_PERMIT_REGIST_BY_USER) == 0 ) ) {
				$request->addLocaledError('member.error.join.nopublicreg',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		
		// この時点でエラーがあるなら残りは処理しない
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
			return false;
		}
		
		// member_idが設定済みならロック処理
		if( strlen($memberObject->member_number ) > 0 ) {
			if( false === $this->lockData( $request, $memberObject ) ) {
				$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}

		// 入力値のセットとチェック
		if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel()
				&& strlen($memberObject->member_number)==0
		) {
			// 管理者ログイン且つ新規登録の場合、顧客IDを設定
			$memberObject->member_id		= $request->getParam('member_id','post');
		}

		$memberObject->view_name	= $request->getParam('view_name','post');
		$loginPassword				= $request->getParam('login_password','post');
		if( strlen($loginPassword) > 0 ) {
			$memberObject->login_password	= $loginPassword;
		}
		
		// メンバーログインの場合はメールアドレスは変更しない
		if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			// 管理ログインでの変更の場合
			$memberObject->member_class		= $request->getParam('member_class','post');
			$memberObject->pc_mail			= $request->getParam('pc_mail','post');
			$memberObject->mb_mail			= $request->getParam('mb_mail','post');
		} else {
			// 管理ログインでない場合
			if(isset($_POST['member_class'])) {
				$memberObject->member_class		= $request->getParam('member_class','post');
			}
			// 会員種別の個人情報は選択不可
			if( strlen($memberObject->member_class_org)>0 && $memberObject->member_class == $memberObject->member_class_org ) {
				// 変更がない場合はエラーにしない
			} else if ( strlen(trim($memberObject->member_class)) == 0
			|| !array_key_exists($memberObject->member_class,$GLOBALS['MEMBER_MEMBER_REGISTABLE_CLASS_HASH']) ) {
				$request->addLocaledError('member.error.member.invalidclass',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			// PCメールアドレスの入力処理
			if( isset($_POST['pc_mail']) && $_POST['pc_mail'] != $memberObject->pc_mail ) {
				$memberObject->pc_mail			= $request->getParam('pc_mail','post');
				$memberObject->pc_mail_retype	= $request->getParam('pc_mail_retype','post');
				if( $memberObject->pc_mail != $memberObject->pc_mail_retype ) {
					$request->addLocaledError('member.error.member.invalidconfmail',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// 携帯メールアドレスの入力処理
			if( strlen($temporaryId) > 0 ) {
				// 一時キーからの入力の場合は検証しない
			} else if( isset($_POST['mb_mail']) && $_POST['mb_mail'] != $memberObject->mb_mail ) {
				// POST入力がある場合は入力を受け付ける
				$memberObject->mb_mail			= $request->getParam('mb_mail','post');
				$memberObject->mb_mail_retype	= $request->getParam('mb_mail_retype','post');
				if( $memberObject->mb_mail != $memberObject->mb_mail_retype ) {
					$request->addLocaledError('member.error.member.invalidconfmmail',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			if( strlen($memberObject->pc_mail)==0 && strlen($memberObject->mb_mail)==0 ) {
				$request->addLocaledError('member.error.member.requireemail',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			if( strlen($memberObject->member_number) == 0 ){
				// 会員登録時に携帯情報を設定する
				$memberObject->setMobileInformation( $request );
			} else if( !$request->isError() ) {
				// 更新の場合エラーがないなら変更チェック
				if( $memberObject->pc_mail != $memberObject->pc_mail_org ) {
					$memberObject->changePcMail	= true;
				} else {
					$memberObject->changePcMail	= false;
				}
				if( $memberObject->mb_mail != $memberObject->mb_mail_org ) {
					$memberObject->changeMobileMail	= true;
				} else {
					$memberObject->changeMobileMail	= false;
				}
				if( $memberObject->changePcMail && $memberObject->changeMobileMail ) {
					$request->addLocaledError('member.error.member.changeemailatonce',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		
		$memberObject->family_name	= $request->getParam('family_name','post');
		$memberObject->first_name	= $request->getParam('first_name','post');
		$memberObject->family_kana	= $request->getParam('family_kana','post');
		$memberObject->first_kana	= $request->getParam('first_kana','post');

		$memberObject->country_name				= $request->getParam('country_name','post');
		$memberObject->prefecture_number	= $request->getParam('prefecture_number','post');
		$memberObject->zip_code				= $request->getParam('zip_code','post');
		$memberObject->zip_code_pre			= $request->getParam('zip_code_pre','post');
		$memberObject->zip_code_pst			= $request->getParam('zip_code_pst','post');
		$memberObject->address				= $request->getParam('address','post');
		$memberObject->building				= $request->getParam('building','post');
		$memberObject->telephone_number			= $request->getParam('telephone_number','post');
		$memberObject->telephone_number_area	= $request->getParam('telephone_number_area','post');
		$memberObject->telephone_number_city	= $request->getParam('telephone_number_city','post');
		$memberObject->telephone_number_local	= $request->getParam('telephone_number_local','post');
		$memberObject->faximili_number			= $request->getParam('faximili_number','post');
		$memberObject->faximili_number_area		= $request->getParam('faximili_number_area','post');
		$memberObject->faximili_number_city		= $request->getParam('faximili_number_city','post');
		$memberObject->faximili_number_local	= $request->getParam('faximili_number_local','post');
		$memberObject->mobile_number			= $request->getParam('mobile_number','post');
		$memberObject->mobile_number_area	= $request->getParam('mobile_number_area','post');
		$memberObject->mobile_number_city	= $request->getParam('mobile_number_city','post');
		$memberObject->mobile_number_local	= $request->getParam('mobile_number_local','post');

		$memberObject->prefecture_number2	= $request->getParam('prefecture_number2','post');
		$memberObject->zip_code2			= $request->getParam('zip_code2','post');
		$memberObject->zip_code2_pre		= $request->getParam('zip_code2_pre','post');
		$memberObject->zip_code2_pst		= $request->getParam('zip_code2_pst','post');
		$memberObject->address2				= $request->getParam('address2','post');
		$memberObject->building2			= $request->getParam('building2','post');
		$memberObject->telephone_number2		= $request->getParam('telephone_number2','post');
		$memberObject->telephone_number2_area	= $request->getParam('telephone_number2_area','post');
		$memberObject->telephone_number2_city	= $request->getParam('telephone_number2_city','post');
		$memberObject->telephone_number2_local	= $request->getParam('telephone_number2_local','post');
		$memberObject->faximili_number2			= $request->getParam('faximili_number2','post');
		$memberObject->faximili_number2_area	= $request->getParam('faximili_number2_area','post');
		$memberObject->faximili_number2_city	= $request->getParam('faximili_number2_city','post');
		$memberObject->faximili_number2_local	= $request->getParam('faximili_number2_local','post');

		$memberObject->sex		= $request->getParam('sex','post');
		$memberObject->birth_year		= $request->getParam('birth_year','post');
		$memberObject->birth_month		= $request->getParam('birth_month','post');
		$memberObject->birth_day		= $request->getParam('birth_day','post');
		$memberObject->blood_type		= $request->getParam('blood_type','post');
		$memberObject->height		= $request->getParam('height','post');
		$memberObject->weight		= $request->getParam('weight','post');
		$memberObject->bust			= $request->getParam('bust','post');
		$memberObject->waist		= $request->getParam('waist','post');
		$memberObject->hip			= $request->getParam('hip','post');
		$memberObject->company_name		= $request->getParam('company_name','post');
		$memberObject->section_name		= $request->getParam('section_name','post');

		// ログインIDの入力を確認
		if( isset($_POST['login_id']) ) {
			$memberObject->login_id			= $request->getParam('login_id','post');
		} else if( strlen(trim($memberObject->login_id)) == 0 ) {
			if( strlen(trim($memberObject->pc_mail)) > 0 ) {
				$memberObject->login_id	= $memberObject->pc_mail;
			}
			if( strlen(trim($memberObject->mb_mail)) > 0 ) {
				$memberObject->login_id	= $memberObject->mb_mail;
			}
		}
		// 新規登録の時はパスワードが空ならランダム登録
		if( strlen($memberObject->member_number) == 0 && strlen($memberObject->login_password) == 0 ){
			spider_Controller::loadClassDefinition('util_CharUtility');
			$memberObject->login_password	= util_CharUtility::get_rundom_password( 8 );
		}
		// 身長の値をcm->mm単位、体重の値をkg->g単位へ調整
		if( preg_match('/^[0-9]+(|\\.[0-9]+)$/', $memberObject->height ) > 0 ) {
			$memberObject->height = $memberObject->height * 10;
		}
		if( preg_match('/^[0-9]+(|\\.[0-9]+)$/', $memberObject->weight ) > 0 ) {
			$memberObject->weight = $memberObject->weight * 10;
		}
		
		// 入力値を整理する
		$memberObject->optimize();
		
		// 入力値の妥当性検査を行う
		if ( is_a($loginUserObject,'admin_DaoAdminMember') || is_a($loginUserObject,'system_login_UserAdministrator') ) {
			// 管理者ログインの場合
			$memberObject->validate( $request, false );
			// 管理者登録の場合は初期ポイントを入力可能
			if( strlen(trim($memberNumber)) > 0 ) {
				// 編集時はポイントは変更できない
			} else {
				// 新規作成時はポイント直接入力
				$memberObject->point			= $request->getParam('point','post');
				$memberObject->action_label		= $request->getParam('action_label','post');
				if ( !preg_match( '/^[0-9]{1,5}$/', $memberObject->point ) ) {
					$request->addLocaledError('member.error.member.invalidinitpoint',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
				if( strlen(trim($memberObject->action_label)) > 240 ) {
					$request->addLocaledError('member.error.member.invalidpointmemo',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		} else {
			$memberObject->validate( $request, true );
		}
		
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$memberObject);
		$request->setAttribute('member.member.memberObject',$memberObject);
	}
}
?>