<?php
/*
 * database2/PackageConfig.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'define.inc.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'package'
.DIRECTORY_SEPARATOR.'PackageConfigBase.class.php' );
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Connection.class.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php' );
/**
 * データベースパッケージ基本情報保持クラス
 * 
 * - 概要
 * 
 * - 対応データベース
 *   MySQL
 *   PostgreSQL
 * - パッケージの詳細
 * 
 * @package database2 データベースパッケージ
 * @version 1.0.01
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 * 
 */
class database2_PackageConfig extends system_package_PackageConfigBase {
	function database2_PackageConfig() {
		$this->definitionHash						= array(
			'DATABASE_DATABASE_TYPE'			=> '',
			'DATABASE_DATABASE_NAME'			=> '',
			'DATABASE_DATABASE_USER'			=> '',
			'DATABASE_DATABASE_PASSWORD'		=> '',
			'DATABASE_DATABASE_CHARSET'		=> '',
			'DATABASE_DATABASE_INIT_OPTION'	=> '2',
			'DATABASE_DATABASE_HOST'			=> array(),
			'DATABASE_DATABASE_PORT'			=> array(),
			'DATABASE_DATABASE_CREATE_USER'		=> '',
			'DATABASE_DATABASE_CREATE_PASSWORD'	=> '',
		);
		if( defined('DATABASE_TYPE') ) {
			$this->definitionHash['DATABASE_DATABASE_TYPE']		= DATABASE_TYPE;
		}
		if( defined('DATABASE_NAME') ) {
			$this->definitionHash['DATABASE_DATABASE_NAME']		= DATABASE_NAME;
		}
		if( defined('DATABASE_USER') ) {
			$this->definitionHash['DATABASE_DATABASE_USER']		= DATABASE_USER;
		}
		if( defined('DATABASE_PASS') ) {
			$this->definitionHash['DATABASE_DATABASE_PASSWORD']	= DATABASE_PASS;
		}
		if( defined('DATABASE_CHARSET') ) {
			$this->definitionHash['DATABASE_DATABASE_CHARSET']	= DATABASE_CHARSET;
		}
		if( defined('DATABASE_HOST') ) {
			$this->definitionHash['DATABASE_DATABASE_HOST'][0]		= DATABASE_HOST;
		}
		if( defined('DATABASE_PORT') ) {
			$this->definitionHash['DATABASE_DATABASE_PORT'][0]		= DATABASE_PORT;
		}
		if( defined('DATABASE_MASTER_USER') ) {
			$this->definitionHash['DATABASE_DATABASE_CREATE_USER']		= DATABASE_MASTER_USER;
		}
		if( defined('DATABASE_MASTER_PASSWORD') ) {
			$this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD']	= DATABASE_MASTER_PASSWORD;
		}
	}
	/**
	 * パッケージの表示順序を取得
	 * @return int パッケージ順序
	 */
	function getPackageOrder() {
		return 10;
	}
	/**
	 * パッケージの表示名を取得
	 * @return string パッケージ名称
	 */
	function getPackageViewName() {
		return 'データベース接続2';
	}
	/**
	 * パッケージ概要説明を取得します。
	 */
	function getPackageDescription() {
		return '基本的なデータベース接続機能を提供します。';
	}
	/**
	 * パッケージ依存関係のハッシュを取得
	 * @return hash array('packageId'=>array('version','version',...))
	 */
	function getPackageDependenciesHash() {
		return array(
			'system'	=> array('1.2.00'),
		);
	}
	//
	// インストール関連メソッド
	//
	/**
	 * definitionHashに設定された値の妥当性検査を行います。
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @return boolean エラーがあるならfalse
	 */
	function validateDifinitionHash( & $request ) {

		$databaseType		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_TYPE']));
		$databaseHost		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
		$databasePort		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
		$databaseName		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_NAME']));
		$databaseUser		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_USER']));
		$databasePass		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PASSWORD']));
		$databaseCharset	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CHARSET']));
		$initOption			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_INIT_OPTION']));
		$masterUser			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CREATE_USER']));
		$masterPass			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD']));
		
		$databaseType			= strtolower( $databaseType );
		if( 'mysql' != $databaseType && 'pgsql' != $databaseType ) {
			$request->addLocaledError('database2.error.config.invaliddbms',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($databaseHost) == 0 ) {
			$request->addLocaledError('database2.error.config.invalidhost',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($databaseName) == 0 ) {
			$request->addLocaledError('database2.error.config.nodatabase',SPIDER_LOG_LEVEL_FATAL,array());
		} else if( preg_match('/^[0-9a-zA-Z\\-\\_]+$/', $databaseName ) == 0 ) {
			$request->addLocaledError('database2.error.config.invaliddatabase',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($databaseUser) == 0 ) {
			$request->addLocaledError('database2.error.config.nouser',SPIDER_LOG_LEVEL_FATAL,array());
		} else if( preg_match('/^[0-9a-zA-Z\\-\\_\\@\\.\\"]+$/', $databaseUser ) == 0 ) {
			$request->addLocaledError('database2.error.config.invaliduser',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($databaseUser) == 0 ) {
			$request->addLocaledError('database2.error.config.nopassword',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($databaseCharset) == 0 ) {
			$request->addLocaledError('database2.error.config.nocharset',SPIDER_LOG_LEVEL_FATAL,array());
		} else if( preg_match('/^[0-9a-zA-Z\\-\\_]+$/', $databaseCharset ) == 0 ) {
			$request->addLocaledError('database2.error.config.invalidcharset',SPIDER_LOG_LEVEL_FATAL,array());
		}
		
		if( '1' == $initOption ) {
			// 既存データベース利用の場合は接続チェックする
			$connection	= new database2_Connection( $request, $databaseName,
				$databaseUser, $databasePass, $databaseType, $databaseHost, $databasePort );
			if( $connection->_connectWritable() === false ) {
				$request->addLocaledError('database2.error.config.connecterror',SPIDER_LOG_LEVEL_FATAL,array());
			} else {
				$connection->disconnect();
			}
		} else if( '2' == $initOption || '3' == $initOption ) {
			if( strlen($masterUser) == 0 ) {
				$request->addLocaledError('database2.error.config.noauthuser',SPIDER_LOG_LEVEL_FATAL,array());
			} else if( preg_match('/^[0-9a-zA-Z\\-\\_\\@\\.]+$/', $masterUser ) == 0 ) {
				$request->addLocaledError('database2.error.config.invalidauthuser',SPIDER_LOG_LEVEL_FATAL,array());
			}
			if( strlen($masterPass) == 0 ) {
				$request->addLocaledError('database2.error.config.noauthpassword',SPIDER_LOG_LEVEL_FATAL,array());
			}
			if( !$request->isError() ) {
				// エラーがなければ接続チェック
				$checkConnectDatabaseName	= 'mysql';
				if( 'pgsql' == $databaseType ) {
					$checkConnectDatabaseName	= 'template1';
				}
				$connection	= new database2_Connection( $request, $checkConnectDatabaseName,
					$masterUser, $masterPass, $databaseType, $databaseHost, $databasePort );
				if( $connection->_connectWritable() === false ) {
					$request->addLocaledError('database2.error.config.authconnecterror',SPIDER_LOG_LEVEL_FATAL,array());
				} else {
					$connection->disconnect();
				}
			}
		} else {
			$request->addLocaledError('database2.error.config.invalidoption',SPIDER_LOG_LEVEL_FATAL,array());
		}
		
		if( $request->isError() ) {
			return false;
		} else {
			$request->setAttribute('database.configuration_object',$this);
			return true;
		}
	}
	/**
	 * インストールを実行します。
	 */
	function install( & $request ) {
		
		$databaseType		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_TYPE']));
		$databaseHost		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
		$databasePort		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
		$databaseName		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_NAME']));
		$databaseUser		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_USER']));
		$databasePass		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PASSWORD']));
		$databaseCharset	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CHARSET']));

		$initOption			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_INIT_OPTION']));
		$masterUser			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CREATE_USER']));
		$masterPass			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD']));
		
		$databaseType			= strtolower( $databaseType );

		if( '1' == $initOption ) {
			// 既存データベース利用の場合は接続チェックする
			$connection	= new database2_Connection( $request, $databaseName,
				$databaseUser, $databasePass, $databaseType, $databaseHost, $databasePort );
			if( $connection->_connectWritable() === false ) {
				$request->addLocaledError('database2.error.config.connecterror',SPIDER_LOG_LEVEL_FATAL,array());
			} else {
				$connection->disconnect();
			}
		} else if( '2' == $initOption ) {
			// 
			if( 'pgsql' == $databaseType ) {
				$this->createDatabasePgsql($request,false);
			} else {
				$this->createDatabaseMysql($request
					,$databaseHost, $databaseName, $databaseCharset
					,$databaseUser, $databasePass
					,false);
			}
		} else if( '3' == $initOption ) {
			if( 'pgsql' == $databaseType ) {
				$this->createDatabasePgsql($request,true);
			} else {
				$this->createDatabaseMysql($request
					,$databaseHost, $databaseName, $databaseCharset
					,$databaseUser, $databasePass
					,true);
			}
		}
		if( $request->isError() ) {
			return false;
		} else {
			$request->setAttribute('database.configuration_object',$this);
			return true;
		}
	}
	/**
	 * アンインストールします
	 */
	function uninstall( & $request ) {
		if( $connection	= $this->getMasterConnection( $request ) ) {
			if( $connection->existsDatabase( $this->definitionHash['DATABASE_DATABASE_NAME'] ) ) {
				$sql	= 'DROP DATABASE ' . $this->definitionHash['DATABASE_DATABASE_NAME'];
				if( $connection->query( $sql ) ) {
				} else {
					$request->addLocaledError('database2.error.config.failtodropdatabase',SPIDER_LOG_LEVEL_FATAL,array());
				}
				$connection->disconnect();
			}
		} else {
			$request->addLocaledError('database2.error.connect',SPIDER_LOG_LEVEL_FATAL,array($connection->error_message));
		}
		return true;
	}
	/**
	 * 本オブジェクトに設定された更新用コネクションを取得します
	 */
	function getWritableConnection( & $request ) {
		$databaseType		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_TYPE']));
		$databaseType		= strtolower( $databaseType );
		$databaseHost		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
		$databasePort		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
		$databaseName		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_NAME']));
		$databaseUser		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_USER']));
		$databasePass		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PASSWORD']));
		$databaseCharset	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CHARSET']));
		$connection	= new database2_Connection( $request, $databaseName,
			$databaseUser, $databasePass, $databaseType, $databaseHost, $databasePort );
		if( $connection->_connectWritable() === false ) {
			$request->addLocaledError('database2.error.config.connecterror',SPIDER_LOG_LEVEL_FATAL,array());
		}
		return $connection;
	}
	/**
	 * 作成権限ユーザー用のデータベース接続を取得します
	 */
	function getMasterConnection( & $request ) {
		// 権限ユーザ情報の確認
		$masterUser	= null;
		$masterPass	= null;
		if( isset($this->definitionHash) && is_array($this->definitionHash) ) {
			if( isset($this->definitionHash['DATABASE_DATABASE_CREATE_USER'])
				&& strlen($this->definitionHash['DATABASE_DATABASE_CREATE_USER']) > 0 ) {
				$masterUser	= $this->definitionHash['DATABASE_DATABASE_CREATE_USER'];
			}
			if( isset($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD'])
				&& strlen($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD']) > 0 ) {
				$masterPass	= $this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD'];
			}
		}
		// 本オブジェクトに設定されていない場合はファイルから読み込みを試みる
		if( strlen( $masterUser ) == 0 || strlen( $masterPass ) == 0 ) {
			if( $this->load( $request ) ) {
				// 読み込めたら情報を確認
				if( isset($this->definitionHash) && is_array($this->definitionHash) ) {
					if( isset($this->definitionHash['DATABASE_DATABASE_CREATE_USER'])
						&& strlen($this->definitionHash['DATABASE_DATABASE_CREATE_USER']) > 0 ) {
						$masterUser	= $this->definitionHash['DATABASE_DATABASE_CREATE_USER'];
					}
					if( isset($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD'])
						&& strlen($this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD']) > 0 ) {
						$masterPass	= $this->definitionHash['DATABASE_DATABASE_CREATE_PASSWORD'];
					}
				}
			} else {
				return false;
			}
		}
		// マスタユーザのアカウント情報を設定されているなら接続
		if( strlen( $masterUser ) > 0 && strlen( $masterPass ) > 0 ) {
			$databaseType	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_TYPE']));
			$databaseType	= strtolower( $databaseType );
			$databaseHost	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
			$databasePort	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
			$defaultDatabaseName	= 'mysql';
			if( 'pgsql' == $databaseType ) {
				// postgresqlの場合はtemplate1へ接続
				$defaultDatabaseName	= 'template1';
			}
			$connection	= new database2_Connection( $request, $defaultDatabaseName,
				$masterUser, $masterPass, $databaseType, $databaseHost, $databasePort );
			if( $connection->_connectWritable() === false ) {
				$request->addLocaledError('database2.error.config.authconnecterror',SPIDER_LOG_LEVEL_FATAL,array());
			}
			return $connection;
		} else {
			return false;
		}
	}
	/**
	 * PostgreSQL用にデータベースを作成します
	 */
	function createDatabasePgsql( &$request ,$is_force = true ) {
		
		$databaseHost		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
		$databasePort		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
		$databaseName		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_NAME']));
		$databaseCharset	= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CHARSET']));
		$databaseUser		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_USER']));
		$databasePass		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PASSWORD']));

		// 実行メッセージの配列
		$message_array	= array();
		
		// マスタユーザでデータベースに接続する
		$dbo		= $this->getMasterConnection( $request );
		if ( $dbo === false ) {
			$request->addLocaledError('database2.error.connect',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( !$request->isError() ){
			// ユーザーが存在するか確認する
			$exist_user = false;
			$sql	= 'SELECT COUNT(usename) FROM pg_user WHERE usename='.$dbo->quote( $databaseUser );
			$result	= $dbo->queryOne( $sql );
			if ( $result === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message." : ".$sql));
			} else if( $result > 0 ){
				$exist_user	= true;
			}
			if( !$exist_user ) {
				// ユーザーが存在しないなら作成する
				// Postgresのバージョンを確認する
				$sql	= 'SELECT VERSION()';
				$version_strings	= $dbo->queryOne($sql);
				if ( false === $version_strings ) {
					$request->addLocaledError('database2.error.config.failtoconfirmversion',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message." : ".$sql));
				} else {
					$sql	= '';
					if( eregi('PostgreSQL 8.0',$version_strings ) ) {
						// バージョンが8.0の場合はUSER
						$sql	= 'CREATE USER '.$databaseUser
							.' PASSWORD'.$dbo->quote($databasePass).' VALID UNTIL '.$dbo->quote('infinity');
						if ( false === $result = $dbo->query($sql) ) {
							$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
						} else {
							array_push($message_array,'データベースユーザ'.$databaseUser.'を作成しました' );
						}
					} else if( eregi('PostgreSQL 8',$version_strings ) ) {
						// バージョンが8.1以上の場合はROLE
						$sql	= 'CREATE ROLE '.$databaseUser
							.' LOGIN PASSWORD '.$dbo->quote($databasePass).' NOINHERIT VALID UNTIL '.$dbo->quote('infinity');
						if ( false === $result = $dbo->query($sql) ) {
							$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
						} else {
							array_push($message_array,'データベースロール'.$databaseUser.'を作成しました' );
						}
					} else if( eregi('PostgreSQL 7',$version_strings ) ) {
						// バージョンが7の場合はUSER
						$sql	= 'CREATE USER '.$databaseUser
							.' PASSWORD'.$dbo->quote($databasePass).' VALID UNTIL '.$dbo->quote('infinity');
						if ( false === $result = $dbo->query($sql) ) {
							$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
						} else {
							array_push($message_array,'データベースユーザ'.$databaseUser.'を作成しました' );
						}
					} else {
						// バージョンがそれ以外の場合は非対応
						$request->addLocaledError('database2.error.config.outofversion',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
					}
				}
			}
			
			// データベースが存在するか確認する
			$exist_database	= false;
			$sql			= 'SELECT COUNT(datname) FROM pg_database WHERE datname='.$dbo->quote($databaseName);
			$result			= $dbo->queryOne( $sql );
			if ( $result === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
			} else if( $result > 0 ){
				$exist_database	= true;
			}
			// データベースが存在して削除の必要があるなら削除する
			if( $exist_database && $is_force ) {
				$sql	= 'DROP DATABASE "'.$databaseName.'"';
				if ( false === $result = $dbo->query($sql) ) {
					$request->addLocaledError('database2.error.config.failtodropdatabase',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベース'.$databaseName.'を強制削除しました。' );
					$exist_database	= false;
				}
			}
			// データベースが存在しないなら作成する
			if( !$exist_database ) {
				$sql	= 'CREATE DATABASE "'.$databaseName.'" '
					.'WITH ENCODING='.$dbo->quote($databaseCharset)
					.' OWNER='.$databaseUser
				;
				if ( false === $result = $dbo->query($sql) ) {
					$request->addLocaledError('database2.error.config.failtocreatedatabase',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベース'.$databaseName.'を作成しました。' );
				}
			}
			if( !is_null($dbo) ) {
				$dbo->disconnect();
			}
		}
		$request->setAttribute('admin.package.installer.message_array', $message_array );
	}
	/**
	 * MySQL用にデータベースを作成します
	 */
	function createDatabaseMysql( & $request, $is_force = true ) {

		$databaseHost			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_HOST'][0]));
		$databasePort			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PORT'][0]));
		$databaseName			= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_NAME']));
		$databaseCharset		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_CHARSET']));
		$databaseUser		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_USER']));
		$databasePass		= trim(stripslashes($this->definitionHash['DATABASE_DATABASE_PASSWORD']));

		// 実行メッセージの配列
		$message_array	= array();
		// マスタユーザでデータベースに接続する
		$dbo		= $this->getMasterConnection( $request );
		if ( $dbo === false ) {
			$request->addLocaledError('database2.error.connect',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message));
		}
		if( !$request->isError() ) {
			// データベースが存在するか確認する
			$exist_database = false;
			$sql	= 'SHOW DATABASES';
			$result			= $dbo->queryAll( $sql, null, 'hash' );
			if ( $result === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message));
			} else {
				foreach( $result as $row ) {
					if( $databaseName == $row['Database'] || $databaseName == $row['database'] ) {
						$exist_database	= true;
						break;
					}
				}
			}

			// データベースが存在して削除の必要があるなら削除する
			if( $exist_database && $is_force ) {
				$sql	= 'DROP DATABASE IF EXISTS '.$databaseName;
				if ( false === $result = $dbo->query($sql) ) {
					$request->addLocaledError('database2.error.config.failtodropdatabase',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message." : ".$sql));
					array_push($message_array,'データベース'.$databaseName.'を削除しました。' );
					$exist_database	= false;
				}
			}
			// データベースが存在しないなら作成する
			if( !$exist_database ) {
				$sql	= 'CREATE DATABASE IF NOT EXISTS '.$databaseName;
				if ( false === $result = $dbo->query($sql) ) {
					$request->addLocaledError('database2.error.config.failtocreatedatabase',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベース'.$databaseName.'を作成しました。' );
				}
			}
			
			// ユーザーの作成
			if( preg_match('/\\@.+$/',$databaseUser) > 0 ) {
				// @ホスト名を含むならそのまま作成
				$sql	= 'GRANT ALL PRIVILEGES ON '.$databaseName.'.* TO '
					.$databaseUser.' IDENTIFIED BY '.$dbo->quote($databasePass).' WITH GRANT OPTION';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベースユーザ'.$databaseUser.'を作成しました。' );
				}
				$sql	= 'SET PASSWORD FOR '.$databaseUser.' = OLD_PASSWORD('.$dbo->quote($databasePass).');';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.altpassword',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				}
			} else {
				// ホスト名を含まないなら補完して登録
				// $_SERVER['HOST_NAME']ユーザーを作成する
				$sql	= 'GRANT ALL PRIVILEGES ON '.$databaseName.'.* TO '
					.$databaseUser.'@"'.$_SERVER['HOST_NAME'].'" IDENTIFIED BY '.$dbo->quote($databasePass).' WITH GRANT OPTION';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベースユーザ'.$databaseUser.'@'.$_SERVER['HOST_NAME'].'を作成しました。' );
				}
				$sql	= 'SET PASSWORD FOR '.$databaseUser.'@"'.$_SERVER['HOST_NAME'].'" = OLD_PASSWORD('.$dbo->quote($databasePass).');';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.altpassword',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				}
				// $_SERVER['SERVER_ADDR']ユーザーを作成する
				$sql	= 'GRANT ALL PRIVILEGES ON '.$databaseName.'.* TO '
					.$databaseUser.'@"'.$_SERVER['SERVER_ADDR'].'" IDENTIFIED BY '.$dbo->quote($databasePass).' WITH GRANT OPTION';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.createuser',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				} else {
					array_push($message_array,'データベースユーザ'.$databaseUser.'@'.$_SERVER['SERVER_ADDR'].'を作成しました。' );
				}
				$sql	= 'SET PASSWORD FOR '.$databaseUser.'@"'.$_SERVER['SERVER_ADDR'].'" = OLD_PASSWORD('.$dbo->quote($databasePass).');';
				$result = $dbo->query($sql);
				if ( false === $result ) {
					$request->addLocaledError('database2.error.config.altpassword',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
				}
			}
			$sql	= 'FLUSH PRIVILEGES';
			$result = $dbo->query($sql);
			if ( false === $result ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($dbo->error_message.":".$sql));
			} else {
				array_push($message_array,'権限を更新しました。' );
			}
			if( !is_null($dbo) ) {
				$dbo->disconnect();
			}
		}
		$request->setAttribute('admin.package.installer.message_array', $message_array );
	}
}
?>