<?php
/*
 * content/Uploader.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'File.class.php');
class content_Uploader {
	/** inputタグのname	*/
	var $inputName;
	/** content_Fileオブジェクトの配列	*/
	var $contentFileObjectArray	= array();
	/**
	 * Constructor
	 */
	function content_Uploader($inputName) {
		$this->inputName	= $inputName;
		$this->contentFileObjectArray	= array();
	}
	/**
	 * ファイルアップロードを初期化します
	 * @param $request spider_HttpRequestクラスインスタンスの参照
	 */
	function initialize( & $request ) {
		$this->deleteTmpFiles( $request );
		$this->contentFileObjectArray	= array();
	}
	/**
	 * アップロード確認
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 * @param string $folderUri 保存先フォルダURI
	 * @param string $fileName 保存ファイル名
	 * @param hash $maxSizeArray 画像の解像度制限ハッシュ array( array('width'=>最大幅, 'height'=>最大高さ), ...)
	 * @param hash $thumbSizeArray 作成するサムネイルサイズ指定ハッシュの配列 array( array('width'=>横幅,'height'=>高さ), ... )
	 * @param array $fileNameArray 登録ファイル名強制上書き配列 array('ファイル名','ファイル名', ...)
	 */
	function uploadConfirm( & $request, $folderUri, $maxSizeArray=null, $thumbSizeArray=array(), $fileNameArray=null ) {
		// アップロードファイルチェック
		$this->contentFileObjectArray	= array();
		$upfiles	= $_FILES[$this->inputName];
		if( is_array($upfiles) && is_array($upfiles['tmp_name']) ) {
			foreach( $upfiles['tmp_name'] as $key => $tempName ) {
				$counter	= $key + 1;
				$baseName	= basename($upfiles['name'][$key]);
				$fileName	= basename($upfiles['name'][$key]);
				if( is_array($fileNameArray) && isset($fileNameArray[$key]) && strlen($fileNameArray[$key]) > 0 ) {
					// 拡張子を確認して違うならオリジナルに合わせる
					$elms			= explode('.',$baseName);
					$baseExt	= strtolower(array_pop($elms));
					$elms			= explode('.',$fileNameArray[$key]);
					$fileExt	= array_pop($elms);
					if( strtolower($baseExt) != strtolower($fileExt) ){
						$fileName	= preg_replace('/\\.'.$fileExt.'$/','.'.$baseExt,$fileNameArray[$key]);
					} else {
						$fileName	= $fileNameArray[$key];
					}
				}
				// 拡張子チェック
				$baseElms	= explode('.',$baseName);
				$baseExt	= strtolower(array_pop($baseElms));
				$upElms		= explode('.',$fileName);
				$upExt		= strtolower(array_pop($upElms));
				if ( defined('UPLOAD_ERR_INI_SIZE') && UPLOAD_ERR_INI_SIZE == $upfiles['error'][$key] ) {
					$request->addError($counter.'番目のファイルサイズがサーバーの設定値'.ini_get('upload_max_filesize').'を超えています。');
				} else if ( defined('UPLOAD_ERR_FORM_SIZE') && UPLOAD_ERR_FORM_SIZE == $upfiles['error'][$key] ) {
					$request->addError($counter.'番目のファイルサイズが設定値'.$_POST['MAX_FILE_SIZE'].'を超えています。');
				} else if ( defined('UPLOAD_ERR_PARTIAL') && UPLOAD_ERR_PARTIAL == $upfiles['error'][$key] ) {
					$request->addError($counter.'番目のファイルが壊れているかアップロード中に壊れました。');
				} else if ( defined('UPLOAD_ERR_NO_FILE') && UPLOAD_ERR_NO_FILE == $upfiles['error'][$key] ) {
					// アップロードされていない場合はエラーにしない
				} else if ( defined('UPLOAD_ERR_NO_TMP_DIR') && UPLOAD_ERR_NO_TMP_DIR == $upfiles['error'][$key] ) {
					$request->addError($counter.'番目のファイルをサーバーの一時ファイルに保存できませんでした。');
				} else if ( defined('UPLOAD_ERR_OK') && UPLOAD_ERR_OK != $upfiles['error'][$key] ) {
					$request->addError($counter.'番目のファイルアップロードに失敗しました。');
				} else if( preg_match('/^[0-9a-zA-Z\\_\\.]+\\.[0-9a-zA-Z]+$/',$fileName) == 0 ) {
					$request->addError($counter.'番目のファイル名：ファイル名に利用できる文字は英数字とアンダーバー、ドットのみです。');
				} else if( preg_match('/\\.([pP][dD][fF]|[pP][nN][gG]|[jJ][pP][gG]|[gG][iI][fF]|[cC][sS][sS]|[jJ][sS]|[hH][tT][mM][lL]|swf|flv|xml|xsl)$/',$fileName) == 0 ) {
					$request->addError($counter.'番目のファイル名：jpeg/png/gif/css/pdf/swf/flv以外アップロードできません。');
				} else if( $baseExt != $upExt ) {
					$request->addError($counter.'番目のファイル名：アップロードするファイルの形式がアップロード先ファイル名と異なります。');
				} else if ( is_uploaded_file($tempName) ) {
					// エラーがなければアップロード
					$contentFileObject	= new content_File();
					// 登録最大サイズの算出
					$maxWidth	= 0;
					$maxHeight	= 0;
					if( is_array($maxSizeArray) ) {
						// 最大サイズ指定が配列なら
						if( isset($maxSizeArray[$key]) && is_array($maxSizeArray[$key])
							&& preg_match('/^[0-9]{1,4}$/',$maxSizeArray[$key]['width']) > 0
							&& preg_match('/^[0-9]{1,4}$/',$maxSizeArray[$key]['height']) > 0 ) {
							$maxWidth	= $maxSizeArray[$key]['width'];
							$maxHeight	= $maxSizeArray[$key]['height'];
						} else if( preg_match('/^[0-9]{1,4}$/',$maxSizeArray['width']) > 0
							&& preg_match('/^[0-9]{1,4}$/',$maxSizeArray['width']) > 0 ) {
							$maxWidth	= $maxSizeArray['width'];
							$maxHeight	= $maxSizeArray['height'];
						}
					}
					$contentFileObject->uploadConfirm( $request, $tempName, $folderUri, $fileName, $maxWidth, $maxHeight, $thumbSizeArray, $counter.'番目の' );
					$this->contentFileObjectArray[$key]	= $contentFileObject;
				} else {
					$request->addError($counter.'番目のファイルが原因不明のエラーでアップロードできませんでした。'.$upfiles[$key]['error']);
				}
			}
		}
	}
	/**
	 * アップロード実行
	 * @param $request spider_HttpRequestクラスインスタンスの参照
	 */
	function uploadExecute( & $request, $fileNameArray=null ) {
		if( is_array($this->contentFileObjectArray) ) {
			foreach( $this->contentFileObjectArray as $key => $contentFileObject ) {
				if( is_array($fileNameArray) && isset($fileNameArray[$key]) && strlen($fileNameArray[$key]) > 0 ) {
					$contentFileObject->fileName	= $fileNameArray[$key];
				}
				$contentFileObject->uploadExecute( $request );
				$contentFileObject->deleteTmpFiles( $request );
			}
		}
	}
	/**
	 * ファイルアップロードの一時ファイルを全て削除します
	 * @param $request spider_HttpRequestクラスインスタンスの参照
	 */
	function deleteTmpFiles( & $request ) {
		if( is_array($this->contentFileObjectArray) ) {
			foreach( $this->contentFileObjectArray as $contentFileObject ) {
				$contentFileObject->deleteTmpFiles( $request );
			}
		}
	}
}
?>