<?php
/*
 * content/File.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'CharUtility.class.php');
require_once(dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'File.class.php');
class content_File {
	// 基本情報
	/** ファイル名	*/
	var $fileName;
	/** アップロード先フォルダURI	*/
	var $folderUri;
	/** ファイルタイプ	txt/img/pdf	*/
	var $fileType;
	/** 画像解像度：横幅	*/
	var $width;
	/** 画像解像度：高さ	*/
	var $height;
	
	// アップロード時用
	/** アップロード一時URI	*/
	var $tmpFileUri;
	/** アップロード一時サムネイルURI	*/
	var $tmpThumbInfoArray	= array();
	
	/**
	 * Constructor
	 */
	function content_File() {
		$this->tmpThumbInfoArray	= array();
	}
	/**
	 * アップロード確認
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 * @param string $tmpPath $_FILE['tmp_name']に格納された一時パス
	 * @param string $folderUri 保存先フォルダURI
	 * @param string $fileName 保存ファイル名
	 * @param array $thumbSizeArray 作成するサムネイルサイズ指定ハッシュの配列 array( array('width'=>横幅,'height'=>高さ), ... )
	 */
	function uploadConfirm( & $request, $tmpPath, $folderUri, $fileName, $maxWidth=1280, $maxHeight=1280, $thumbSizeArray=array(), $errorPrefix='' ) {
		// 保存先フォルダ名称を小文字に統一
		$this->folderUri	= strtolower($folderUri);
		$this->folderUri	= preg_replace('/\\/$/','',$this->folderUri);
		// ファイル名を小文字に統一して拡張子を取り出す
		$this->fileName		= strtolower($fileName);
		$fileElmArray	= explode('.',$this->fileName);
		$extension		= array_pop($fileElmArray);
		$fileBase		= implode('.',$fileElmArray);
		// 拡張子からファイルタイプを判断
		$this->fileType		= 'txt';
		if( preg_match('/^(png|jpg|jpeg|gif)$/',$extension) > 0 ) {
			$this->fileType	= 'img';
		} else if( preg_match('/^(html|htm|css|js|txt|text|php|phps|pl)$/',$extension) > 0 ) {
			$this->fileType	= 'txt';
		} else if( preg_match('/^(pdf)$/',$extension) > 0 ) {
			$this->fileType	= 'pdf';
		}
		// アップロード一時名称を決定
		$tmpBaseName		= util_CharUtility::get_rundom_key(8).time();
		$tmpFileName		= $tmpBaseName.'.'.$extension;
		$this->tmpFileUri	= '/upload/tmp/'.$tmpFileName;
		// 一時アップロード実行
		if ( is_uploaded_file($tmpPath) ) {
			// エラーがないならシステム一時フォルダにアップ
			$tmpLocalPath	= DIR_PATH_TMP.DIRECTORY_SEPARATOR.'content';
			if( !file_exists($tmpLocalPath) ) {
				if( @mkdir($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
					@chmod($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER);
				}
			}
			$tmpLocalPath	.= DIRECTORY_SEPARATOR.'file';
			if( !file_exists($tmpLocalPath) ) {
				if( @mkdir($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
					@chmod($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER);
				}
			}
			$tmpLocalPath	.= DIRECTORY_SEPARATOR.'uploadtmp';
			if( !file_exists($tmpLocalPath) ) {
				if( @mkdir($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
					@chmod($tmpLocalPath,SPIDER_PERMITTION_DATA_FOLDER);
				}
			}
			$tmpLocalPath	.= DIRECTORY_SEPARATOR.basename($tmpFileName);
			if( move_uploaded_file( $tmpPath, $tmpLocalPath ) ) {
				// アップロードファイル移動に成功
				if( 'img' == $this->fileType ) {
					// ファイルがイメージの場合のみ
					// 幅と高さを取得
					list( $this->width, $this->height )	= getimagesize($tmpLocalPath);
					if( preg_match('/^[0-9]{1,4}$/',$maxWidth) > 0 && preg_match('/^[0-9]{1,4}$/',$maxHeight) > 0
					&& ($maxWidth <= $this->width || $maxHeight <= $this->height ) ){
						// 画像解像度の幅または高さが指定のマックスサイズを超えている場合は小さくする
						$this->_resizeImage( $request, $tmpLocalPath, $maxWidth, $maxHeight );
					}
				}
				// 公開一時フォルダに取り込み
				if( system_DataFileWriter::import( $request, $this->tmpFileUri, $tmpLocalPath, 'public' ) ) {
					if( preg_match('/\\.([pP][nN][gG]|[jJ][pP][gG]|[gG][iI][fF])$/',$fileName) > 0 ) {
						// 画像ファイルの場合
						if( 'img' == $this->fileType ) {
							// サムネイル作成を試みる
							if(is_array($thumbSizeArray)){
								foreach( $thumbSizeArray as $sizeInfo ) {
									if( preg_match('/^[0-9]{1,4}$/',$sizeInfo['width']) > 0
										&& preg_match('/^[0-9]{1,4}$/',$sizeInfo['height']) > 0 ) {
										$tmpThumbUri = '/upload/tmp/'
											.$this->_createThumbnailName( $tmpFileName, $sizeInfo['width'],$sizeInfo['height'] );
										if( $tmpThumbUri !== false ) {
											$this->_createThumbnail( $request, $tmpLocalPath, $tmpThumbUri, $sizeInfo['width'], $sizeInfo['height'] );
											$sizeInfo['uri']	= $tmpThumbUri;
											array_push($this->tmpThumbInfoArray,$sizeInfo);
										}
									}
								}
							}
						}
					}
				} else {
					$request->addError($errorPrefix.'ファイルを公開フォルダに移動できませんでした。');
				}
				// 一時ファイルを削除
				@unlink($tmpLocalPath);
			} else {
				$request->addError($errorPrefix.'ファイルアップロード保存に失敗しました。');
			}
		} else {
			$request->addError($errorPrefix.'ファイルが正しいアップロード情報ではありません。');
		}
	}
	/**
	 * アップロードを実行します
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 */
	function uploadExecute( & $request ) {
		$tmpFileRealPath	= util_File::suri2path( $this->tmpFileUri );
		$uploadUri			= $this->folderUri.'/'.$this->fileName;
		if( file_exists($tmpFileRealPath) && strlen($uploadUri) > 0 ) {
			// 先にアップロード先のファイルがあれば削除します
			system_DataFileWriter::delete($request,$uploadUri,'public');
			// アップロードしたファイルをアップロード先にコピーします
			if( system_DataFileWriter::import( $request, $uploadUri, $tmpFileRealPath, 'public' ) ) {
				// サムネイルファイルをアップロード先にコピーします
				if( is_array($this->tmpThumbInfoArray) ) {
					foreach( $this->tmpThumbInfoArray as $tmpThumbInfo ) {
						$tmpThumbRealPath	= util_File::suri2path( $tmpThumbInfo['uri'] );
						$uploadThumbUri		= $this->folderUri.'/'
							.$this->_createThumbnailName( $this->fileName, $tmpThumbInfo['width'],$tmpThumbInfo['height'] );
						if( file_exists($tmpThumbRealPath) && strlen($uploadThumbUri) > 0 ) {
							system_DataFileWriter::import( $request, $uploadThumbUri, $tmpThumbRealPath, 'public' );
						}
					}
				}
			}
		}
		if( strlen($this->tmpFileUri) > 0 ) {
			system_DataFileWriter::delete($request,$this->tmpFileUri,'public');
		}
		if( is_array($this->tmpThumbInfoArray) ) {
			foreach( $this->tmpThumbInfoArray as $tmpThumbInfo ) {
				system_DataFileWriter::delete($request,$tmpThumbInfo['uri'],'public');
			}
		}
	}
	/**
	 * ファイルが存在するか確認
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 * @return boolean 存在するならtrue, 存在しないならfalse
	 */
	function isExists( & $request ) {
		$isExists		= false;
		if( system_DataFileWriter::isExists( $request, $this->folderUri.'/'.$this->fileName, 'public' ) ) {
			$isExists		= true;
		}
		return $isExists;
	}
	/**
	 * 指定サイズのサムネイルファイル名を取得します
	 * @param int $maxWidth 最大幅
	 * @param int $maxHeight 最大高さ
	 * @return string サムネイルファイル名称
	 */
	function getThumbnailFileName( $maxWidth=100, $maxHeight=100 ) {
		return $this->_createThumbnailName( $this->fileName, $maxWidth, $maxHeight );
	}
	/**
	 * 指定サイズのサムネイル画像が存在するか確認します
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 * @param int $maxWidth 最大幅
	 * @param int $maxHeight 最大高さ
	 * @return boolean 存在するならtrue
	 */
	function hasThumbnail( & $request, $maxWidth=100, $maxHeight=100 ) {
		$thumbUri	= $this->folderUri.'/'.$this->getThumbnailFileName( $maxWidth, $maxHeight );
		$isExists		= false;
		if( system_DataFileWriter::isExists( $request, $thumbUri, 'public' ) ) {
			$isExists		= true;
		}
		return $isExists;
	}
	/**
	 * このアップロードファイルと作成済みサムネイル画像を全て削除します
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 */
	function deleteFiles( & $request ) {
		$fileUri		= $this->folderUri.'/'.$this->fileName;
		$fileElments	= explode('.',$this->fileName);
		$extension		= strtolower(array_pop($fileElments));
		$fileBase		= implode('.',$fileElments);
		system_DataFileWriter::delete($request,$fileUri,'public');
		$folderPath	= util_File::suri2path( $this->folderUri );
		$deleteThumbUriArray	= array();
		if (is_dir($folderPath)) {
			if ($dh = opendir($folderPath)) {
				while (($fileName = readdir($dh)) !== false) {
					if( preg_match('/^sthumb\\_'
						.util_CharUtility::escapeRegxStr($fileBase)
						.'\\_[0-9]{1,4}\\_[0-9]{1,4}\\.'
						.util_CharUtility::escapeRegxStr($extension).'$/',$fileName) > 0 ) {
						array_push($deleteThumbUriArray,$this->folderUri.'/'.$fileName);
					}
				}
				closedir($dh);
			}
		}
		foreach( $deleteThumbUriArray as $thumbUri ) {
			system_DataFileWriter::delete($request,$thumbUri,'public');
		}
	}
	/**
	 * ファイルアップロードの一時ファイルを全て削除します
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 */
	function deleteTmpFiles( & $request ) {
		$fileUri		= $this->tmpFileUri;
		$fileElments	= explode('.',basename($this->tmpFileUri));
		$extension		= strtolower(array_pop($fileElments));
		$fileBase		= implode('.',$fileElments);
		system_DataFileWriter::delete($request,$fileUri,'public');
		$folderPath		= util_File::suri2path( dirname($this->tmpFileUri) );
		$deleteThumbUriArray	= array();
		if (is_dir($folderPath)) {
			if ($dh = opendir($folderPath)) {
				while (($fileName = readdir($dh)) !== false) {
					if( preg_match('/^sthumb\\_'
						.util_CharUtility::escapeRegxStr($fileBase)
						.'\\_[0-9]{1,4}\\_[0-9]{1,4}\\.'
						.util_CharUtility::escapeRegxStr($extension).'$/',$fileName) > 0 ) {
						array_push($deleteThumbUriArray,dirname($this->tmpFileUri).'/'.$fileName);
					}
				}
				closedir($dh);
			}
		}
		foreach( $deleteThumbUriArray as $thumbUri ) {
			system_DataFileWriter::delete($request,$thumbUri,'public');
		}
	}
	/**
	 * サムネイル画像ファイル名を作成
	 * @param string $fileName ファイル名称
	 * @param int $maxWidth 最大幅
	 * @param int $maxHeight 最大高
	 * @return サムネイルファイル名称
	 */
	function _createThumbnailName( $fileName, $maxWidth=100, $maxHeight=100 ) {
		$fileElments	= explode('.',$fileName);
		if( count($fileElments) > 1 ) {
			$extension	= strtolower(array_pop($fileElments));
			$fileBase	= implode('.',$fileElments);
			return 'sthumb_'.$fileBase.'_'.$maxWidth.'_'.$maxHeight.'.'.$extension;
		}
		return false;
	}
	/**
	 * 指定されたファイルのサムネイル画像作成
	 * @param spider_HttpRequest $request spider_HttpRequestクラスインスタンスの参照
	 * @param string $srcPath 元画像の絶対パス
	 * @param string $outUri 出力サムネイル画像のURI
	 * @param int $maxWidth サムネイル画像最大横幅 デフォルト値100
	 * @param int $maxHeight サムネイル画像最大高さ デフォルト値100
	 */
	function _createThumbnail( & $request, $srcPath, $outUri, $maxWidth=100, $maxHeight=100 ) {
		// 元イメージ読み込み
		$orgImage		= null;
		$thumbTmpPath	= dirname($srcPath).DIRECTORY_SEPARATOR.'sthumb_'.basename($srcPath);
		@copy($srcPath,$thumbTmpPath);
		@chmod($thumbTmpPath,0666);
		$this->_resizeImage( $request, $thumbTmpPath, $maxWidth, $maxHeight );
		if( system_DataFileWriter::import( $request, $outUri, $thumbTmpPath, 'public' ) ) {
		}
		@unlink($thumbTmpPath);
	}
	/**
	 * 指定ファイルのサイズを調整したファイルを作成します
	 */
	function _resizeImage( & $request, $srcPath, $maxWidth=100, $maxHeight=100 ) {
		if( $maxWidth == 0 && $maxHeight == 0 ) {
			return;
		}
		return util_File::resizeImage( $srcPath, $srcPath, $maxWidth, $maxHeight );
	}
}
?>