<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.setting.delivery.Form}
{preset:page_title 'ショップ管理 > 配送料設定'}

	{set:productObject shopping.product.unit.unit_object->'shoppingProductObject'}
	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">ショップ管理</a>
		&gt; 配送料設定
	</div>

	<h1>
		ショップ管理 &gt; 配送料設定
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}
	
	<form name="mform" action="./execute.php" method="post" enctype="multipart/form-data">
	<h2 class="global">共通</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">配送料無料条件</th>
		<td>
			お支払い金額の合計が<input type="text" name="delivery_free_payment" size="10" value="{write:shopping.setting.delivery.deliveryFreePayment}"
				style="text-align:right;"
			/>円以上
		</td>
	</tr>
	<tr>
		<th style="width:12em;">クール便の扱い</th>
		<td>
			<select name="delivery_type_operation">
				<option value="0"{if:shopping.setting.delivery.deliveryTypeOperation} selected{/if}>クール便の荷物を含むなら全てクール便で配送</option>
				<option value="1"{if:shopping.setting.delivery.deliveryTypeOperation} selected{/if}>クール便の荷物を含むなら別口で配送</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">ラッピング</th>
		<td>
			▼ラッピング選択肢<br />
			<textarea name="wrapping_options" cols="40" rows="5"
				>{write:shopping.setting.delivery.deliveryRappingOptions}</textarea><br />
			<span class="required">
				※のしやラッピングの種類の選択肢を一行に1つ記述してください。10行まで入力できます。<br />
				ラッピングに料金を求める場合は1行中のカンマで区切った末尾に金額を半角数字で入力してください
			</span>
			<br />
			<br />
			▼ラッピング文言入力<br />
			<input type="radio" name="wrapping_words" value="on"{if:'on'==shopping.setting.delivery.deliveryRappingFreeWords} checked{/if} />フリーワード入力欄を設ける
			<input type="radio" name="wrapping_words" value="off"{if:'on'!=shopping.setting.delivery.deliveryRappingFreeWords} checked{/if} />フリーワード入力欄を設けない
		</td>
	</tr>
	<tr>
		<th style="width:12em;">お届け希望日表示設定</th>
		<td>
			<input type="text" name="delivery_wishful_day_start" size="2" value="{write:shopping.setting.delivery.deliveryWishfulDayStart}"
			/>日後から<input type="text" name="delivery_wishful_day_end" size="2" value="{write:shopping.setting.delivery.deliveryWishfulDayEnd}" />日後まで表示する<br />
			<span class="required">
				※お届け希望日の入力欄を表示しない場合は未入力としてください
			</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">お届け希望時間帯<br />選択肢</th>
		<td>
			<textarea name="wishful_times" cols="40" rows="5"
				>{write:shopping.setting.delivery.wishfulTimes}</textarea><br />
			<span class="required">
				※ご利用の配送業者に合わせたお届け希望時間帯を1行にひとつ記述してください。<br />
				何も記述しない場合はお届け希望時間帯の選択は表示されません。
			</span>
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	<p style="text-align:center;">
		<input type="button" value="設定を保存する"
			onclick="shoppingSettingDeliverySave()"
			onkeypress="shoppingSettingDeliverySave()"
		/><br />
	</p>

	{foreach:shopping.setting.delivery.deliveryPriceHash deliveryType weightHash}
	<h2 class="global">{if:'1'==deliveryType}クール便{else}普通便{/if}梱包目安の合計値と都道府県</h2>
	{foreach:weightHash weightValue prefHash}
	<div id="block_{write:deliveryType}_{write:weightValue}">
		<h2>{if:'1'==deliveryType}クール便{else}普通便{/if} 梱包目安の合計値が{write:weightValue}まで</h2>
		<div style="width:96%;margin:0 auto;text-align:right;">
			<input type="text" id="price_{write:deliveryType}_{write:weightValue}" name="price_{write:deliveryType}_{write:weightValue}" size="10" value="" /><input type="button" value="全てに適用" onclick="shoppingSettingDeliveryApplyAll({write:deliveryType},{write:weightValue})" />
		</div>
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			{foreach:prefHash prefNum price}
			<th style="white-space:nowrap;">{write:PREFECTURE_HASH[prefNum]}</th>
			<td style="white-space:nowrap;text-align:right;">
				<input type="text" id="price_{write:deliveryType}_{write:weightValue}_{write:prefNum}" name="price[{write:deliveryType}][{write:weightValue}][{write:prefNum}]" size="10" value="{write:price}" style="text-align:right;" />円
			</td>
			{if:(prefHash_loop_counter%3)==0}</tr><tr>{/if}
			{/foreach}
		</tr>
		</tbody>
		</table>
		<p style="text-align:right;">
			<a href="javascript:shoppingSettingDeliveryDelete({write:deliveryType},{write:weightValue})">{if:'1'==deliveryType}クール便{else}普通便{/if} 梱包目安合計{write:weightValue}までの設定を削除する</a>
		</p>
		<br />
	</div>
	{/foreach}
	{/foreach}
	<p style="text-align:right;">
		配送料設定の追加作成 &gt;&gt;
		配送目安値=<input type="text" size="5" name="add_delivery_weight" />
		の
		<select name="add_delivery_type">
			<option value="0">普通便</option>
			<option value="1">クール便</option>
		</select>
		を初期値<input type="text" size="5" name="add_delivery_price" />円で
		<input type="button" value="作成する" onclick="shoppingSettingDeliveryAddForm()" />
	</p>
	
	<div id="shopping-setting-delivery-add">
	</div>
	
	<p style="text-align:center;">
		<input type="button" value="設定を保存する"
			onclick="shoppingSettingDeliverySave()"
			onkeypress="shoppingSettingDeliverySave()"
		/><br />
	</p>
	</form>

<script language="JavaScript" type="text/javascript"><!--
function shoppingSettingDeliverySave() {
	FormerCommon.executePostForm(document.mform, "shoppingSettingDeliverySaveResult()" );
}
function shoppingSettingDeliverySaveResult(){
	alert('保存しました');
}
function shoppingSettingDeliveryApplyAll( deliveryType, weightValue ) {
	var value	= document.getElementById('price_'+deliveryType+'_'+weightValue).value;
	if( value && value.length ) {
		if( confirm('梱包目安合計が'+weightValue+'の送料を全て' + value + '円に設定します。\nよろしいですか？') ){
			{foreach:PREFECTURE_HASH prefNum prefName}
			document.getElementById('price_'+deliveryType+'_'+weightValue+'_{write:prefNum}').value	= value;
			{/foreach}
		}
	}
}
var typeWeightArray;
var typeWeightHttpObject;
function shoppingSettingDeliveryAddInit() {
	typeWeightArray	= new Array();
	{foreach:shopping.setting.delivery.deliveryPriceHash deliveryType weightHash}
	{foreach:weightHash weightValue prefHash}
	typeWeightArray.push('{write:deliveryType}_{write:weightValue}');
	{/foreach}{/foreach}
}
function shoppingSettingDeliveryAddForm() {
	var weight	= document.mform.add_delivery_weight.value;
	var type	= document.mform.add_delivery_type.options[document.mform.add_delivery_type.selectedIndex].value;
	var price	= document.mform.add_delivery_price.value;
	var typeName	= '普通便';
	if( type=='1' ) {
		typeName	= 'クール便';
	} else {
		type	= '0';
	}
	var typeWeight	= type + '_' + weight;
	var isExist		= false;
	for( var i=0; i<typeWeightArray.length; i++ ) {
		if( typeWeight == typeWeightArray[i] ) {
			isExist		= true;
			break;
		}
	}
	if( isExist ) {
		alert('配送目安'+weight+'の'+typeName+'は既に設定が存在するので追加できません!');
		return;
	}
	var addPanel	= document.getElementById('shopping-setting-delivery-add');
	if( addPanel ) {
		var url	= './sizeform.php?dt='+type+'&dw='+weight+'&dp='+price;
		typeWeightHttpObject	= FormerCommon.createHttpRequest(shoppingSettingDeliveryAddFormResult);
		if( typeWeightHttpObject ) {
			typeWeightHttpObject.open("GET",url,true);
			typeWeightHttpObject.send(null);
			typeWeightArray.push(typeWeight)
		} else {
			alert('サーバー通信作成に失敗しました!');
		}
	} else {
		alert('追加するブロックが定義されていません!');
	}
}
function shoppingSettingDeliveryAddFormResult() {
	if ((typeWeightHttpObject.readyState == 4) && (typeWeightHttpObject.status == 200)){
		var addPanel	= document.getElementById('shopping-setting-delivery-add');
		if( addPanel ) {
			var newElm		= document.createElement('div');
			newElm.innerHTML	= typeWeightHttpObject.responseText;
			addPanel.appendChild(newElm);
		}
	} else if ((typeWeightHttpObject.readyState == 4) && (typeWeightHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
function shoppingSettingDeliveryDelete( type, weight ) {
	var typeName	= '普通便';
	if( type=='1' ) {
		typeName	= 'クール便';
	} else {
		type	= '0';
	}
	var blockId	= 'block_'+type+'_'+weight;
	var targetElm	= document.getElementById(blockId);
	if( targetElm ) {
		if( confirm('配送目安'+weight+'の'+typeName+'を削除します!\n本当に削除してよろしいですか?!')) {
			targetElm.innerHTML	= '';
		}
	}
}
if(window.attachEvent){
	window.attachEvent('onload',shoppingSettingDeliveryAddInit);
}else{
	window.addEventListener('DOMContentLoaded',shoppingSettingDeliveryAddInit,false);
}
//--></script>

{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../../">&gt;&gt; {write:SHOPPING_LABEL_ORDER}一覧へ</a>
	</div>