<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.Form}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 追加・編集'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		{if:is_object(shopping.product.product_object->'searchDataObject')}
		&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}</a>
		&gt; <a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		{if:strlen(shopping.product.product_object->'product_number')==0}
		&gt; {write:SHOPPING_LABEL_PRODUCT}の新規追加
		{else}
		&gt; <a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">{write:shopping.product.product_object->'product_name'}</a>
		&gt; 編集
		{/if}
	</div>

	<h1>
		{write:SHOPPING_LABEL_PRODUCT}管理
		{if:is_object(shopping.product.product_object->'searchDataObject')}
			&gt; {write:shopping.product.product_object->'searchDataObject'->'subject'}
		{/if}
		{if:strlen(shopping.product.product_object->'product_number')==0}
		&gt; {write:SHOPPING_LABEL_PRODUCT}の新規追加
		{else}
		&gt; {write:shopping.product.product_object->'product_name'}
		&gt; 編集
		{/if}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}
	
	{if:is_object(shopping.product.product_object->'searchDataObject')}
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の施設一覧</a>
		|
		<a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細</a>
	</div>
	{/if}
	{if:strlen(shopping.product.product_object->'product_number')!=0 && shopping.product.product_object->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この{write:SHOPPING_LABEL_PRODUCT}は現在非公開です。{write:SHOPPING_LABEL_PRODUCT}一覧または詳細表示画面で状態を「掲載中」に変更してください。
	</div>
	{/if}

	<form name="cform" action="./confirm.php?shpdn={write:shopping.product.product_object->'product_number'}&amp;schdi={write:shopping.product.product_object->'search_data_id'}" method="post" enctype="multipart/form-data">
	<input type="hidden" id="product_number" name="product_number" value="{write:shopping.product.product_object->'product_number'}" />
	<input type="hidden" id="search_data_id" name="search_data_id" value="{write:shopping.product.product_object->'search_data_id'}" />

	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}基本情報</h2>

	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;white-space:nowrap;">商品種別<span class="required">※</span></th>
		<td>
			<select name="delivery_type" onchange="shoppingProductChangeDeliveryType(this)">
			{foreach:SHOPPING_DELIVERY_TYPE_HASH deliveryTypeKey deliveryTypeName}
				<option value="{write:deliveryTypeKey}"
				{if:deliveryTypeKey==shopping.product.product_object->'delivery_type'} selected{/if}
					>{write:deliveryTypeName}</option>
			{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td><input type="text" name="product_id" id="product_id" size="20" value="{write:shopping.product.product_object->'product_id'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">{write:SHOPPING_LABEL_PRODUCT}名<span class="required">※</span></th>
		<td><input type="text" name="product_name" id="product_name" size="50" value="{write:shopping.product.product_object->'product_name'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">{write:SHOPPING_LABEL_PRODUCT}名フリガナ</th>
		<td><input type="text" name="product_kana" id="product_kana" size="60" value="{write:shopping.product.product_object->'product_kana'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号<span class="required">※</span></th>
		<td><input type="text" name="order_number" size="3" value="{write:shopping.product.product_object->'order_number'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>
			<input type="text" name="unit_string" size="10" value="{write:shopping.product.product_object->'unit_string'}" />
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">所属カテゴリ</th>
		<td>
			<?php for( $GLOBALS['num']=0; $GLOBALS['num']<12; $GLOBALS['num']++ ){ ?>
			<select name="category_id[{write:num}]">
				<option value=""{if:strlen(shopping.product.product_object->'categoryIdArray'[num])==0} selected{/if}></option>
			{foreach:shopping.category.data_array categoryNum categoryObject}
			{set:child_category_array categoryObject->'child_category_object_array'}
				<option value="{write:categoryObject->'category_id'}"
					{if:categoryObject->'category_id'==shopping.product.product_object->'categoryIdArray'[num]} selected{/if}
					>{write:categoryObject->'category_name'}</option>
				{foreach:child_category_array childCategoryObject}
				{set:grand_child_category_array childCategoryObject->'child_category_object_array'}
				<option value="{write:childCategoryObject->'category_id'}"
					{if:childCategoryObject->'category_id'==shopping.product.product_object->'categoryIdArray'[num]} selected{/if}
					>&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}</option>
					{foreach:grand_child_category_array grandChildCategoryObject}
					<option value="{write:grandChildCategoryObject->'category_id'}"
						{if:grandChildCategoryObject->'category_id'==shopping.product.product_object->'categoryIdArray'[num]} selected{/if}
						>&nbsp;&nbsp;--&nbsp;{write:grandChildCategoryObject->'category_name'}</option>
					{/foreach}
				{/foreach}
			{/foreach}
			</select>
			<?php } ?>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<span style="white-space: nowrap;"><input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:is_array(shopping.product.product_object->'memberViewableArray') && in_array(key,shopping.product.product_object->'memberViewableArray')} checked{/if}
			/>{write:mb_substr(value,0,10)}</span>
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<span style="white-space: nowrap;"><input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:is_array(shopping.product.product_object->'memberPurchasableArray') && in_array(key,shopping.product.product_object->'memberPurchasableArray')} checked{/if}
			/>{write:mb_substr(value,0,10)}</span>
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">公式紹介URL</th>
		<td>
			<input type="text" name="product_url" size="60" value="{write:shopping.product.product_object->'product_url'}" />
		</td>
	</tr>
	<tr>
		<th style="width:12em;">検索キーワード</th>
		<td><input type="text" name="keywords" size="60" value="{write:shopping.product.product_object->'keywords'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;">キャッチコピー</th>
		<td><textarea name="catch_copy" cols="50" rows="2">{write:shopping.product.product_object->'catch_copy'}</textarea></td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文<span class="required">※</span></th>
		<td>
			<textarea name="description" cols="50" rows="5">{write:shopping.product.product_object->'description'}</textarea><br />
			<span class="form_attention">※全角1,000文字まで</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">関連商品ID</th>
		<td>
			<?php for( $GLOBALS['num']=0; $GLOBALS['num']<5; $GLOBALS['num']++ ){ ?>
			<input type="text" size="10" name="related_product_id[{write:num}]"
			value="{if:isset(shopping.product.product_object->'relatedProductIdArray'[num])}{write:shopping.product.product_object->'relatedProductIdArray'[num]}{/if}" />
			<?php } ?><br />
			<span class="form_attention">※半角英数字で関連商品のIDを入力できます。</span>
		</td>
	</tr>
	</tbody>
	</table>
	
	<table class="detail" id="shopping-product-calendar-type" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			<select name="calendar_type">
				<option value="0">全体カレンダー利用</option>
				<option value="1"{if:'1'==shopping.product.product_object->'calendar_type'} selected{/if}>個別カレンダー利用</option>
			</select>
		</td>
	</tr>
	</tbody>
	</table>
	<br />

	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}画像</h2>
	{set:fileIdArray shopping.product.product_object->'fileIdArray_org'}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<?php for( $GLOBALS['number']=0; $GLOBALS['number']<10; $GLOBALS['number']++ ) { ?>
	<tr>
		<th style="width:12em;">画像{write:number+1}</th>
		<td>
			{if:isset(fileIdArray[number])}
				<input type="checkbox" name="delete_fileIdArray[]" value="{write:fileIdArray[number]}"
					onclick="if(this.checked){document.getElementById('productfiles_{write:number}').disabled='disabled';}else{document.getElementById('productfiles_{write:number}').disabled='';}"
					/> 削除<br />
				<img src="/file/download.php?fi={write:fileIdArray[number]}&amp;w=180&amp;h=180" /><br />
			{/if}
			<input type="file" id="productfiles_{write:number}" name="productfiles[{write:number}]" size="60" value="" />
		</td>
	</tr>
	<?php } ?>
	</tbody>
	</table>
	<br />
	
	<div style="width:96%;margin:0 auto;text-align:right;">
	{if:strlen(shopping.product.product_object->'detail_comment')>0}
		<a id="shopping-product-detail-button" href="javascript:shoppingProductDetailViewChange()">▲追加説明(HTML可)設定を非表示</a>
	{else}
		<a id="shopping-product-detail-button" href="javascript:shoppingProductDetailViewChange()">▼追加説明(HTML可)設定を表示</a>
	{/if}
	</div>
	
	<div id="shopping-product-detail"
		{if:strlen(shopping.product.product_object->'detail_comment')>0}
		{else}
		style="display:none;visibility:hidden;position:absolute;z-index:-999;top:0px;left:0px;"
		{/if} 
	>
	<h2 class="global">追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;text-align:right;">
		※HTML可。全角換算5,000文字まで。
	</div>
	<div style="width:96%;margin:0 auto;">
		<textarea name="detail_comment" cols="60" rows="10"
		style="width:100%;"
		>{write:shopping.product.product_object->'detail_comment'}</textarea><br />
	</div>
	<br />
	</div>
	
	<div style="width:96%;margin:0 auto;text-align:right;">
	{if:strlen(shopping.product.product_object->'option1_name')>0 || strlen(shopping.product.product_object->'option2_name')>0 || strlen(shopping.product.product_object->'option3_name')>0 || strlen(shopping.product.product_object->'option4_name')>0 || strlen(shopping.product.product_object->'option5_name')>0}
		<a id="shopping-product-option-button" href="javascript:shoppingProductOptionViewChange()">▲{write:SHOPPING_LABEL_ORDER}オプション設定を非表示</a>
	{else}
		<a id="shopping-product-option-button" href="javascript:shoppingProductOptionViewChange()">▼{write:SHOPPING_LABEL_ORDER}オプション設定を表示</a>
	{/if}
	</div>
	
	<div id="shopping-product-option"
		{if:strlen(shopping.product.product_object->'option1_name')>0 || strlen(shopping.product.product_object->'option2_name')>0 || strlen(shopping.product.product_object->'option3_name')>0 || strlen(shopping.product.product_object->'option4_name')>0 || strlen(shopping.product.product_object->'option5_name')>0}
		{else}
		style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"
		{/if} 
	>
	<h2 class="global">{write:SHOPPING_LABEL_ORDER}オプション</h2>
	
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']	= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.product_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
<script language="JavaScript" type="text/javascript"><!--
function shoppingProductChangeOptionType{write:optionNumber}(radioObject) {
	var selectVal	= radioObject.value;
	var elmSelect	= document.getElementById('shopping-product-option{write:optionNumber}-setting-select');
	var elmText		= document.getElementById('shopping-product-option{write:optionNumber}-setting-text');
	var elmTextArea	= document.getElementById('shopping-product-option{write:optionNumber}-setting-textarea');
	if( 'text' == selectVal ) {
		elmSelect.style.display		= 'none';
		elmSelect.style.visibility		= 'hidden';
		elmSelect.style.position		= 'absolute';
		elmTextArea.style.display	= 'none';
		elmTextArea.style.visibility	= 'hidden';
		elmTextArea.style.position		= 'absolute';
		elmText.style.display		= 'block';
		elmText.style.visibility		= 'visible';
		elmText.style.position			= 'static';
	} else if( 'textarea' == selectVal ) {
		elmSelect.style.display		= 'none';
		elmSelect.style.visibility		= 'hidden';
		elmSelect.style.position		= 'absolute';
		elmTextArea.style.display	= 'block';
		elmTextArea.style.visibility	= 'visible';
		elmTextArea.style.position		= 'static';
		elmText.style.display		= 'none';
		elmText.style.visibility		= 'hidden';
		elmText.style.position			= 'absolute';
	} else {
		elmSelect.style.display		= 'block';
		elmSelect.style.visibility		= 'visible';
		elmSelect.style.position		= 'static';
		elmTextArea.style.display	= 'none';
		elmTextArea.style.visibility	= 'hidden';
		elmTextArea.style.position		= 'absolute';
		elmText.style.display		= 'none';
		elmText.style.visibility		= 'hidden';
		elmText.style.position			= 'absolute';
		document.cform.{write:optionItemsName}.value = '';
	}
	return true;
}
function shoppingProductOptionTypeText{write:optionNumber}(textObject) {
	document.cform.{write:optionItemsName}.value = '__INPUT_TYPE_TEXT__\n' + textObject.value;
}
function shoppingProductOptionTypeTextArea{write:optionNumber}(colText,rowText) {
	document.cform.{write:optionItemsName}.value = '__INPUT_TYPE_TEXTAREA__\n' + colText.value + '\n' + rowText.value;
}
//--></script>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>
			<input type="text" name="{write:optionVarName}" size="30" value="{write:shopping.product.product_object->optionVarName}" />
			<input type="radio" name="option_type{write:optionNumber}"  value="select" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__SELECT__'} checked{/if} />セレクト
			<input type="radio" name="option_type{write:optionNumber}" value="text" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__INPUT_TYPE_TEXT__'} checked{/if} />テキスト
			<input type="radio" name="option_type{write:optionNumber}" value="textarea" onclick="shoppingProductChangeOptionType{write:optionNumber}(this)"{if:optionType=='__INPUT_TYPE_TEXTAREA__'} checked{/if} />複数行テキスト
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			<div id="shopping-product-option{write:optionNumber}-setting-text" style="{if:optionType=='__INPUT_TYPE_TEXT__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				サイズ <input type="text" size="5" name="option{write:optionNumber}_text_width" value="{write:optionCols}" onblur="shoppingProductOptionTypeText{write:optionNumber}(this);" />
			</div>
			<div id="shopping-product-option{write:optionNumber}-setting-textarea" style="{if:optionType=='__INPUT_TYPE_TEXTAREA__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				幅 <input type="text" size="5" name="option{write:optionNumber}_textarea_cols" value="{write:optionCols}" onblur="shoppingProductOptionTypeTextArea{write:optionNumber}(this,document.cform.option{write:optionNumber}_textarea_rows);" />
				行数 <input type="text" size="5" name="option{write:optionNumber}_textarea_rows" value="{write:optionRows}" onblur="shoppingProductOptionTypeTextArea{write:optionNumber}(document.cform.option{write:optionNumber}_textarea_cols,this);" />
			</div>
			<div id="shopping-product-option{write:optionNumber}-setting-select" style="{if:optionType=='__SELECT__'}{else}display:none;visibility:hidden;position:absolute;{/if};">
				<textarea name="{write:optionItemsName}" cols="40" rows="5">{write:shopping.product.product_object->optionItemsName}</textarea><br />
				<span class="form_attention">選択ボックス：選択肢を改行区切りで入力してください。<br />選択肢の場合は(ラベル:金額:コスト)と1行にコロン区切りの記述で選択肢ごとに金額設定できます。</span>
			</div>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			<textarea name="{write:optionExpName}" cols="50" rows="2">{write:shopping.product.product_object->optionExpName}</textarea>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			<input type="radio" id="{write:optionCalcName}_0" name="{write:optionCalcName}" value="0"{if:'1'!=shopping.product.product_object->optionCalcName} checked{/if}
			/><label for="{write:optionCalcName}_0">注文数で乗算する</label>
			<input type="radio" id="{write:optionCalcName}_1" name="{write:optionCalcName}" value="1"{if:'1'==shopping.product.product_object->optionCalcName} checked{/if}
			/><label for="{write:optionCalcName}_1">注文数で乗算しない</label>
		</td>
	</tr>
	</tbody>
	</table><br />
	<?php } ?>
	</div>
	
	<div style="width:96%;margin:0 auto;text-align:right;">
	{if:strlen(shopping.product.product_object->'wholesaler_name')>0 || strlen(shopping.product.product_object->'wholesaler_email')>0 || strlen(shopping.product.product_object->'wholesaler_note')>0}
		<a id="shopping-product-wholesaler-button" href="javascript:shoppingProductWholesalerViewChange()">▲卸業者登録を非表示</a>
	{else}
		<a id="shopping-product-wholesaler-button" href="javascript:shoppingProductWholesalerViewChange()">▼卸業者登録を表示</a>
	{/if}
	</div>
	<div id="shopping-product-wholesaler"
		{if:strlen(shopping.product.product_object->'wholesaler_name')>0 || strlen(shopping.product.product_object->'wholesaler_email')>0 || strlen(shopping.product.product_object->'wholesaler_note')>0}
		{else}
		style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"
		{/if} 
	>
	<h2 class="global">卸元情報</h2>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">卸業者名</th>
		<td><input type="text" name="wholesaler_name" size="30" value="{write:shopping.product.product_object->'wholesaler_name'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メールアドレス</th>
		<td><input type="text" name="wholesaler_email" size="30" value="{write:shopping.product.product_object->'wholesaler_email'}" /></td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メモ</th>
		<td><textarea name="wholesaler_note" cols="40" rows="5">{write:shopping.product.product_object->'wholesaler_note'}</textarea></td>
	</tr>
	</tbody>
	</table>
	<br />
	</div>
	
	{if:strlen(shopping.product.product_object->'product_number')==0}
	{set:shoppingProductUnitObject shopping.product.product_object->'unitObjectArray'[0]}
	<!-- 新規作成の場合のみ販売単位を同時作成できる -->
	<h2 class="global">販売単位の作成</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">販売単位名<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_unit_name" size="30" value="{write:shoppingProductUnitObject->'unit_name'}" />
			<br />
			<span class="form_attention">※60文字以内で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名フリガナ</th>
		<td>
			<input type="text" name="unit_unit_kana" size="30" value="{write:shoppingProductUnitObject->'unit_kana'}" />
			<br />
			<span class="form_attention">※並び順にのみ利用されます。60文字以内で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">Web用在庫数<span class="required">※</span></th>
		<td>
			<input type="radio" name="stock_type" id="stock_type_p1" value="1"{if:shoppingProductUnitObject->'stock'>=0} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_p1" style="cursor:pointer;">数入力</label>
			<input type="radio" name="stock_type" id="stock_type_m1" value="-1"{if:shoppingProductUnitObject->'stock'==-1} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m1" style="cursor:pointer;">無制限</label>
			<input type="radio" name="stock_type" id="stock_type_m2" value="-2"{if:shoppingProductUnitObject->'stock'==-2} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m2" style="cursor:pointer;">在庫連動(最少)</label>
			<input type="radio" name="stock_type" id="stock_type_m3" value="-3"{if:shoppingProductUnitObject->'stock'==-3} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m3" style="cursor:pointer;">在庫連動(最多)</label>
			<input type="radio" name="stock_type" id="stock_type_m4" value="-4"{if:shoppingProductUnitObject->'stock'==-4} checked{/if}
				onclick="shoppingProductUnitChangeStockType(this)"
			/><label for="stock_type_m4" style="cursor:pointer;">在庫連動(合計)</label>
			<div id="stock_input_num"{if:shoppingProductUnitObject->'stock'<0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="unit_stock" size="5" value="{write:shoppingProductUnitObject->'stock'}" /><br />
				<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
			</div>
			<div id="stock_input_relation"{if:shoppingProductUnitObject->'stock'>=0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="unit_stock_relation" size="90" value="{write:shoppingProductUnitObject->'stock_relation'}" /><br />
				<span class="form_attention">※在庫を連動させる{write:SHOPPING_LABEL_PRODUCT}販売単位IDを入力してください。/(半角スラッシュ)で区切って複数と連動できます。</span><br />
				在庫共有減算数:<input type="text" size="2" name="unit_stock_relation_count" value="{write:shoppingProductUnitObject->'stock_relation_count'}"
				/>個
			</div>
<script type="text/javascript"><!--
function shoppingProductUnitChangeStockType(radioObject){
	document.cform.unit_stock.value = radioObject.value;
	var inputNumPanel = document.getElementById('stock_input_num');
	var inputRelation = document.getElementById('stock_input_relation');
	if( document.cform.unit_stock.value == '-1' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else if( parseInt(document.cform.unit_stock.value) < 0 ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'block';
		inputRelation.style.visibility = 'visible';
		inputRelation.style.position   = 'static';
		inputRelation.style.zIndex     = '99';
	} else {
		inputNumPanel.style.display = 'block';
		inputNumPanel.style.visibility = 'visible';
		inputNumPanel.style.position   = 'static';
		inputNumPanel.style.zIndex     = '99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	}
}
//--></script>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">実在庫数<span class="required">※</span></th>
		<td>
			<input type="radio" name="stockd_type" id="stockd_type_p" value=""{if:strlen(shoppingProductUnitObject->'stock_display')==0} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_p" style="cursor:pointer;">Web在庫と同じ</label>
			<input type="radio" name="stockd_type" id="stockd_type_p1" value="1"{if:strlen(shoppingProductUnitObject->'stock_display')>0 && shoppingProductUnitObject->'stock_display'>=0} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_p1" style="cursor:pointer;">数入力</label>
			<input type="radio" name="stockd_type" id="stockd_type_m1" value="-1"{if:strlen(shoppingProductUnitObject->'stock_display')>0 && shoppingProductUnitObject->'stock_display'==-1} checked{/if}
				onclick="shoppingProductUnitChangeStockdType(this)"
			/><label for="stockd_type_m1" style="cursor:pointer;">無制限</label>
			<div id="stockd_input_num"{if:strlen(shoppingProductUnitObject->'stock_display')==0 || shoppingProductUnitObject->'stock_display'<0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="unit_stock_display" size="5" value="{write:shoppingProductUnitObject->'stock_display'}" /><br />
				<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
			</div>
			<div id="stockd_input_relation"{if:strlen(shoppingProductUnitObject->'stock_display')==0 || shoppingProductUnitObject->'stock_display'>=0} style="display:none;visibility:hidden;position:absolute;z-index:-999;"{/if}>
				<input type="text" name="unit_stock_display_relation" size="90" value="{write:shoppingProductUnitObject->'stock_display_relation'}" /><br />
				<span class="form_attention">※在庫を連動させる{write:SHOPPING_LABEL_PRODUCT}販売単位IDを入力してください。/(半角スラッシュ)で区切って複数と連動できます。</span>
			</div>
<script type="text/javascript"><!--
function shoppingProductUnitChangeStockdType(radioObject){
	document.cform.unit_stock_display.value = radioObject.value;
	var inputNumPanel = document.getElementById('stockd_input_num');
	var inputRelation = document.getElementById('stockd_input_relation');
	if( document.cform.unit_stock_display.value == '-1' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else if( parseInt(document.cform.unit_stock_display.value) < 0 ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'visible';
		inputRelation.style.position   = 'static';
		inputRelation.style.zIndex     = '99';
	} else if( document.cform.unit_stock_display.value == '' ) {
		inputNumPanel.style.display = 'none';
		inputNumPanel.style.visibility = 'hidden';
		inputNumPanel.style.position   = 'absolute';
		inputNumPanel.style.zIndex     = '-99';
		inputRelation.style.display = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	} else {
		inputNumPanel.style.display = 'block';
		inputNumPanel.style.visibility = 'visible';
		inputNumPanel.style.position   = 'static';
		inputNumPanel.style.zIndex     = '99';
		inputRelation.style.display    = 'none';
		inputRelation.style.visibility = 'hidden';
		inputRelation.style.position   = 'absolute';
		inputRelation.style.zIndex     = '-99';
	}
}
//--></script>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">付与ポイント数</th>
		<td>
			<input type="text" name="unit_present_point" size="5" value="{write:shoppingProductUnitObject->'present_point'}" />Pt.
			<br />
			<span class="form_attention">※半角数字で入力してください。ポイント付与は会員ログインでの{write:SHOPPING_LABEL_ORDER}の場合だけです。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">標準価格(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_price_standard" size="10" value="{write:shoppingProductUnitObject->'price_standard'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下でメーカー希望小売価格などを入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">販売価格(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_price_sell" size="10" value="{write:shoppingProductUnitObject->'price_sell'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">仕入れ値(税込)<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_cost" size="10" value="{write:shoppingProductUnitObject->'cost'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモ割引</th>
		<td>
			<input type="radio" name="unit_discount_exception" value="0"{if:shoppingProductUnitObject->'discount_exception'!=1} checked{/if} />通常
			<input type="radio" name="unit_discount_exception" value="1"{if:shoppingProductUnitObject->'discount_exception'==1} checked{/if} />割引しない
		</td>
	</tr>
	</tbody>
	</table><br />
	
	<div id="shopping-product-delivery">
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">梱包目安値<span class="required">※</span></th>
		<td>
			<input type="text" name="unit_delivery_weight" size="10" value="{write:shoppingProductUnitObject->'delivery_weight'}" />
			<br />
			<span class="form_attention">
				※半角数字のみ7ケタ以下入力してください。<br />
				お客様ご{write:SHOPPING_LABEL_ORDER}の際に{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}のこの数字の合計で配送量サイズ設定が決定します。
			</span>
		</td>
	</tr>
	</tbody>
	</table><br />
	</div>
		
	<div id="shopping-product-monthly">
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">月次課金価格(税込)</th>
		<td>
			<input type="text" name="unit_price_monthly" size="10" value="{write:shoppingProductUnitObject->'price_monthly'}" />円
			<br />
			<span class="form_attention">※半角数字のみ8ケタ以下で入力してください。</span>
		</td>
	</tr>
	</tbody>
	</table><br />
	</div>
		
	<div id="shopping-product-reserve">
	<input type="hidden" name="unit_service_term" value="{write:shoppingProductUnitObject->'service_term'}" />
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">予約日制限</th>
		<td>
			<input type="text" size="5" name="rsv_permit_start" value="{write:shoppingProductUnitObject->'rsv_permit_start'}"
			/>営業日後から<input type="text" size="5" name="rsv_permit_limit" value="{write:shoppingProductUnitObject->'rsv_permit_limit'}"
			/>日後まで予約可能<br />
			<span class="form_attention">※半角数字で入力してください。制限しない場合は入力の必要はありません。</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			<select name="unit_calendar_type">
				<option value="0">全体カレンダー利用</option>
				<option value="1"{if:'1'==shoppingProductUnitObject->'calendar_type'} selected{/if}>個別カレンダー利用</option>
				<option value="2"{if:'2'==shoppingProductUnitObject->'calendar_type'} selected{/if}>プロダクトカレンダー利用</option>
			</select>
		</td>
	</tr>
	</tbody>
	</table><br />

	<div id="shopping-product-reserve-stay">
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th style="width:12em;">チェックイン時間</th>
			<td>
				<select name="unit_default_start_time" onchange="chengeServiceTerm()">
					<?php for( $hour=1; $hour<24; $hour++ ) { $GLOBALS['thour'] = sprintf('%02d',$hour).':00'; ?>
					<option value="{write:thour}"
						{if:shoppingProductUnitObject->'default_start_time'==thour . ':00'} selected{/if}
					>{write:thour}</option>
					<?php } ?>
				</select>
			</td>
		</tr>
		<tr>
			<th style="width:12em;">チェックアウト時間</th>
			<td>
				{set:checkoutTime '10:00'}
				{if:strlen(shoppingProductUnitObject->'default_start_time')>0}
				{set:checkoutTime substr(shoppingProductUnitObject->'default_start_time',strpos(':',shoppingProductUnitObject->'default_start_time')) + (shoppingProductUnitObject->'service_term'/(60*60)) - 24}
				{/if}
				<select name="checkout_time" onchange="chengeServiceTerm()">
					<option value=""></option>
					<?php for( $hour=0; $hour<24; $hour++ ) { $GLOBALS['thour'] = sprintf('%02d',$hour).':00'; ?>
					<option value="<?php echo $hour; ?>"
						<?php if($GLOBALS['checkoutTime']==$hour){ ?> selected<?php } ?>
					>{write:thour}</option>
					<?php } ?>
				</select>
	<script type="text/javascript"><!--
	function chengeServiceTerm(){
		var checkInSelect = document.cform.default_start_time;
		var checkOutSelect = document.cform.checkout_time;
		if( checkOutSelect.options[checkOutSelect.selectedIndex].value.length > 0 ) {
			var sHS = checkInSelect.options[checkInSelect.selectedIndex].value;
			var sH = sHS.substring(0,sHS.indexOf(':'));
			var eH = checkOutSelect.options[checkOutSelect.selectedIndex].value;
			var th = 24 - parseInt(sH) + parseInt(eH);
			document.cform.unit_service_term.value = new String(th*60*60);
		} else {
			document.cform.unit_service_term.value = new String(16*60*60);
		}
	}
	//--></script>
			</td>
		</tr>
		</tbody>
		</table><br />
	</div>

	<div id="shopping-product-reserve-hour">
		<table class="detail" style="width:96%;margin:0 auto;">
		<tbody>
		<tr>
			<th style="width:12em;">サービス提供時間</th>
			<td>
				<input type="text" size="5" name="service_term_text" value="{if:(shoppingProductUnitObject->'service_term' % (60*60))==0}{write:(shoppingProductUnitObject->'service_term' / (60*60))}{else-if:(shoppingProductUnitObject->'service_term' % (60))==0}{write:(shoppingProductUnitObject->'service_term' / (60))}{else}{write:(shoppingProductUnitObject->'service_term')}{/if}"
				onblur="chengeServiceTerm()"
				/><select name="service_term_select" onchange="chengeServiceTerm()">
					<option value="min">分</option>
					<option value="hour"{if:(shoppingProductUnitObject->'service_term' % (60*60))==0} selected{/if}>時間</option>
				</select>
<script type="text/javascript"><!--
function chengeServiceTerm(){
	var termSelectObj	= document.cform.service_term_select;
	var termText 		= document.cform.service_term_text.value;
	if( termSelectObj.options[termSelectObj.selectedIndex].value.length > 0 ) {
		var sHS = termSelectObj.options[termSelectObj.selectedIndex].value;
		if( 'hour' == sHS ) {
			document.cform.unit_service_term.value	= 60*60*parseInt(termText);
		} else {
			document.cform.unit_service_term.value	= 60*parseInt(termText);
		}
	} else {
		document.cform.unit_service_term.value = new String(1*60*60);
	}
}
//--></script>
			</td>
		</tr>
		</tbody>
		</table><br />
	</div>
	</div>
	
	{/if}
	
	<p style="text-align:center;">
		<input type="submit" value="{if:strlen(shopping.product.product_object->'product_number')==0}作成{else}編集{/if}する"
		/><br />
	</p>
	<p style="text-align:center;">
	</p>
	</form>
	<br />
<script language="JavaScript" type="text/javascript" src="/js/textformer/textformer.js"></script>  
<script language="JavaScript" type="text/javascript"><!--
function shoppingProductOptionViewChange() {
	var optionButton	= document.getElementById('shopping-product-option-button');
	var optionPanel		= document.getElementById('shopping-product-option');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display	= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲{write:SHOPPING_LABEL_ORDER}オプション設定を非表示';
				} else {
					optionButton.innerHTML	= '▲{write:SHOPPING_LABEL_ORDER}オプション設定を非表示';
				}
			} else {
				optionPanel.style.display			= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼{write:SHOPPING_LABEL_ORDER}オプション設定を表示';
				} else {
					optionButton.innerHTML	= '▼{write:SHOPPING_LABEL_ORDER}オプション設定を表示';
				}
			}
		}
	}
}
function shoppingProductWholesalerViewChange() {
	var optionButton	= document.getElementById('shopping-product-wholesaler-button');
	var optionPanel		= document.getElementById('shopping-product-wholesaler');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display	= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲卸業者登録を非表示';
				} else {
					optionButton.innerHTML	= '▲卸業者登録を非表示';
				}
			} else {
				optionPanel.style.display	= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼卸業者登録を表示';
				} else {
					optionButton.innerHTML	= '▼卸業者登録を表示';
				}
			}
		}
	}
}
function shoppingProductDetailViewChange() {
	var optionButton	= document.getElementById('shopping-product-detail-button');
	var optionPanel		= document.getElementById('shopping-product-detail');
	if( optionPanel ) {
		if( optionPanel.style ) {
			if( optionPanel.style.visibility == 'hidden' ) {
				optionPanel.style.display		= 'block';
				optionPanel.style.visibility	= 'visible';
				optionPanel.style.position		= 'static';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▲追加説明(HTML可)設定を非表示';
				} else {
					optionButton.innerHTML	= '▲追加説明(HTML可)設定を非表示';
				}
				if( shoppingProductTextFormerObject ){
				}else{
					shoppingProductDetailInit();
				}
			} else {
				shoppingProductTextFormerObject.remove();
				shoppingProductTextFormerObject	= null;
				optionPanel.style.display	= 'none';
				optionPanel.style.visibility	= 'hidden';
				optionPanel.style.position		= 'absolute';
				if( optionButton && optionButton.nodeName && optionButton.nodeName == 'input' ) {
					optionButton.value		= '▼追加説明(HTML可)設定を表示';
				} else {
					optionButton.innerHTML	= '▼追加説明(HTML可)設定を表示';
				}
			}
		}
	}
}
//
// HTML編集エリア
//
var shoppingProductTextFormerObject;
function shoppingProductDetailInit() {
	shoppingProductTextFormerObject	= TextFormer( document.cform.detail_comment, "", "" );
	shoppingProductTextFormerObject.setSubject('詳細説明HTML編集');
}
//
// 商品種別変更
//
function shoppingProductChangeDeliveryType(selectBox){
	var deliveryType	= selectBox.options[selectBox.selectedIndex].value;
	var calTypeBox		= document.getElementById('shopping-product-calendar-type');
	{if:strlen(shopping.product.product_object->'product_number')==0}
	var weightBox			= document.getElementById('shopping-product-delivery');
	var monthlyBox		= document.getElementById('shopping-product-monthly');
	var reserveBox		= document.getElementById('shopping-product-reserve');
	var reserveStayBox	= document.getElementById('shopping-product-reserve-stay');
	var reserveHourBox	= document.getElementById('shopping-product-reserve-hour');
	{/if}
	if( parseInt(deliveryType) >= 200 ){
		calTypeBox.style.display		= 'table';
		{if:strlen(shopping.product.product_object->'product_number')==0}
		reserveBox.style.display		= 'block';
		if( parseInt(deliveryType) == 900 ){
			reserveStayBox.style.display		= 'block';
			reserveHourBox.style.display		= 'none';
		}else if( parseInt(deliveryType) == 200 ){
			reserveStayBox.style.display		= 'none';
			reserveHourBox.style.display		= 'block';
		}
		weightBox.style.display	= 'none';
		monthlyBox.style.display	= 'none';
		{/if}
	} else if( parseInt(deliveryType) >= 100 ){
		calTypeBox.style.display		= 'none';
		{if:strlen(shopping.product.product_object->'product_number')==0}
		reserveBox.style.display		= 'none';
		monthlyBox.style.display		= 'block';
		weightBox.style.display	= 'none';
		{/if}
	} else {
		calTypeBox.style.display		= 'none';
		{if:strlen(shopping.product.product_object->'product_number')==0}
		reserveBox.style.display		= 'none';
		monthlyBox.style.display		= 'none';
		weightBox.style.display	= 'block';
		{/if}
	}
}
function shoppingProductChangeDeliveryTypeInit() {
	shoppingProductChangeDeliveryType(document.cform.delivery_type);
}
if(window.attachEvent){
{if:strlen(shopping.product.product_object->'detail_comment')>0}
	window.attachEvent('onload',shoppingProductDetailInit);
{/if}
	window.attachEvent('onload',shoppingProductChangeDeliveryTypeInit);
}else{
{if:strlen(shopping.product.product_object->'detail_comment')>0}
	window.addEventListener('DOMContentLoaded',shoppingProductDetailInit,false);
{/if}
	window.addEventListener('DOMContentLoaded',shoppingProductChangeDeliveryTypeInit,false);
}
//--></script>
{/if}
	<hr style="width:95%;margin:0 auto;margin-top:1em;" />
	{if:is_object(shopping.product.product_object->'searchDataObject')}
	<div style="width:95%;margin:0 auto;text-align:right;">
		<a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の施設一覧</a>
		|
		<a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細</a>
	</div>
	{/if}
	<div style="width:95%;margin:0 auto;text-align:right;">
		{if:strlen(shopping.product.product_object->'product_number')==0}
		{else}
		<a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">&gt;&gt; {write:shopping.product.product_object->'product_name'}の詳細へ戻る</a>
		&nbsp;&nbsp;
		{/if}
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>