<?php include_once( "../../../spider.inc.php" ); ?>
{module:system.package.LoadList}
{module:system.package.install.Session}

	{foreach:system.package.install.install_object_hash packageObject}
	{if:packageObject->getPackageId()=='shopping'}{set:targetPackageObject packageObject}{/if}
	{/foreach}
	
	{if:is_object(targetPackageObject)}
	{set:definitionHash targetPackageObject->'definitionHash'}
	<h1>{write:targetPackageObject->getPackageViewName()}パッケージ</h1>

	<h2>データベース初期化オプション</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">初期化オプション</th>
		<td>
			{if:'1'==definitionHash['SHOPPING_INIT_OPTION']}既存テーブルを利用{/if}
			{if:'2'==definitionHash['SHOPPING_INIT_OPTION']}テーブルがなければ作成{/if}
			{if:'3'==definitionHash['SHOPPING_INIT_OPTION']}テーブルを削除して作成{/if}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}番号の文字列</th>
		<td>
			{write:definitionHash['SHOPPING_ORDER_ID_FORMAT']}
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>消費税の扱い</h2>
	<p>
		{write:SHOPPING_LABEL_ORDER}者へのメールや画面表示で表示するお支払金額合計の内消費税表記計算方法を設定してください。
	</p>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">消費税率</th>
		<td>
			{write:definitionHash['SHOPPING_TAX_RATE']}％
		</td>
	</tr>
	<tr>
		<th style="width:16em;">消費税の計算方法</th>
		<td>
			{if:'1'==definitionHash['SHOPPING_TAX_RULE']}合計金額に税率で計算（切り捨て）{/if}
			{if:'2'==definitionHash['SHOPPING_TAX_RULE']}合計金額に税率で計算（切り上げ）{/if}
			{if:'3'==definitionHash['SHOPPING_TAX_RULE']}合計金額に税率で計算（四捨五入）{/if}
			{if:'4'==definitionHash['SHOPPING_TAX_RULE']}合計金額に税率で計算（五捨六入）{/if}
			{if:'11'==definitionHash['SHOPPING_TAX_RULE']}各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（切り捨て）して合計{/if}
			{if:'12'==definitionHash['SHOPPING_TAX_RULE']}各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（切り上げ）して合計{/if}
			{if:'13'==definitionHash['SHOPPING_TAX_RULE']}各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（四捨五入）して合計{/if}
			{if:'14'==definitionHash['SHOPPING_TAX_RULE']}各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（五捨六入）して合計{/if}
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>通知先メールアドレス</h2>
	<p>カンマ区切りで複数入力できます</p>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">通知先メールアドレス</th>
		<td>
			{write:definitionHash['SHOPPING_MAIL_ADDRESS_NOTIFY']}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">BCCメールアドレス</th>
		<td>
			{write:definitionHash['SHOPPING_MAIL_ADDRESS_BCC']}
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>ショッピング ポイント基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ポイント付与規則</th>
		<td>
			{if:'0'==definitionHash['SHOPPING_POINT_METHOD']}{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}分全てのポイントをそのまま付与{/if}
			{if:'1'==definitionHash['SHOPPING_POINT_METHOD']}{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}ポイントから利用ポイント分を差し引いて付与{/if}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ポイント清算設定</th>
		<td>
			{if:'1'==definitionHash['SHOPPING_POINT_SETTLE_METHOD']}{write:SHOPPING_LABEL_PRODUCT}代金{/if}
			{if:'2'==definitionHash['SHOPPING_POINT_SETTLE_METHOD']}支払金額{/if}
			の{write:definitionHash['SHOPPING_POINT_SETTLE_RATE']}}％までポイント利用可能<br />
			{write:definitionHash['SHOPPING_POINT_UNIT']}Pt.単位で利用<br />
		</td>
	</tr>
	</tbody>
	</table>
		
	<h2>ショッピング 配送基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">配送無料条件金額</th>
		<td>
			{write:definitionHash['SHOPPING_DELIVERY_FREE_PRICE']}円以上
		</td>
	</tr>
	<tr>
		<th style="width:16em;">クール便の計算方法</th>
		<td>
			{if:'0'==definitionHash['SHOPPING_DELIVERY_TYPE_OPERATION']}クール便の荷物を含むなら全てクール便で配送{/if}
			{if:'1'==definitionHash['SHOPPING_DELIVERY_TYPE_OPERATION']}クール便の荷物を含むなら別口で配送{/if}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">お届け希望日の表示</th>
		<td>
			{write:definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START']}日後から
			{write:definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END']}"日後まで表示する
		</td>
	</tr>
	</tbody>
	</table>
		
	<h2>ショッピング オプション設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ラッピングフリーワード欄表示</th>
		<td>
			{if:'off'==definitionHash['SHOPPING_DELIVERY_RAPPING_FREEWORD']}表示しない{/if}
			{if:'on'==definitionHash['SHOPPING_DELIVERY_RAPPING_FREEWORD']}表示する{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	<h2>状態変更メール通知設定</h2>
	{if:in_array('database2',system.package.installedPackageIdArray)}
		{imodule:database2.Connect}
		{if:in_array('member',system.package.installedPackageIdArray)}
			{imodule:member.mail.template.LoadList}
		{/if}
	{/if}
	<table style="width:95%;margin:0 auto;">
	<tbody>
	{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}者宛{write:statusName}</th>
		<td>{write:SHOPPING_LABEL_ORDER}
			{if:is_array(member.mail.template.data_array)}
			<select name="SHOPPING_ORDER_STATUS_MAIL[{write:statusNumber}]" disabled="disabled">
				<option value="">なし</option>
			{foreach:member.mail.template.data_array mailTemplateObject}
				<option value="{write:mailTemplateObject->'template_id'}"
				{if:definitionHash['SHOPPING_ORDER_STATUS_MAIL'][statusNumber]==mailTemplateObject->'template_id'} selected{/if}
				>{write:mailTemplateObject->'template_name'}</option>
			{/foreach}
			</select>
			{else}
			<input type="hidden" name="SHOPPING_ORDER_STATUS_MAIL[{write:statusNumber}]" value="{write:definitionHash['SHOPPING_ORDER_STATUS_MAIL'][statusNumber]}" />
			{/if}
		</td>
	</tr>
	{/foreach}
	{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
	<tr>
		<th style="width:16em;">オーナー宛{write:statusName}</th>
		<td>
			{if:is_array(member.mail.template.data_array)}
			<select name="SHOPPING_ORDER_STATUS_OWNER_MAIL[{write:statusNumber}]" disabled="disabled">
				<option value="">なし</option>
			{foreach:member.mail.template.data_array mailTemplateObject}
				<option value="{write:mailTemplateObject->'template_id'}"
				{if:definitionHash['SHOPPING_ORDER_STATUS_OWNER_MAIL'][statusNumber]==mailTemplateObject->'template_id'} selected{/if}
				>{write:mailTemplateObject->'template_name'}</option>
			{/foreach}
			</select>
			{else}
			<input type="hidden" name="SHOPPING_ORDER_STATUS_OWNER_MAIL[{write:statusNumber}]" value="{write:definitionHash['SHOPPING_ORDER_STATUS_OWNER_MAIL'][statusNumber]}" />
			{/if}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<br />
	<h2>申込内容変更完了時の状態設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th>管理者操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[1]" disabled="disabled">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][1]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	<tr>
		<th>申込者操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[2]" disabled="disabled">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][2]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	<tr>
		<th>オーナー操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[3]" disabled="disabled">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][3]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	</tbody>
	</table>
	<br />


	<h2>ショッピング ダウンロード{write:SHOPPING_LABEL_PRODUCT}設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ダウンロードURL</th>
		<td>
			{write:definitionHash['SHOPPING_DOWNLOAD_URL']}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ダウンロード回数制限</th>
		<td>
			{write:definitionHash['SHOPPING_DOWNLOAD_MAX_COUNT']}回まで<br />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ダウンロード期間制限</th>
		<td>
			{write:SHOPPING_LABEL_ORDER}完了日時から{write:definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER']}日間<br />
			最後のダウンロードから{write:definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_LAST']}分間<br />
		</td>
	</tr>
	</tbody>
	</table>

	<h2>ショッピング プロモーション基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">プロモーション固定額割引条件</th>
		<td>
			{write:definitionHash['SHOPPING_PROMO_FIXED_DISCOUNT_BTM']}円以上
		</td>
	</tr>
	<tr>
		<th style="width:16em;">プロモーション固定額報酬条件</th>
		<td>
			{write:definitionHash['SHOPPING_PROMO_FIXED_FEE_BTM']}円以上
		</td>
	</tr>
	</tbody>
	</table>

	<h2>ショッピング 会員登録設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">会員登録種別利用</th>
		<td>
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="51"{if:in_array('51',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} disabled="disabled" />アフィリエイト会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="52"{if:in_array('52',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} disabled="disabled" />特別割引会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="53"{if:in_array('53',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} disabled="disabled" />{write:SHOPPING_LABEL_PRODUCT}販売会員
		</td>
	</tr>
	<tr>
		<th style="width:16em;">会員種別の公募</th>
		<td>
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="51"{if:in_array('51',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} disabled="disabled" />アフィリエイト会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="52"{if:in_array('52',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} disabled="disabled" />特別割引会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="53"{if:in_array('53',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} disabled="disabled" />{write:SHOPPING_LABEL_PRODUCT}販売会員
		</td>
	</tr>
	<tr>
		<th style="width:16em;">直アフィリエイト会員設定</th>
		<td>
			紹介経由{write:SHOPPING_LABEL_ORDER}
			=
			{write:definitionHash['SHOPPING_AFFILIATE_DISCOUNT_VALUE']}
			{if:'rate'==definitionHash['SHOPPING_AFFILIATE_DISCOUNT_TYPE']}％{/if}
			{if:'money'==definitionHash['SHOPPING_AFFILIATE_DISCOUNT_TYPE']}円{/if}
			<br />
			紹介成果報酬
			=
			{write:definitionHash['SHOPPING_AFFILIATE_PAY_VALUE']}
			{if:'rate'==definitionHash['SHOPPING_AFFILIATE_PAY_TYPE']}％{/if}
			{if:'money'==definitionHash['SHOPPING_AFFILIATE_PAY_TYPE']}円{/if}
			<br />
			セルフ{write:SHOPPING_LABEL_ORDER}(卸販売)
			=
			{if:'0'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']}許可しない{/if}
			{if:'1'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']}先払いのみ{/if}
			{if:'2'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']}許可{/if}
			{if:'1'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG'] || '2'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']}
			{write:definitionHash['SHOPPING_AFFILIATE_BUYING_RATE']}％引
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>ショッピング {write:SHOPPING_LABEL_PRODUCT}・販売単位の会員別制限の初期設定</h2>
	<table style="width:95%;margin:0 auto;text-align:center;">
	<thead>
	<tr>
		<th style="width:16em;">会員種別</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<th title="{write:value}">{write:mb_substr(value,0,1)}</th>
		{/foreach}
	</tr>
	</thead>
	<tbody>
	<tr>
		<th style="width:16em;">閲覧</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<td><input type="checkbox" name="SHOPPING_MEMBER_VIEWABLE[]" value="{write:key}"{if:is_array(definitionHash['SHOPPING_MEMBER_VIEWABLE']) && in_array(key,definitionHash['SHOPPING_MEMBER_VIEWABLE'])} checked{/if} disabled="disabled" /></td>
		{/foreach}
	</tr>
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<td><input type="checkbox" name="SHOPPING_MEMBER_PURCHASBLE[]" value="{write:key}"{if:is_array(definitionHash['SHOPPING_MEMBER_PURCHASBLE']) && in_array(key,definitionHash['SHOPPING_MEMBER_PURCHASBLE'])} checked{/if} disabled="disabled" /></td>
		{/foreach}
	</tr>
	</tbody>
	</table>
	<br />
	<h2>ショッピング 予約利用時の設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">予約制限</th>
		<td>
			{write:definitionHash['SHOPPING_RESERVE_ENABLE_START']}日後から{write:definitionHash['SHOPPING_RESERVE_ENABLE_LIMIT']}日後まで予約可能
			<br />
			同時に{write:definitionHash['SHOPPING_RSV_LIMIT_UNIT_AT_ONCE']}{write:SHOPPING_LABEL_PRODUCT}まで申し込み可能<br />
			<br />
			同時に{write:definitionHash['SHOPPING_RSV_LIMIT_TERM_AT_ONCE']}期間のみ申し込み可能<br />
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	<h2>ショッピング 予約利用時の設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">チェックイン時間</th>
		<td>
			{write:definitionHash['SHOPPING_RESERVE_STAY_CHECKIN']}
		</td>
	</tr>
	<tr>
		<th style="width:16em;">チェックアウト時間</th>
		<td>
			{write:definitionHash['SHOPPING_RESERVE_STAY_CHECKOUT']}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	<h2>ショッピング {write:SHOPPING_LABEL_ORDER}時アップロードファイル</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}アップロードファイル利用</th>
		<td>
			<select name="SHOPPING_ORDER_ITEM_FILE_USE" disabled="disabled">
				<option value="0"{if:'1'!=definitionHash['SHOPPING_ORDER_ITEM_FILE_USE']} selected{/if}>利用しない</option>
				<option value="1"{if:'1'==definitionHash['SHOPPING_ORDER_ITEM_FILE_USE']} selected{/if}>利用する</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">保存フォルダパス</th>
		<td>
			{write:definitionHash['SHOPPING_ORDER_ITEM_FILE_ROOT']}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{else}
	<p>操作が正しくありません</p>
	{/if}