<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:content.LoadFolders}
{module:content.LoadList}
{preset:page_title 'コンテンツ管理 > アップロードファイル一覧'}

	<div class="panc">
		<a href="../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../" title="コンテンツ管理トップページを表示します">コンテンツ管理</a>
		&gt; アップロードファイル一覧
	</div>
	<h1>コンテンツ管理 &gt; アップロードファイル一覧</h1>
	
{if:IS_ERROR}
	<h2>
		エラー
	</h2>
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
{else}

	<form name="sform" action="./index.php" method="get">
	<table style="width:95%;margin:0 auto;">
	<tody>
	<tr>
		<td>
			フォルダ選択 <select name="ccurf" onchange="contentFileGetFileList()">
			{foreach:content.folderArray folderPath}
				<option value="{write:folderPath}"
					{if:content.currentFoloder==folderPath} selected{/if}
					>{write:folderPath}</option>
			{/foreach}
			</select>
		</td>
		<td style="text-align:right;">
			<a href="javascript:contentFileViewUploadForm(document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value,'',true,contentFileGetFileList)"
				>ファイルアップロード</a>
		</td>
	</tr>
	<tbody>
	</table>
	</form>
	<br />

	<div id="content-area" style="width:740px;margin:0 auto;"></div>
	<br style="clear:left;" />

<style type="text/css"><!--
div.content-block {
	width:138px;
	float:left;
	text-align:center;
	border:solid 1px #909090;
	padding:2px;
	font-size:10px;
	overflow:none;
	margin-left:1px;
	margin-top:1px;
}
div.content-image {
	width: 100px;
	height: 100px;
	margin: 0 auto;
	text-align: center;
	line-height: 100px;
	white-space: nowrap;
	overflow: hidden;
}
div.content-name {
	width:90%;
	margin:0 auto;
	overflow:hidden;
	font-size:9px;
}
div.content-mod {
	width:90%;
	margin:0 auto;
	overflow:hidden;
	font-size:10px;
}
div.content-size {
	width:90%;
	margin:0 auto;
	overflow:hidden;
	font-size:8px;
}
--></style>
<script language="JavaScript" type="text/javascript"><!--
/*
 * コンテンツ一覧読み込み
 */
var contentFileCurrentFolder;
var contentFileNameArray;
function contentFileGetFileList() {
	contentFileCurrentFolder	= document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value;
	var contentArea = document.getElementById('content-area');
	contentArea.innerHTML	= '';
	var loadImg	= new Image();
	loadImg.src='/js/images/loading_s_01.gif';
	contentArea.appendChild(loadImg);
	contentGetContentList(contentFileCurrentFolder,contentFileGetFileListResult);
}
function contentFileGetFileListResult(contentObjectArray) {
	contentFileNameArray	= new Array();
	var contentArea = document.getElementById('content-area');
	if( contentArea && contentObjectArray ) {
		var childs = contentArea.childNodes;
		for( var i=childs.length-1; i>=0; i-- ) {
			contentArea.removeChild(childs[i]);
		}
		for( var num=0; num<contentObjectArray.length; num++ ) {
			var contentObject	= contentObjectArray[num];
			var divElm			= contentFileCreateBlock(contentObject);
			contentFileNameArray.push(contentObject.name);
			contentArea.appendChild(divElm);
		}
	}
}
function contentFileCreateBlock( contentObject ) {
	var block		= document.createElement('div');
	block.className	= 'content-block';
	var appUri		= contentObject.folder+'/'+contentObject.name;
	if( contentObject.folder == '/' ) {
		appUri		= contentObject.folder+contentObject.name;
	}
	// サムネイル
	var imgBlock	= document.createElement('div');
	imgBlock.className	= 'content-image';
	var linkTag		= document.createElement('a');
	linkTag.target	= '_blank';
	if( 'image' == contentObject.type ) {
		linkTag.href	= '<?php echo preg_replace('/\\/$/','',SPIDER_URI_BASE); ?>'+appUri;
	} else {
		linkTag.href	= './edit/form.php?cturi=' + escape(appUri);
	}
	var thumbImg	= new Image();
	thumbImg.id		= escape(contentObject.name);
	thumbImg.onload	= function() {
		contentFileImageResize(this,95,95);
		setTimeout("contentFileImageResize(document.getElementById('"+this.id+"'),95,95)",100);
	};
	thumbImg.src	= contentObject.thumbnail;
	imgBlock.innerHTML += '&nbsp;';
	linkTag.appendChild(thumbImg);
	thumbImg.style.verticalAlign	= 'text-bottom';
	imgBlock.appendChild(linkTag);
	imgBlock.innerHTML += '&nbsp;';

	block.appendChild(imgBlock);
	// ファイル名
	var nameBlock	= document.createElement('div');
	nameBlock.className	= 'content-name';
	nameBlock.innerHTML	= contentObject.name;
	block.appendChild(nameBlock);
	// 編集欄
	var modBlock		= document.createElement('div');
	modBlock.className	= 'content-mod';
	modBlock.innerHTML	= '<a href="' + '<?php echo preg_replace('/\\/$/','',SPIDER_URI_BASE); ?>'+appUri+'" target="_blank">確認</a> / ';
	if( 'text' == contentObject.type ) {
		modBlock.innerHTML	+= '<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/content/file/edit/form.php?cturi='+escape(appUri)+'">編集</a> / ';
	} else {
		modBlock.innerHTML	+= '<a href="javascript:contentFileViewUploadForm(\''+escape(contentObject.folder)+'\',\''+escape(contentObject.name)+'\',false,contentFileGetFileList)">変更</a> / ';
	}
	modBlock.innerHTML	+= '<a href="javascript:contentFileDelete(\''+appUri+'\')">削除</a>';
	block.appendChild(modBlock);
	// サイズ
	var sizeBlock	= document.createElement('div');
	sizeBlock.className	= 'content-size';
	var imageSize	= '';
	if( contentObject.width && contentObject.width > 0
		&& contentObject.height && contentObject.height > 0 ) {
		imageSize	= contentObject.width+'x'+contentObject.height+'px / ';
	}
	var sizeInt	= parseInt(contentObject.size);
	var sizeStr	= null;
	if( sizeInt	> 1024*1024*1024 ) {
		sizeStr	= new String(Math.round(sizeInt/(1024*1024*1024/10))/10) + 'GB';
	} else if( sizeInt > 1024*1024 ) {
		sizeStr	= new String(Math.round(sizeInt/(1024*1024*2/10))/10) + 'MB';
	} else if( sizeInt > 1024 ) {
		sizeStr	= new String(Math.round(sizeInt/(1024/10))/10) + 'KB';
	}
	sizeBlock.innerHTML	= imageSize + sizeStr;
	block.appendChild(sizeBlock);
	
	
	return block;
}
if(window.attachEvent){
	window.attachEvent('onload',contentFileGetFileList);
}else{
	window.addEventListener('DOMContentLoaded',contentFileGetFileList,false);
}
/**
 * リダイレクト
 */
var contentFileDeleteHttpObject;
if(window.attachEvent){
	window.attachEvent('onload',contentFileInit);
}else{
	window.addEventListener('DOMContentLoaded',contentFileInit,false);
}
function contentFileInit() {
	if( '{write:content.currentFoloder}' == '/' ) {
		window.location.href='./index.php?ccurf=%2Fupload';
	}
}
/**
 * 削除
 */
function contentFileDelete(targetUri){
	if( confirm(targetUri +'をサーバー上から削除します\nこの操作は取り消せません!\n本当に削除してよろしいですか？') ) {
		contentFileDeleteHttpObject	= FormerCommon.createHttpRequest(contentFileDeleteResult);
		var contents	= "command=0";
		contents	+= "&" + encodeURIComponent('target_uri')+ "="+encodeURIComponent(targetUri);
		if (contentFileDeleteHttpObject) {
			FormerCommon.displayGrayOut(9999);
			contentFileDeleteHttpObject.open("POST",'./delete.php',true);
			contentFileDeleteHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			contentFileDeleteHttpObject.send(contents);
		} else {
			alert('サーバーへの接続作成に失敗しました。');
		}
	}
}
/**
 * 保存の結果に応じて次の対象エージェントHTML取得リクエストを送信します
 */
function contentFileDeleteResult() {
	if ((contentFileDeleteHttpObject.readyState == 4) && (contentFileDeleteHttpObject.status == 200)){
	    var lines	= contentFileDeleteHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('削除に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 500);
		} else {
			window.location.reload();
		}
	} else if ((contentFileDeleteHttpObject.readyState == 4) && (contentFileDeleteHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	} else {
	}
}
//--></script>
{/if}