<?php
/*
 * shopping/setting/delivery/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_setting_delivery_Form extends system_login_ModuleBase {
	function shopping_setting_delivery_Form() {
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		// 無条件に全てのレコードを取得
		$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_DELIVERY_SETTING
			.' ORDER BY delivery_weight ASC, prefecture_number ASC'
		;
		$resultHash	= $dbo->queryAll( $sql, 'hash' );
		if ( $resultHash === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			// 取得したハッシュを目安と都道府県ごとに整理
			$deliveryPriceHash	= array();
			foreach( $resultHash as $row ) {
				$type				= $row['delivery_type'];
				$weight				= $row['delivery_weight'];
				$prefectureNumber	= $row['prefecture_number'];
				if( !is_array($deliveryPriceHash[$type]) ) {
					$deliveryPriceHash[$type]	= array();
				}
				if( !is_array($deliveryPriceHash[$type][$weight]) ) {
					$deliveryPriceHash[$type][$weight]	= array();
				}
				$deliveryPriceHash[$type][$weight][$prefectureNumber]	= $row['delivery_price'];
			}
		}
		// 配送無料金額
		$deliveryFreePayment	= 10000;
		if( defined('SHOPPING_DELIVERY_FREE_PRICE') ){
			$deliveryFreePayment	= SHOPPING_DELIVERY_FREE_PRICE;
		}
		// クール便を含む場合の取り扱い
		$deliveryTypeOperation	= 0;
		if( defined('SHOPPING_DELIVERY_TYPE_OPERATION') ) {
			$deliveryTypeOperation	= SHOPPING_DELIVERY_TYPE_OPERATION;
		}
		// ラッピング選択肢
		$rappingSettingUri		= SHOPPING_RAPPING_FILE_URI;
		$deliveryRappingOptions	= system_DataFileWriter::getContents( $request, $rappingSettingUri );
		// ラッピングフリーワード２
		$deliveryRappingFreeWords	= 'off';
		if( defined('SHOPPING_DELIVERY_RAPPING_FREEWORD') ) {
			$deliveryRappingFreeWords	= SHOPPING_DELIVERY_RAPPING_FREEWORD;
		}
		// お届け希望時間帯
		$wishfulTimeUri		= SHOPPING_WISHFUL_TIME_FILE_URI;
		$wishfulTimes		= system_DataFileWriter::getContents( $request, $wishfulTimeUri );
		// お届け希望日
		$deliveryWishfulDayStart	= null;
		$deliveryWishfulDayEnd		= null;
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_START')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_START) > 0 ) {
			$deliveryWishfulDayStart	= SHOPPING_DELIVERY_WISHFUL_DAY_START;
		}
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_END')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_END) > 0 ) {
			$deliveryWishfulDayEnd		= SHOPPING_DELIVERY_WISHFUL_DAY_END;
		}
		$request->setAttribute('shopping.setting.delivery.deliveryPriceHash',$deliveryPriceHash);
		$request->setAttribute('shopping.setting.delivery.deliveryFreePayment',$deliveryFreePayment);
		$request->setAttribute('shopping.setting.delivery.deliveryTypeOperation',$deliveryTypeOperation);
		$request->setAttribute('shopping.setting.delivery.deliveryRappingOptions',$deliveryRappingOptions);
		$request->setAttribute('shopping.setting.delivery.deliveryRappingFreeWords',$deliveryRappingFreeWords);
		$request->setAttribute('shopping.setting.delivery.deliveryWishfulDayStart',$deliveryWishfulDayStart);
		$request->setAttribute('shopping.setting.delivery.deliveryWishfulDayEnd',$deliveryWishfulDayEnd);
		$request->setAttribute('shopping.setting.delivery.wishfulTimes',$wishfulTimes);
	}
}
?>