<?php
/*
 * shopping/promotion/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_promotion_Execute extends system_login_ModuleBase {
	function shopping_promotion_Execute(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$promotionNumber			= stripslashes( $_GET['shppn'] );
		$sessionObjectName			= 'shopping.promotion.modify.object.'.$promotionNumber;
		$sessionConfirmName			= 'shopping.promotion.modify.confirm.'.$promotionNumber;
		$loginUserObject			= $this->getLoginUserObject( $request );
		$shoppingPromotionObject	= $request->getSession($sessionObjectName);
		$confirmResult				= $request->getSession($sessionConfirmName);
		$compareShoppingPromotionObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');

		if( !$request->isError() ) {
			// パッケージ設定読み込み
			$shoppingPackageConfigObject	= spider_Controller::createObject('shopping_PackageConfig');
			if( $shoppingPackageConfigObject->load( $request ) ) {
			} else {
				$request->addLocaledError('system.error.common.noinstalled',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
			
			if( 'OK' != $confirmResult ) {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else if ( get_class($shoppingPromotionObject) != get_class($compareShoppingPromotionObject) ){
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				if( $dbo->loadById( $compareShoppingPromotionObject, $shoppingPromotionObject->promotion_id ) ) {
					if( $shoppingPromotionObject->promotion_number != $compareShoppingPromotionObject->promotion_number ) {
						$request->addLocaledError('system.error.common.data.duplicatedid',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
				if( !$request->isError() ) {
					// エラーがないならデータ登録と更新
					if( $this->isLogin( $request ) ) {
						// ログインしているなら登録ユーザーのユニークIDを設定
						$shoppingPromotionObject->modifier_id	= $loginUserObject->getUniqueId();
					}
					if( strlen(trim($shoppingPromotionObject->promotion_number)) > 0 ) {
						// データ番号が設定済みなら更新
						if( $shoppingPromotionObject->canEditData( $request, $loginUserObject ) ) {
							if( $this->lockData( $request, $shoppingPromotionObject ) ) {
								// 編集ロックを再取得できたら更新
								$shoppingPromotionObject->updated_date	= date('Y-m-d H:i:s');
								$errors	= array();
								if( $dbo->update($shoppingPromotionObject,false) ) {
								} else {
									$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
								}
								$this->unlockData( $request, $shoppingPromotionObject );
							} else {
								$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						} else {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						}
					} else {
						// データ番号がないなら新規挿入
						if( $this->isLogin( $request ) ) {
							// ログインしているなら登録ユーザーのユニークIDを設定
							$shoppingPromotionObject->owner_id	= $loginUserObject->getUniqueId();
						}
						$shoppingPromotionObject->updated_date	= date('Y-m-d H:i:s');
						$shoppingPromotionObject->registered_date	= date('Y-m-d H:i:s');
						if ( strlen(trim($shoppingPromotionObject->promotion_id)) == 0 ) {
							// IDが未入力の場合、IDを自動生成する
							if( !$dbo->setNextId( $shoppingPromotionObject, 'SPSA{num:4}' ) ) {
								$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
						if( !$request->isError() ) {
							// エラーがなければ、インサート
							if( $dbo->insert($shoppingPromotionObject) ){
								// インサートに成功したら
								if( $this->isLogin( $request ) ) {
									// ログインしている場合
									if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
										// 管理者ログインの場合は特に何もしない
									} else {
									}
								} else {
								}
							} else {
								$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('shopping.promotion.promotion_object',	$shoppingPromotionObject);
	}
}
?>