<?php
/*
 * shopping/product/unit/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_product_unit_Confirm extends system_login_ModuleBase {
	function shopping_product_unit_Confirm(){
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$unitNumber			= stripslashes( $_GET['shpun'] );
		$unitId				= stripslashes( $_GET['shpui'] );
		$sessionObjectName	= 'shopping.product.unit.modify.object.'.$unitNumber;
		$sessionConfirmName	= 'shopping.product.unit.modify.confirm.'.$unitNumber;
		// セッション上にあるなら一時アップロードファイルを削除
		$shoppingProductUnitObject	= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductUnitObject ) && is_object($shoppingProductUnitObject->uploader) ) {
			$shoppingProductUnitObject->uploader->deleteTempFiles( $request );
			$request->removeSession($sessionObjectName);
			$request->removeSession($sessionConfirmName);
		}
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$loginUserObject	= $this->getLoginUserObject( $request );
		
		// 編集権限の確認
		if( $this->isLogin( $request ) ) {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインは編集可
			} else {
				if ( $loginUserObject->member_class >= 53 ) {
					// 会員種別が商品販売会員は編集可
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		$fileObjectOrgHash	= array();
		if( !$request->isError() ) {
			if( strlen(trim($unitNumber)) > 0 ) {
				// 商品販売単位番号が指定されているなら編集の為読み込み
				if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber ) ) {
					if( false === $this->lockData( $request, $shoppingProductUnitObject ) ) {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else if ( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel()
						&& $loginUserObject->getUniqueId() != $shoppingProductUnitObject->owner_id ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else {
						// 所有者IDは商品と同じにする
						$shoppingProductUnitObject->shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
						if( $dbo->loadById( $shoppingProductUnitObject->shoppingProductObject, $shoppingProductUnitObject->product_id ) ) {
							$shoppingProductUnitObject->owner_id	= $shoppingProductUnitObject->shoppingProductObject->owner_id;
							// 検索データ連携
							$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
						}
						// 関連ファイルの読み込み
						foreach( $shoppingProductUnitObject->fileIdArray_org as $num => $fileId ) {
							if( $num >= 100 ) {
								$fileBinObject	= spider_Controller::createObject('file_DaoFileBin');
								if( $dbo->loadById( $fileBinObject, $fileId, true ) ) {
									$fileObjectOrgHash[$num]	= $fileBinObject;
								} else {
									$request->addLocaledError('shopping.error.order.download.failtoread',SPIDER_LOG_LEVEL_FATAL,array($num-99));
								}
							}
						}
					}
				} else {
					$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// 商品販売単位番号が指定されていないなら新規作成
				// 商品情報を読み込み
				$shoppingProductUnitObject->shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById( $shoppingProductUnitObject->shoppingProductObject, stripslashes($_POST['product_id']) ) ) {
					$shoppingProductUnitObject->owner_id	= $shoppingProductUnitObject->shoppingProductObject->owner_id;
					// 検索データ連携
					$shoppingProductUnitObject->shoppingProductObject->loadRelatedSearchData( $dbo );
				} else {
					$request->addLocaledError('shopping.error.product.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
	
			// 入力値のセットとチェック
			$unit_id									= $request->getParam('unit_id','post');
			$shoppingProductUnitObject->product_id		= $request->getParam('product_id','post');
			$shoppingProductUnitObject->require_unit_id	= $request->getParam('require_unit_id','post');
			$shoppingProductUnitObject->unit_name		= $request->getParam('unit_name','post');
			$shoppingProductUnitObject->unit_kana		= $request->getParam('unit_kana','post');
			$shoppingProductUnitObject->unit_string		= $request->getParam('unit_string','post');

			$shoppingProductUnitObject->memberViewableArray		= $_POST['member_viewable'];
			$shoppingProductUnitObject->memberPurchasableArray	= $_POST['member_purchasable'];

			$shoppingProductUnitObject->keywords		= $request->getParam('keywords','post');
			$shoppingProductUnitObject->description		= $request->getParam('description','post');
			$shoppingProductUnitObject->detail_comment	= $request->getParam('detail_comment','post');
			$shoppingProductUnitObject->order_number	= $request->getParam('order_number','post');
			$shoppingProductUnitObject->price_standard	= $request->getParam('price_standard','post');
			$shoppingProductUnitObject->price_sell		= $request->getParam('price_sell','post');
			
			// オプション入力
			for( $n=1; $n<=5; $n++ ){
				$nName = 'option'.$n.'_name';
				$shoppingProductUnitObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_items';
				$shoppingProductUnitObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_explanation';
				$shoppingProductUnitObject->$nName	= $request->getParam($nName,'post');
				$nName = 'option'.$n.'_calculate';
				$shoppingProductUnitObject->$nName	= $request->getParam($nName,'post');
			}
			$shoppingProductUnitObject->max_at_once		= $request->getParam('max_at_once','post');
			$shoppingProductUnitObject->calendar_type	= $request->getParam('calendar_type','post');
			// 予約営業日制限
			$shoppingProductUnitObject->rsv_permit_start	= $request->getParam('rsv_permit_start','post');
			$shoppingProductUnitObject->rsv_permit_limit	= $request->getParam('rsv_permit_limit','post');
			// サービス開始標準時間: 現状宿泊予約のみで利用（チェックイン時間）	
			$shoppingProductUnitObject->default_start_time	= $request->getParam('default_start_time','post');
			// サービス提供期間: 秒数で入力。1時間なら3600
			$shoppingProductUnitObject->service_term		= $request->getParam('service_term','post');

			$shoppingProductUnitObject->dl_file_name		= $request->getParam('dl_file_name','post');
			$shoppingProductUnitObject->dl_response_headers	= $request->getParam('dl_response_headers','post');
			
			$shoppingProductUnitObject->flagIdArray		= array();
			$shoppingProductUnitObject->flagObjectHash	= array();

			$shoppingProductUnitObject->delivery_type			= $request->getParam('delivery_type','post');
			$shoppingProductUnitObject->delivery_weight			= $request->getParam('delivery_weight','post');
			$shoppingProductUnitObject->stock					= $request->getParam('stock','post');
			$shoppingProductUnitObject->stock_relation			= $request->getParam('stock_relation','post');
			$shoppingProductUnitObject->stock_relation_count	= $request->getParam('stock_relation_count','post');
			$shoppingProductUnitObject->stock_display			= $request->getParam('stock_display','post');
			$shoppingProductUnitObject->price_monthly			= $request->getParam('price_monthly','post');

			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインの場合のみ、販売単位IDをオブジェクトにセット
				if ( strlen(trim($unit_id)) > 0 ) {
					$shoppingProductUnitObject->unit_id		= $unit_id;
				}
				// 管理者権限の場合、POST値を設定
				$shoppingProductUnitObject->open_date		= $request->getParam('open_date','post');
				$shoppingProductUnitObject->close_date		= $request->getParam('close_date','post');
				$shoppingProductUnitObject->present_point	= $request->getParam('present_point','post');
				$shoppingProductUnitObject->cost			= $request->getParam('cost','post');
				$shoppingProductUnitObject->discount_exception		= $request->getParam('discount_exception','post');

				// 商品フラグ情報
				$flagObjectHash = array();
				$flagIdArray	= $_POST['flag_id'];
				if ( count($flagIdArray)>0 ) {
					foreach ( $flagIdArray as $flagId ) {
						if ( !is_array($flagObjectHash[$flagId]) ) {
							$flagObjectHash[$flagId] = array();
						}
						$flagObjectHash[$flagId]['flag_name']		= trim($_POST['flag_name'][$flagId]);
						$flagObjectHash[$flagId]['order_number']	= trim($_POST['flag_order_number'][$flagId]);
						$flagObjectHash[$flagId]['open_date_year']	= trim($_POST['open_date_year'][$flagId]);
						$flagObjectHash[$flagId]['open_date_month']	= trim($_POST['open_date_month'][$flagId]);
						$flagObjectHash[$flagId]['open_date_day']	= trim($_POST['open_date_day'][$flagId]);
						$flagObjectHash[$flagId]['close_date_year']	= trim($_POST['close_date_year'][$flagId]);
						$flagObjectHash[$flagId]['close_date_month']	= trim($_POST['close_date_month'][$flagId]);
						$flagObjectHash[$flagId]['close_date_day']	= trim($_POST['close_date_day'][$flagId]);
						if ( strlen($flagObjectHash[$flagId]['open_date_year'])>0
							&& strlen($flagObjectHash[$flagId]['open_date_month'])>0
							&& strlen($flagObjectHash[$flagId]['open_date_day'])>0
						) {
							$flagObjectHash[$flagId]['open_date']	= $flagObjectHash[$flagId]['open_date_year']
								.'-'.$flagObjectHash[$flagId]['open_date_month']
								.'-'.$flagObjectHash[$flagId]['open_date_day']
							;
						}
						if ( strlen($flagObjectHash[$flagId]['close_date_year'])>0
							&& strlen($flagObjectHash[$flagId]['close_date_month'])>0
							&& strlen($flagObjectHash[$flagId]['close_date_day'])>0
						) {
							$flagObjectHash[$flagId]['close_date']	= $flagObjectHash[$flagId]['close_date_year']
								.'-'.$flagObjectHash[$flagId]['close_date_month']
								.'-'.$flagObjectHash[$flagId]['close_date_day']
							;
						}
					}
				}
				$shoppingProductUnitObject->flagIdArray		= $flagIdArray;
				$shoppingProductUnitObject->flagObjectHash	= $flagObjectHash;
			} else {
				// 管理者ログイン以外は、販売単位IDの変更はできない
			}
			
			$shoppingProductUnitObject->convertKanaFields('KVas');
			
			// 入力値の妥当性検査を行う
			$shoppingProductUnitObject->validate( $request );
			
			// 削除ファイルの指示
			$delete_fileIdArray	= $_POST['delete_fileIdArray'];
			if( is_array( $delete_fileIdArray ) ) {
				$newFileIdArray	= array();
				foreach($shoppingProductUnitObject->fileIdArray as $key => $tFileId ) {
					if( !in_array($tFileId,$delete_fileIdArray) ) {
						// 削除対象にないなら追加
						$newFileIdArray[$key]	= $tFileId;
					}
				}
				$shoppingProductUnitObject->fileIdArray	= $newFileIdArray;
			}
			// ファイルアップロード
			if( !$request->isError() ) {
				$uploader	= new file_Uploader('unitfiles', 0, 10485760, array('jpg','gif','png','zip'));
				$shoppingProductUnitObject->uploader	= & $uploader;
				if( $uploader->isUploaded() ) {
					if( $uploader->validate( $request ) ) {
						if( $uploader->upload( $request ) ) {
							// 商品画像0～99のキー分のみ画像マックスサイズまでリサイズする
							foreach( $uploader->fileBinObjectHash as $fileNumber => $fileBinObject ) {
								if( $fileNumber < 100 ) {
									// 登録一時URI
									$regTmpAPath	= system_DataFileWriter::getRealAbsolutePath( $request, $fileBinObject->registTmpUri, DIR_NAME_TMP );
									$imageInfoHash	= getimagesize($regTmpAPath);
									if( $imageInfoHash !== false
										&& ( $imageInfoHash[0] > SHOPPING_PRODUCT_IMAGE_MAX_WIDTH || $imageInfoHash[1] > SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT ) ) {
										// 最大登録サイズより大きいならリサイズ
										$localTmpPath	= DIR_PATH_TMP.'/shopping';
										if( !file_exists($localTmpPath) ) {
											if( @mkdir($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
												@chmod($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER);
											}
										}
										$localTmpPath	.= '/product';
										if( !file_exists($localTmpPath) ) {
											if( @mkdir($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
												@chmod($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER);
											}
										}
										$localTmpPath	.= '/unit';
										if( !file_exists($localTmpPath) ) {
											if( @mkdir($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER) ) {
												@chmod($localTmpPath,SPIDER_PERMITTION_DATA_FOLDER);
											}
										}
										$localTmpPath	.= '/'.basename($fileBinObject->registTmpUri);
										if( util_File::resizeImage( $regTmpAPath, $localTmpPath, SHOPPING_PRODUCT_IMAGE_MAX_WIDTH, SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT ) ) {
											system_DataFileWriter::import( $request, $fileBinObject->registTmpUri, $localTmpPath, DIR_NAME_TMP );
										} else {
											$request->addLocaledError('shopping.error.dao.product.invalidrelatedid',SPIDER_LOG_LEVEL_ERROR,array($fileNumber+1));
										}
										@unlink($localTmpPath);
									}
								} else {
									$uploader->fileBinObjectHash[$fileNumber]->open_flag	= 1;
								}
							}
						}
					}
				}
			}
			if( '11' == $shoppingProductUnitObject->delivery_type && !isset($uploader->fileBinObjectHash[100]) ) {
				$request->addLocaledError('shopping.error.order.download.nofile',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingProductUnitObject);
		$request->setAttribute('shopping.product.unit.fileObjectOrgHash',		$fileObjectOrgHash);
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>