<?php
/*
 * shopping/product/Status.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_Status extends system_login_ModuleBase {
	
	function shopping_product_Status(){
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$productNumber			= $request->getParam('product_number','post');
		$statusFlag				= $request->getParam('status_flag','post');
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$productNumber) > 0 ) {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductObject, $productNumber, true ) ) {
				if( false === $this->lockData( $request, $shoppingProductObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if ( !$shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else if( strlen($GLOBALS['SHOPPING_PRODUCT_STATUS_HASH'][$statusFlag]) == 0 ) {
						$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						$shoppingProductObject->status_flag		= $statusFlag;
						$shoppingProductObject->updated_date	= date('Y-m-d H:i:s');
						if ( !$shoppingProductObject->canEditStatus( $request, $loginUserObject ) ) {
							$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
						} else if( $dbo->update($shoppingProductObject,false) ){
							// 商品の非公開・削除は紐づく販売単位と同期する
							if( $shoppingProductObject->status_flag < 100 || $shoppingProductObject->status_flag >= 200 ) {
								foreach( $shoppingProductObject->unitObjectArray as $unitObject ) {
									if( $unitObject->status_flag >= 100 && $unitObject->status_flag < 200 ) {
										$unitObject->status_flag	= $shoppingProductObject->status_flag;
										$unitObject->updated_date	= $shoppingProductObject->updated_date;
										if( $dbo->update($unitObject,false) ) {
										} else {
											$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
										}
									}
								}
							}
						} else {
							$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
					$this->unlockData( $request, $shoppingProductObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		$request->setAttribute('shopping.product.product_object',	$shoppingProductObject);
	}
}
?>