<?php
/*
 * shopping/order/step/Complete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'Optimize.class.php' );
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Execute.class.php' );
/**
 * shopping_order_step_Complete
 * @author m.nakashima
 */
class shopping_order_step_Complete extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_Complete() {
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadListExists');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$loginUserObject			= $this->getLoginUserObject( $request );
		// 利用可能な決済方法の読み込み
		$settleMethodObjectArray	= $request->getAttribute('shopping.order.settlement.methodExistsObjectArray');
		// 各決済方法からORDERオブジェクト読み込みを試み
		$shoppingOrderObject	= null;
		$settleMethodObject		= null;
		foreach( $settleMethodObjectArray as $settleMethodObject ) {
			if( $settleMethodObject->enable ) {
				$shoppingOrderObject	= $settleMethodObject->getCompleteShoppingObject( $request );
				if( is_a($shoppingOrderObject,'shopping_DaoShoppingOrder') ) {
					// 決済オブジェクトからORDER情報を読み込むことができたら
					break;
				} else {
					// 読み込みに失敗したら空にして次の決済プラグインから読み込み
					$shoppingOrderObject	= null;
				}
			}
		}
		if( !is_a($shoppingOrderObject,'shopping_DaoShoppingOrder') ) {
			// ORDERオブジェクトが正常に読み込みできていない場合
			$request->addLocaledError('shopping.error.order.invalidaccess',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else {
			// ORDERオブジェクトが読み込めている場合,管理者操作か確認
			if( $settleMethodObject->needCompleteView() ) {
				// Complete画面表示を必要する決済プラグインなら管理者登録か確認
				$sql	= 'SELECT COUNT(member_number) FROM '
				.TABLE_NAME_MEMBER.' WHERE member_id='.$dbo->quote($shoppingOrderObject->owner_id);
				$memberCount	= $dbo->queryOne($sql);
				if( $memberCount === false || $memberCount == 0 ) {
					// メンバーテーブルのレコードがオーナーでないなら管理者のORDERと判断して管理パネルのcompleteにリダイレクトして処理終了
					if( strpos(SPIDER_URI_APP,'/'.SYSTEM_DIR_NAME_ADMIN_PANEL) === 0 ) {
					} else if( $this->isLogin($request)
					&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
						$redirectUri	= '/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/shopping/order/order/complete.php?';
						foreach( $_GET as $k => $v ) {
							$redirectUri	.= urlencode($k).'='.urlencode($v).'&';
						}
						$request->redirectTo($redirectUri);
						return;
					}
				}
			}
			// 処理を継続
			if( $shoppingOrderObject->status_settle < 100 ) {
				// 決済状態が決済待ちの状態なら決済完了処理を実行
				if( $settleMethodObject->settlement( $request, $shoppingOrderObject ) ) {
					// 決済処理成功したら決済処理完了ステータスにする
					$shoppingOrderObject->status_flag	= $settleMethodObject->statusNomal;
					$shoppingOrderObject->status_settle	= $settleMethodObject->statusSettle;
					$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_ORDER
						.' SET status_flag='.$settleMethodObject->statusNomal
						.' ,status_settle='.$settleMethodObject->statusSettle
						.' WHERE order_id='.$dbo->quote($shoppingOrderObject->order_id);
					if( false === $dbo->query($sql) ) {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array($sql));
					}
				} else {
					// 決済処理失敗
					// 決済処理失敗ステータスにする
					$shoppingOrderObject->status_flag	= $settleMethodObject->statusError;
					$shoppingOrderObject->status_settle	= 201;
					$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_ORDER
						.' SET status_flag='.$settleMethodObject->statusError
						.' ,status_settle=201'
						.' WHERE order_id='.$dbo->quote($shoppingOrderObject->order_id);
					if( false === $dbo->query($sql) ) {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array($sql));
					}
					$request->addLocaledError('shopping.error.order.failtosettle',SPIDER_LOG_LEVEL_FATAL,array($sql));
				}
			} else {
				// 決済処理が済んでいるなら何もしないで終了する
				return;
			}
		}

		if( !$request->isError() ) {
			// 成果処理と在庫・ポイント処理を行う
			if( !$request->isError() ) {
				shopping_order_step_Execute::processComplete( $request, $shoppingOrderObject );
			}
			// 1.1.x互換
			shopping_order_Optimize::_setEnvironmentFor11x( $request, $shoppingOrderObject );
			// 決済でエラーが発生しなかったら通知メール送信
			if( !$request->isError() ) {
				// TODO: 更新の場合の処理を振り分ける
				shopping_order_step_Execute::sendCompleteMail( $request, $shoppingOrderObject );
			}
			// 元々会員状態がログインならログインオブジェクトを入れ替える
			if( $this->isLogin($request)
			&& SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
				$this->setLoginUserObject( $request, $shoppingOrderObject->memberObject );
			}
		}
		
		if( $settleMethodObject->needCompleteView() ) {
			// HTML表示が必要な場合
		} else {
			// HTML表示が必要ないAPIアクセスの場合はレスポンスは購入者に見せない為テキスト形式
			$body	= $body	= "OK";
			if( $request->isError() ) {
				$body	= "NG\n".implode("\n", $request->errors );
			}
			$request->setResponseHeader( 'Content-Type', 'text/plain;charset=UTF-8' );
			$request->setResponseBody( $body );
		}
	}
	/**
	 * モジュールの後処理を行います。
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function post_process( & $request ) {
		$shoppingOrderObject	= null;
		$request->setAttribute('shopping.order.orderObject',$shoppingOrderObject);
	}
}
?>