<?php
/*
 * shopping/order/option/type/Radio.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'DaoShoppingOrderOption.class.php');
class shopping_order_option_type_Radio extends shopping_DaoShoppingOrderOption {
	/**
	 * Constructor
	 */
	function shopping_order_option_type_Radio() {
	}
	/**
	 * 入力フォームを表示する抽象メソッド 
	 * @param $request spider_HttpRequestオブジェクトインスタンス参照
	 * @param $value 入力値
	 * @return strings 入力フォームHTML文字列
	 */
	function getInputForm( & $request, $value='', $background=null, $formNameNames=null, $formNameValue=null ) {
		$optionHash			= array();
		$this->options		= str_replace("\r\n","\n",$this->options);
		$this->options		= str_replace("\r","\n",$this->options);
		$this->prices		= str_replace("\r\n","\n",$this->prices);
		$this->prices		= str_replace("\r","\n",$this->prices);
		$this->costs		= str_replace("\r\n","\n",$this->costs);
		$this->costs		= str_replace("\r","\n",$this->costs);
		$optionStringsArray	= explode("\n",$this->options);
		$optionPriceArray	= explode("\n",$this->prices);
		$optionCostArray	= explode("\n",$this->costs);
		foreach( $optionStringsArray as $num => $optionStrings ) {
			$optionStrings	= trim($optionStrings);
			if( strlen($optionStrings) > 0 ) {
				$optionInfo	= array();
				$optionInfo['value']	= $optionStrings;
				$optionInfo['price']	= isset($optionPriceArray[$num]) ? trim($optionPriceArray[$num]) : 0;
				$optionInfo['cost']		= isset($optionCostArray[$num]) ? trim($optionCostArray[$num]) : 0;
				array_push( $optionHash, $optionInfo );
			}
		}

		$inputNameName	= 'option_names';
		if( !is_null($formNameNames) || strlen($formNameNames) > 0 ) {
			$inputNameName	= $formNameNames;
		}
		$inputNameValue	= 'option_values';
		if( !is_null($formNameValue) || strlen($formNameValue) > 0 ) {
			$inputNameValue	= $formNameValue;
		}
				$strings	= '<input type="hidden" name="'.$inputNameName.'['.$this->optionNumber.']" value="'.$this->optionName.'" />';
		foreach( $optionHash as $optionInfo ) {
			if( strlen($background) > 0 ) {
				$strings	.= '<span style="background-color:'.$background.';">';
			}
			$strings	.= '<input type="radio" name="'.$inputNameValue.'['.$this->optionNumber.']" value="'.htmlspecialchars($optionInfo['value']).'"';
			if( $value == $optionInfo['value'] ) {
				$strings	.= ' checked';
			}
			$strings	.= ' /> '.htmlspecialchars($optionInfo['value']);
			if( strlen($background) > 0 ) {
				$strings	.= '</span>';
			}
			$strings	.= '<br />';
		}

		return $strings;
	}
	/**
	 * 現在のオプション情報を取得して金額を再計算
	 * タイプにより実装をオーバーライドする
	 * 個数は予め設定してから呼び出してください
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function calculate( & $request, $renew=false ) {
		if( $renew ) {
			$this->option_price	= 0;
			$this->option_cost	= 0;
			if( strlen($this->option_value) > 0 ) {
				// オプションの料金を確認
				$this->options		= str_replace("\r\n","\n",$this->options);
				$this->options		= str_replace("\r","\n",$this->options);
				$optionStringsArray	= explode("\n",$this->options);
				$this->prices		= str_replace("\r\n","\n",$this->prices);
				$this->prices		= str_replace("\r","\n",$this->prices);
				$optionPriceArray	= explode("\n",$this->prices);
				$this->costs		= str_replace("\r\n","\n",$this->costs);
				$this->costs		= str_replace("\r","\n",$this->costs);
				$optionCostArray	= explode("\n",$this->costs);
				foreach( $optionStringsArray as $number => $optionStr ) {
					if( $this->option_value == $optionStr ) {
						// オプション値文字列が同じなら
						if( isset($optionPriceArray[$number])
						&& preg_match('/^(|[\\-\\+])[0-9]{1,6}$/',$optionPriceArray[$number]) > 0 ) {
							// オプション料金が設定されているなら加算
							$this->option_price	+= $optionPriceArray[$number];
						}
						if( isset($optionCostArray[$number])
						&& preg_match('/^(|[\\-\\+])[0-9]{1,6}$/',$optionCostArray[$number]) > 0 ) {
							// オプションコストが設定されているなら加算
							$this->option_cost	+= $optionCostArray[$number];
						}
					}
				}
			}
		}
	}
}
?>