<?php
/*
 * shopping/order/SaveAdminNote.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_SaveAdminNote extends system_login_ModuleBase {
	function shopping_order_SaveAdminNote() {
		array_push($this->require_module_array,'database2.Transaction');
	}
	function execute( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		$orderId		= $request->getParam('order_id','post');
		$adminNote		= $request->getParam('admin_note','post');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen($orderId) == 0 ) {
			$request->addLocaledError('shopping.error.order.required',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen($adminNote) == 0 ) {
		} else if( strlen($adminNote) > 4500 ) {
			$request->addLocaledError('shopping.error.cart.admin.memo.overlength',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
				$operationType	= 0;
				if( !$request->isError() ) {
					$operationType	= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
				}
				if( $operationType == 0 || $operationType == 2 ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					// 履歴テキストの追記
					$historyNote	= $shoppingOrderObject->admin_note."\n";
					// 読み込みができたら管理者メモカラムに適用
					$shoppingOrderObject->admin_note	= $adminNote;
					// 更新日と状態の変更
					$shoppingOrderObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update( $shoppingOrderObject ) ) {
						// 更新に成功したら履歴
						if(!$shoppingOrderObject->writeHistoryNote( $request, '管理メモ変更][変更前', $historyNote, '', $loginUserObject )){
							$request->addLocaledError('shopping.error.order.failtohistory',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			$request->setAttribute('shopping.order.shoppingOrderObject',	$shoppingOrderObject );
		}
	}
}
?>