<?php
/*
 * shopping/flag/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'content'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
class shopping_flag_Execute extends system_login_ModuleBase {
	
	function shopping_flag_Execute(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$shoppingProductFlagNumber	= stripslashes( $_GET['shpfn'] );
		$sessionObjectName			= 'shopping.flag.modify.object.'.$shoppingProductFlagNumber;
		$sessionConfirmName			= 'shopping.flag.modify.confirm.'.$shoppingProductFlagNumber;
		$shoppingProductFlagObject	= $request->getSession($sessionObjectName);
		$confirmResult				= $request->getSession($sessionConfirmName);
		$loginUserObject			= $this->getLoginUserObject( $request );
		
		if( 'OK' != $confirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( 'shopping_daoshoppingproductflag' != strtolower(get_class($shoppingProductFlagObject)) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$compareShoppingProductFlagObject	= spider_Controller::createObject('shopping_DaoShoppingProductFlag');
			if( $dbo->loadById( $compareShoppingProductFlagObject, $shoppingProductFlagObject->flag_id ) ) {
				if( $shoppingProductFlagObject->flag_number != $compareShoppingProductFlagObject->flag_number ) {
					if ( $compareShoppingProductFlagObject->status_flag<200 ) {
						$request->addLocaledError('shopping.error.flag.duplicated',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
			if( !$request->isError() ) {
				// ログインしている場合としていない場合の振り分け
				if( $this->isLogin( $request ) ) {
					// ログインしているなら編集ユーザーのユニークIDを設定
					$shoppingProductFlagObject->modifier_id	= $loginUserObject->getUniqueId();
				}
				if( strlen(trim($shoppingProductFlagObject->flag_number)) > 0 ) {
					// フラグ番号が設定済みなら更新
					$shoppingProductFlagObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update($shoppingProductFlagObject,true) ) {
						// ファイルアップロード完了処理
						if( is_object($shoppingProductFlagObject->contentUploader)
							&& 'content_uploader' == strtolower(get_class($shoppingProductFlagObject->contentUploader)) ) {
							$flagId		= $shoppingProductFlagObject->flag_id;
							$extension	= 'jpg';
							if( isset($shoppingProductFlagObject->contentUploader->contentFileObjectArray[0]) ) {
								$fileElms	= explode('.',$shoppingProductFlagObject->contentUploader->contentFileObjectArray[0]->fileName);
								$extension	= strtolower(array_pop($fileElms));
							}
							$shoppingProductFlagObject->contentUploader->uploadExecute( $request, array($flagId.'.'.$extension) );
						}
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array());
					}
				} else {
					// フラグ番号がないなら新規挿入
					$shoppingProductFlagObject->status_flag	= 101;
					$shoppingProductFlagObject->owner_id	= $loginUserObject->getUniqueId();
					$shoppingProductFlagObject->updated_date		= date('Y-m-d H:i:s');
					$shoppingProductFlagObject->registered_date	= date('Y-m-d H:i:s');
					if ( strlen(trim($shoppingProductFlagObject->flag_id)) == 0 ) {
						// フラグIDが未入力の場合、IDを自動生成する
						if( !$dbo->setNextId( $shoppingProductFlagObject, 'SHPFA{num:5}' ) ) {
							$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array());
						}
					}
					if( !$request->isError() ) {
						// エラーがなければ、インサート
						if( $dbo->insert($shoppingProductFlagObject) ){
							// ファイルアップロード完了処理
							if( is_object($shoppingProductFlagObject->contentUploader)
								&& 'content_uploader' == strtolower(get_class($shoppingProductFlagObject->contentUploader)) ) {
								$flagId		= $shoppingProductFlagObject->flag_id;
								$extension	= 'jpg';
								if( isset($shoppingProductFlagObject->contentUploader->contentFileObjectArray[0]) ) {
									$fileElms	= explode('.',$shoppingProductFlagObject->contentUploader->contentFileObjectArray[0]->fileName);
									$extension	= array_pop($fileElms);
								}
								$shoppingProductFlagObject->contentUploader->uploadExecute( $request, array($flagId.'.'.$extension) );
							}
						} else {
							$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array($shoppingProductFlagObject->error_sql));
						}
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('shopping.flag.flag_object',		$shoppingProductFlagObject);
	}
}
?>