<?php
/*
 * shopping/calendar/Add.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_calendar_DeleteTerm extends system_login_ModuleBase {
	
	function shopping_calendar_DeleteTerm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$startDate		= $request->getParam('start_date','post');
		$closeDate		= $request->getParam('close_date','post');
		$productId		= $request->getParam('product_id','post');
		$unitId				= $request->getParam('unit_id','post');
		// 妥当性検査
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( strlen($startDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.startdayrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDateFormat($startDate) ) {
			$request->addLocaledError('shopping.error.calendar.startdayoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($closeDate) == 0 ) {
			$request->addLocaledError('shopping.error.calendar.enddayrequired',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( !util_ValidateFunctions::isAvailableDateFormat($closeDate) ) {
			$request->addLocaledError('shopping.error.calendar.enddayoutofrange',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($productId) > 0 ) {
			// 商品指定があるなら存在チェック
			if( strlen($productId) > 16 ) {
				$request->addLocaledError('shopping.error.product.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById($shoppingProductObject,$productId) ) {
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		}
		if( strlen($unitId) > 0 ) {
			// 販売単位指定があるなら存在チェック
			if( strlen($unitId) > 16 ) {
				$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_ERROR,array());
			} else {
				$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
				if( $dbo->loadById($shoppingProductUnitObject,$unitId) ) {
				} else {
					$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		} else {
			$priceSell	= null;
		}
		// 問題ないなら指定期間のスケジュールを全て削除
		if( $request->isError() ) {
		} else {
			$sql	= '';
			if( strlen($unitId) > 0 ){
				$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_CALENDAR.' WHERE unit_id='.$dbo->quote($unitId)
				.' AND start_date>='.$dbo->quote($startDate.' 00:00:00').' AND close_date<='.$dbo->quote($closeDate.' 23:59:59');
			} else if( strlen($productId) > 0 ){
				$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_CALENDAR.' WHERE product_id='.$dbo->quote($productId)
				.' AND ( unit_id IS NULL OR unit_id=\'\' )'
				.' AND start_date>='.$dbo->quote($startDate.' 00:00:00').' AND close_date<='.$dbo->quote($closeDate.' 23:59:59');
			} else {
				$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_CALENDAR.' WHERE ( product_id IS NULL OR product_id=\'\' )'
				.' AND ( unit_id IS NULL OR unit_id=\'\' )'
				.' AND start_date>='.$dbo->quote($startDate.' 00:00:00').' AND close_date<='.$dbo->quote($closeDate.' 23:59:59');
			}
			if( strlen($sql) > 0 ){
				if( $dbo->query($sql) ) {
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array($sql));
				}
			}
		}
		$request->setAttribute('shopping.calendar.startDate', $startDate);
		$request->setAttribute('shopping.calendar.closeDate', $closeDate);
		$request->setAttribute('shopping.calendar.productId', $productId);
		$request->setAttribute('shopping.calendar.unitId', $unitId);
		$request->setAttribute('shopping.calendar.priceSell', $priceSell);
	}
}
?>