<?php
/*
 * shopping/order/modify/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingProduct.class.php' );
class shopping_bookmark_Delete extends system_login_ModuleBase {
	function shopping_bookmark_Delete() {
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$productNumber			= stripslashes( $_GET['shpdn'] );
		$productId				= stripslashes($_GET['shpdi']);
		$loginUserObject		= $this->getLoginUserObject( $request );
		
		$productObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		if( preg_match('/^[0-9]+$/',$productNumber) > 0 ) {
			// 商品番号が指定されているなら読み込み
			if( $dbo->loadByNumber( $productObject, $productNumber, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else if( strlen(trim($productId)) > 0 ) {
			// 商品IDが指定されているなら読み込み
			if( $dbo->loadById( $productObject, $productId, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('shopping.error.bookmark.productrequired',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		if( !$request->isError() ) {
			// 関連テーブルから該当商品IDを削除
			$sql = 'DELETE FROM '.TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK
				.' WHERE '.TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK.'.product_id='.$dbo->quote($productObject->product_id)
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK.'.member_id='.$dbo->quote($loginUserObject->member_id)
			;
			$result = $dbo->query( $sql );
			if( false === $result ) {
				$request->addLocaledError('shopping.error.bookmark.failtodelete',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		if( $request->isError() ) {
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else {
				$isReferer	= false;
				if( strpos(trim($_POST['referer']),SPIDER_URL_BASE) === 0 ) {
					$isReferer = true;
				} else if( strpos(trim($_POST['referer']),SPIDER_ACCESS_URL_HTTP) === 0 ) {
					$isReferer = true;
				} else if( strpos(trim($_POST['referer']),SPIDER_ACCESS_URL_SSL) === 0 ) {
					$isReferer = true;
				} else {
					foreach( $GLOBALS['REV_PROXY_HASH'] as $key => $hash ) {
						$urlstr	= $hash['protocol'].'://'.$key.$hash['uri'];
						if( strpos(trim($_POST['referer']),$urlstr) === 0 ) {
							$isReferer	= true;
							break;
						}
					}
				}
				if( $isReferer ) {
					$request->redirectTo(trim($_POST['referer']));
				}
			}
		}
	}
}
?>