<?php
/**
 * 検索パッケージに関連した会員検索条件を付加する接続オブジェクトクラス
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'Connector.class.php');
class shopping_MemberConnector extends member_Connector {
	var $memberClassHash	= array();
	function shopping_MemberConnector() {
		$this->memberClassHash	= array(
			'51'	=> 'アフィリエイト会員',
			'52'	=> '特別割引会員',
			'53'	=> '商品販売会員',
		);
	}
	/**
	 * 会員検索条件のWHEREに追加する条件文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getWhereConditionStrings( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$orderId	= trim($request->getParam('mshpoid','get'));
		if( strlen($orderId) > 0 ) {
			$sql	= TABLE_NAME_MEMBER.'.member_id IN ('
				.' SELECT DISTINCT '.TABLE_NAME_SHOPPING_ORDER.'.member_id'
				.' FROM '.TABLE_NAME_SHOPPING_ORDER
				.' WHERE '
				.TABLE_NAME_SHOPPING_ORDER.'.status_flag<200'
				.' AND '
				.TABLE_NAME_SHOPPING_ORDER.'.order_id LIKE '.$dbo->quote('%'.$orderId.'%')
				.' )'
			;
			return $sql;
		}
		return '';
	}
	/**
	 * 会員検索フォームに表示する入力フォーム文字列を取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 */
	function getSearchFormStrings( & $request ) {
		$orderId	= trim($request->getParam('mshpoid','get'));
		$str		= $GLOBALS['SHOPPING_LABEL_ORDER']
		.'ID: <input type="text" name="mshpoid" size="20" value="'.htmlspecialchars($orderId).'" />';
		return $str;
	}
	/**
	 * パッケージで扱う追加会員種別があればハッシュで取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @return array 会員種別番号=>会員種別名称のハッシュ
	 */
	function getAdditionalMemberClassHash( & $request ) {
		$returnHash	= array();
		if( isset($GLOBALS['SHOPPING_MEMBER_CLASSES'])
		&& is_array($GLOBALS['SHOPPING_MEMBER_CLASSES']) ) {
			foreach( $this->memberClassHash as $key => $val ) {
				if( in_array($key,$GLOBALS['SHOPPING_MEMBER_CLASSES']) ) {
					$returnHash[$key]	= $val;
				}
			}
		}
    	return $returnHash;
	}
	/**
	 * パッケージで扱う追加会員種別のうちで会員自ら登録できる会員種別を返します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @return array 会員種別番号=>会員種別名称のハッシュ
	 */
	function getPublicMemberClassHash( & $request ) {
		$returnHash	= array();
		if( isset($GLOBALS['SHOPPING_MEMBER_CLASSES_REGISTABLE'])
		&& is_array($GLOBALS['SHOPPING_MEMBER_CLASSES_REGISTABLE']) ) {
			foreach( $this->memberClassHash as $key => $val ) {
				if( in_array($key,$GLOBALS['SHOPPING_MEMBER_CLASSES_REGISTABLE']) ) {
					$returnHash[$key]	= $val;
				}
			}
		}
    	return $returnHash;
	}
	/**
	 * 会員登録した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostInsertProcess( & $request, & $memberObject ) {
		$dbo	= $request->getAttribute('dbo');
		if( $memberObject->status_flag < 200 ) {
			if( array_key_exists($memberObject->member_class,$this->memberClassHash) ) {
				// プロモーション情報を登録
				$this->_insertMemberPromotion( $request, $memberObject );
			}
		}
	}
	/**
	 * 会員情報更新した際の追加自動処理があれば記述します
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 */
	function additionalPostUpdateProcess( & $request, & $memberObject ) {
		$dbo	= $request->getAttribute('dbo');
		if( $memberObject->status_flag >= 100 && $memberObject->status_flag < 200 ) {
			if( array_key_exists($memberObject->member_class_org,$this->memberClassHash) ) {
				// 元がショッピング特別会員だった場合
				if( !array_key_exists($memberObject->member_class,$this->memberClassHash) ) {
					// ショッピング特別会員でなくなる場合：報酬の都合上要検討だが当面管理者しか操作できないのでプロモーション情報を全て削除状態にする
					$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_PROMOTION.' SET status_flag=241 WHERE member_id='.$dbo->quote($memberObject->member_id);
					$dbo->query($sql);
				}
			} else {
				// 元がプロモーション会員ではなかった場合
				$sql	= 'SELECT COUNT(promotion_number) FROM '.TABLE_NAME_SHOPPING_PROMOTION
				.' WHERE member_id='.$dbo->quote($memberObject->member_id)
				.' AND status_flag<200';
				$c	= $dbo->queryOne($sql);
				if( $c === false ) {
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
				} else if( $c == 0 ) {
					// プロモーション情報を登録
					$this->_insertMemberPromotion( $request, $memberObject );
				}
			}
		} else if( $memberObject->status_flag < 100 ){
			// 会員が有効でなくなった場合
			$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_PROMOTION.' SET status_flag=90 WHERE member_id='.$dbo->quote($memberObject->member_id);
			$dbo->query($sql);
		} else {
			// 会員が削除済みになった場合
			$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_PROMOTION.' SET status_flag=241 WHERE member_id='.$dbo->quote($memberObject->member_id);
			$dbo->query($sql);
		}
	}
	
	/**
	 * アフィリエイト会員用プロモーション情報を生成します
	 */
	function _insertMemberPromotion( & $request, & $memberObject ) {
		$dbo	= $request->getAttribute('dbo');
		$shoppingPromotionObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
		$shoppingPromotionObject->member_id			= $memberObject->member_id;
		$shoppingPromotionObject->promotion_rank	= '50';
		$shoppingPromotionObject->promotion_name	= $memberObject->view_name;
		$shoppingPromotionObject->status_flag		= 101;
		$shoppingPromotionObject->updated_date		= date('Y-m-d H:i:s');
		$shoppingPromotionObject->registered_date	= date('Y-m-d H:i:s');
		$shoppingPromotionObject->owner_id			= $memberObject->owner_id;
		$shoppingPromotionObject->modifier_id		= $memberObject->modifier_id;
		if( defined('SHOPPING_AFFILIATE_DISCOUNT_TYPE') ) {
			$shoppingPromotionObject->discount_type	= SHOPPING_AFFILIATE_DISCOUNT_TYPE;
		} else {
			$shoppingPromotionObject->discount_type	= '';
		}
		if( defined('SHOPPING_AFFILIATE_DISCOUNT_VALUE') ) {
			$shoppingPromotionObject->discount_value	= SHOPPING_AFFILIATE_DISCOUNT_VALUE;
		} else {
			$shoppingPromotionObject->discount_value	= 0;
		}
		if( defined('SHOPPING_AFFILIATE_PAY_TYPE') ) {
			$shoppingPromotionObject->pay_type	= SHOPPING_AFFILIATE_PAY_TYPE;
		} else {
			$shoppingPromotionObject->pay_type	= 'rate';
		}
		if( defined('SHOPPING_AFFILIATE_PAY_VALUE') ) {
			$shoppingPromotionObject->pay_value	= SHOPPING_AFFILIATE_PAY_VALUE;
		} else {
			$shoppingPromotionObject->pay_value	= 2;
		}
		if( $memberObject->member_class == '52' ) {
			$shoppingPromotionObject->promotion_rank	= '90';
			if( defined('SHOPPING_AFFILIATE_BUYING_FLAG') ) {
				$shoppingPromotionObject->buying_flag	= SHOPPING_AFFILIATE_BUYING_FLAG;
			} else {
				$shoppingPromotionObject->buying_flag	= '0';
			}
			if( defined('SHOPPING_AFFILIATE_BUYING_RATE') ) {
				$shoppingPromotionObject->buying_rate	= SHOPPING_AFFILIATE_BUYING_RATE;
			} else {
				$shoppingPromotionObject->buying_rate	= 0;
			}
		} else {
			$shoppingPromotionObject->buying_flag	= 0;
			$shoppingPromotionObject->buying_rate	= 0;
		}
		if( !$dbo->setNextId( $shoppingPromotionObject, 'SPMBPA{num:6}' ) ) {
			$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			$shoppingPromotionObject->promotion_code	= $shoppingPromotionObject->promotion_id
			.util_CharUtility::get_rundom_large_char(4);
			if( $dbo->insert($shoppingPromotionObject) ){
			} else {
				$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
	}
	/**
	 * 個人情報一覧の個々のデータに追加するリンクを取得
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberObject member_DaoMemberオブジェクト参照
	 * @return string リンクタグ文字列の配列
	 */
	function getMemberLinkArray( & $request, & $memberObject ) {
		return array(
			'<a href="/'.SYSTEM_DIR_NAME_ADMIN_PANEL.'/shopping/order/?shpmi='.$memberObject->member_id.'">'
			.$GLOBALS['SHOPPING_LABEL_ORDER'].'履歴</a>'
		);
	}
	//
	// メール関連処理
	//
	/**
	 * メール送信時の本文に関連した入力チェックをおこないます
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberMailObject メールオブジェクト参照
	 */
	function mailConfirm( & $request, & $memberMailObject ) {
		
	}
	/**
	 * メール送信直前にメールオブジェクトに対する処理をおこないます
	 * @param $requst spider_HttpRequstオブジェクト参照
	 * @param $memberMailObject メールオブジェクト参照
	 */
	function mailPreSend( & $request, & $memberMailObject ) {
	}
}
?>