<?php
/*
 * member/member/bank/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Hiroki Koga
 * Last Update: 2010-09-14
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 編集フォーム表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_bank_Form extends system_login_ModuleBase {
	function member_member_bank_Form() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.member.Load' );
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$accountId				= stripslashes( $_GET['aci'] );
		$sessionObjectName		= 'member.member.bank.modify.object.'.$accountId;
		$sessionConfirmName		= 'member.member.bank.modify.confirm.'.$accountId;
		$bankAccoutObject			= $request->getSession($sessionObjectName);
		$compareBankAccoutObject	= spider_Controller::createObject('member_DaoMemberBankAccount');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( get_class($compareBankAccoutObject) == get_class($bankAccoutObject) ){
			// セッションに登録済みならそのまま利用する
		} else {
			// セッションにないなら作成する
			$bankAccoutObject	= spider_Controller::createObject('member_DaoMemberBankAccount');
			if( strlen(trim($accountId)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadById( $bankAccoutObject, $accountId ) ){
					// 読み込めたら編集可能か確認
					if( $bankAccoutObject->canEditData( $request, $loginUserObject ) ) {
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('member.error.bank.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else if( strlen(trim($memberId)) > 0 ) {
				// 会員IDが指定されているなら、SQLから読み込み
				$sql = ' SELECT * '
					.' FROM '.TABLE_NAME_MEMBER_BANK_ACCOUNT
					.' WHERE '.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.member_id='.$dbo->quote($memberId)
					.' ORDER BY '.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.order_number'
				;
				$obj	= spider_Controller::createObject('member_DaoMemberBankAccount');
				$rows	= $dbo->queryAll( $sql, $obj, false );
				if ( $rows === false ) {
				} else if ( count($rows)==0 ) {
				} else {
					// 1件目を設定
					$bankAccoutObject = $rows[0];
					// 読み込めたら編集可能か確認
					if( $bankAccoutObject->canEditData( $request, $loginUserObject ) ) {
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			} else {
				// IDが指定されていないなら新規作成
			}
		}
		
		$request->setAttribute('member.member.bank.memberBankAccoutObject',$bankAccoutObject);
		
	}
}
?>