<?php
/*
 * member/member/bank/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Hiroki Koga
 * Last Update: 2010-09-14
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント入力確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_bank_Confirm extends system_login_ModuleBase {
	function member_member_bank_Confirm() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.member.Load' );
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$accountId				= stripslashes( $_GET['aci'] );
		$sessionObjectName		= 'member.member.bank.modify.object.'.$accountId;
		$sessionConfirmName		= 'member.member.bank.modify.confirm.'.$accountId;
		$bankAccountObject		= spider_Controller::createObject('member_DaoMemberBankAccount');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);

		if( strlen(trim($accountId)) > 0 ) {
			// ログインIDが指定されているなら編集の為読み込み
			if( $dbo ->loadById( $bankAccountObject, $accountId ) ) {
				// 読み込めたら編集可能か確認
				if( $bankAccountObject->canEditData( $request, $loginUserObject ) ) {
				} else {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.bank.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		}

		// 入力値のセットとチェック
		if( !$request->isError() ) {
			$bankAccountObject->member_id		= $memberId;
			$bankAccountObject->bank_code		= trim(stripslashes($_POST['bank_code']));
			$bankAccountObject->bank_name		= trim(stripslashes($_POST['bank_name']));
			$bankAccountObject->bank_kana		= trim(stripslashes($_POST['bank_kana']));
			$bankAccountObject->bank_branch_code	= trim(stripslashes($_POST['bank_branch_code']));
			$bankAccountObject->bank_branch_name	= trim(stripslashes($_POST['bank_branch_name']));
			$bankAccountObject->bank_branch_kana	= trim(stripslashes($_POST['bank_branch_kana']));
			$bankAccountObject->bank_account_type	= trim(stripslashes($_POST['bank_account_type']));
			$bankAccountObject->bank_account_code	= trim(stripslashes($_POST['bank_account_code']));
			$bankAccountObject->bank_account_name	= trim(stripslashes($_POST['bank_account_name']));
			$bankAccountObject->bank_account_kana	= trim(stripslashes($_POST['bank_account_kana']));
			$bankAccountObject->validate( $request );
		}
		
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		
		$request->setSession($sessionObjectName,$bankAccountObject);
		$request->setAttribute('member.member.bank.memberBankAccoutObject',$bankAccountObject);
		
	}
}
?>