<?php
/*
 * member/mail/template/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール テンプレート一覧取得用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage template テンプレートパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_template_LoadList extends system_login_ModuleBase {
	function member_mail_template_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$loginUserObject		= $this->getLoginUserObject( $request );
		$order_condition	= ' ORDER BY template_name ASC';
		$condition_string	= '';
		$condition_array	= array();
		// 状態フラグ
		$str	= 'status_flag<200';
		array_push( $condition_array, $str );
		// 公開フラグ グループは未実装
		if( $loginUserObject->getUniqueId() != 'SYSADMIN' ) {
			$str	= '( open_flag=0 OR ( open_flag=20 AND owner_id='.$dbo->quote($loginUserObject->getUniqueId()).') )';
			array_push( $condition_array, $str );
		}
		// 条件を結合
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		// データを取得
		$mailTemplateObjectArray	= array();
		$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER_MAIL_TEMPLATE
		.$condition_string.$order_condition;
		$mailTemplateObject	= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$result	= $dbo->queryAll( $sql, $mailTemplateObject, true );
		if ( $result === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach( $result as $mailTemplateObject ) {
				$this->setLockStatus( $request, $mailTemplateObject );
				array_push( $mailTemplateObjectArray, $mailTemplateObject );
			}
		}
		$request->setAttribute( 'member.mail.template.data_array', $mailTemplateObjectArray );
	}
}
?>