<?php
/*
 * member/mail/template/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール テンプレート削除用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage template テンプレートパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_template_Delete extends system_login_ModuleBase {
	function member_mail_template_Delete(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo								= $request->getAttribute( 'dbo' );
		$template_id				= stripslashes( $_POST['template_id'] );
		$mailTemplateObject	= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( strlen(trim($template_id)) > 0 ) {
			// IDが指定されているなら編集のため読み込み
			if( $dbo->loadById( $mailTemplateObject, $template_id ) ){
				if( $loginUserObject->getUniqueId() != 'SYSADMIN'
					&& $mailTemplateObject->open_flag != 0
					&& $mailTemplateObject->owner_id != $loginUserObject->getUniqueId() ) {
					// 公開フラグが共有になっていない場合は所有者でなければエラー
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else if( preg_match('/^MMTP/',$mailTemplateObject->template_id) == 0 ) {
					// システムテンプレートは削除できない
					$request->addLocaledError('member.error.mail.template.nodelete',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else if( $this->lockData( $request, $mailTemplateObject ) ) {
					// IDが存在するなら削除処理
					$mailTemplateObject->status_flag	= 255;
					$mailTemplateObject->updated_date	= date('Y-m-d H:i:s');
					$mailTemplateObject->modifier_id	= $loginUserObject->getUniqueId();
					if( $dbo->update( $mailTemplateObject, true ) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
					}
					// エラー有無に関わらずロックを解除
					$this->unlockData( $request, $mailTemplateObject );
				} else {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
		}

		$request->setAttribute('member.mail.template.mail_template_object',$mailTemplateObject);

	}
}
?>