<?php
/*
 * member/mail/reject/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoMemberMailReject.class.php' );
/**
 * spider : メンバーメール 配信メールマガジン種別作成確認用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_Confirm extends system_login_ModuleBase {
	function member_mail_reject_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$reject_list_id				= stripslashes( $_GET['rli'] );
		$sessionObjectName		= 'member.mail.reject.modify.object.'.$reject_list_id;
		$sessionConfirmName		= 'member.mail.reject.modify.confirm.'.$reject_list_id;
		$loginUserObject			= $this->getLoginUserObject( $request );
		$rejectListObject			= spider_Controller::createObject('member_DaoMemberMailReject');
		$compare_reject_list		= spider_Controller::createObject('member_DaoMemberMailReject');
		
		if( strlen(trim($reject_list_id)) > 0 ) {
			// IDが指定されているなら編集の為読み込み
			if( $dbo->loadById( $rejectListObject, $reject_list_id ) ) {
				// ロックを取得できるか確認
				$this->lockData( $request, $rejectListObject );
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		}
		// 入力値のセットとチェック
		$rejectListObject->list_name		= trim(stripslashes($_POST['list_name']));
		$rejectListObject->description	= trim(stripslashes($_POST['description']));
		if( strlen($rejectListObject->list_name) == 0 ) {
			$request->addLocaledError('member.error.dao.magazine.requirename',SPIDER_LOG_LEVEL_FATAL,array());
		} else if( strlen($rejectListObject->list_name) > 180 ) {
			$request->addLocaledError('member.error.dao.magazine.invalidname',SPIDER_LOG_LEVEL_FATAL,array());
		}
		if( strlen($rejectListObject->description) > 180 ) {
			$request->addLocaledError('member.error.dao.magazine.invaliddescription',SPIDER_LOG_LEVEL_FATAL,array());
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$resultString	= 'OK';
			$request->setSession($sessionConfirmName,$resultString);
		}
		$request->setSession($sessionObjectName,$rejectListObject);
		$request->setAttribute('member.mail.reject.reject_list_object',$rejectListObject);

	}
}
?>