<?php include_once( "../../../../spider.inc.php" ); ?>
{template:admin_default.tpl}
{module:system.login.Require}
{module:system.package.LoadList}
{module:system.package.install.Confirm}
{preset:page_title 'システム設定 >パッケージ管理 > インストール確認'}

	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		&gt; <a href="../../">システム設定</a>
		&gt; <a href="../">パッケージ管理</a>
		{if:is_object(system.package.install.target_package_object)}
		&gt; {if:system.package.install.target_package_object->isInstall()}設定変更{else}インストール{/if}確認
		{/if}
	</div>
	<h1>
		システム設定 &gt;
		パッケージ管理 &gt;
		パッケージ
		{if:is_object(system.package.install.target_package_object)}
		{if:system.package.install.target_package_object->isInstall()}設定変更{else}インストール{/if}確認
		{/if}
	</h1>
	
	{if:IS_ERROR}
		<ul class="error">
		{foreach:errors num error}
			<li>{write:error}</li>
		{/foreach}
		</ul>
		<p>
			<input type="button" value="入力画面に戻る" onclick="window.history.back()" />
		</p>
	{else-if:!is_object(system.package.install.target_package_object)}
		<p>パッケージ情報を正常に読み込めませんでした。</p>
		<p>
			<input type="button" value="入力画面に戻る" onclick="window.history.back()" />
		</p>
	{else}
	<div id="install-panel">
	<form action="" method="post">
	<input type="hidden" name="system_install_package_id" value="{write:system.package.install.target_package_object->getPackageId()}" />
		<p>
			内容に間違いなければ{if:system.package.install.target_package_object->isInstall()}設定変更{else}インストール開始{/if}ボタンをクリックしてください。
		</p>
		{if:count(system.package.install.require_package_object_array)>0}
		<p>未インストールの依存パッケージが見つかりました。<br />依存パッケージも同時にインストールします。</p>
		<p>{write:count(system.package.install.require_package_object_array)}件の依存パッケージ: 
			{foreach:system.package.install.require_package_object_array packageObject}
				&nbsp;{write:packageObject->getPackageViewName()}
			{/foreach}
		</p>
		{/if}
		{foreach:system.package.install.install_object_hash packageObject}
		<div id="package-{write:packageObject->getPackageId()}-form" style="margin-bottom:1em;"></div>
		{/foreach}
		<p id="execute-button-panel" style="text-align:center;">
			<input type="button" value="入力画面に戻る"
				onclick="window.location.href='./form.php?sitpi={write:urlencode(system.package.install.target_package_object->getPackageId())}';"
				style="font-size:16px;padding:6px;" />
			<input type="button" value="{if:system.package.install.target_package_object->isInstall()}設定変更{else}インストール開始{/if}"
				onclick="system_package_installRequest()"
				style="font-size:16px;padding:6px;" />
		</p>
		</form>
		<p>
			<a href="../index.php">パッケージ一覧に戻る</a>
		</p>
	</div>
	<div id="back-button-panel" style="display:none;visibility:hidden;">
		<p style="text-align:center;">
			パッケージの
			{if:system.package.install.target_package_object->isInstall()}
				設定変更が完了しました。
			{else}
				インストールが完了しました。
			{/if}<br />
			パッケージ一覧に戻るボタンをクリックしてパッケージ一覧に戻ってください。
			<br />
			<br />
			<input type="button" value="パッケージ一覧に戻る"
				onclick="window.location.href='../';"
				style="font-size:16px;padding:6px;" />
		</p>
	</div>

<script language="JavaScript" type="text/javascript"><!--
/**
 * インストールするパッケージの設定フォーム読み込み関連
 */
var systemPackageInstallHttpObject;
var systemPackageInstallPackageIdArray;
var systemPackageInstallPackageCount	= 0;
var systemPackageInstallExecPackageIdArray;
function systemPackageInstallGetInputForm( packageId ) {
	var targetUrl	= '../../../' + packageId + '/configuration/confirm.php?sitpi={write:get.sitpi}';
	systemPackageInstallHttpObject	= FormerCommon.createHttpRequest(systemPackageInstallGetInputFormResult);
	if( systemPackageInstallHttpObject ) {
		systemPackageInstallHttpObject.packageId	= packageId;
		systemPackageInstallHttpObject.open("GET",targetUrl,true);
		systemPackageInstallHttpObject.send(null);
	} else {
		alert('サーバー通信を開始できません!');
	}
}
function systemPackageInstallGetInputFormResult() {
	if ((systemPackageInstallHttpObject.readyState == 4) && (systemPackageInstallHttpObject.status == 200)){
		var targetDivId	= 'package-' + systemPackageInstallHttpObject.packageId + '-form';
		var resultPanel	= document.getElementById(targetDivId);
		if( resultPanel ) {
			resultPanel.innerHTML	= systemPackageInstallHttpObject.responseText;
		} else {
			alert('システムエラー');
		}
		if( systemPackageInstallPackageIdArray && systemPackageInstallPackageIdArray.length > 0 ) {
			var nextPackageId	= systemPackageInstallPackageIdArray.shift();
			systemPackageInstallGetInputForm( nextPackageId );
		} else {
			setTimeout(FormerCommon.displayWhiteIn, 100);
		}
	} else if ((systemPackageInstallHttpObject.readyState == 4) && (systemPackageInstallHttpObject.status != 200)){
		alert(systemPackageInstallHttpObject.packageId + 'パッケージの設定フォーム読み込み時にサーバー通信でエラーが発生しました。');
		if( systemPackageInstallPackageIdArray && systemPackageInstallPackageIdArray.length > 0 ) {
			var nextPackageId	= systemPackageInstallPackageIdArray.shift();
			systemPackageInstallGetInputForm( nextPackageId );
		} else {
			setTimeout(FormerCommon.displayWhiteIn, 100);
		}
	} else {
	}
}
/**
 * インストール実行
 */
function system_package_installRequest() {
	systemPackageInstallHttpObject	= FormerCommon.createHttpRequest(system_package_installRequestResult);
	if( systemPackageInstallHttpObject ) {
		// 実行ボタンを消す
		var buttonPanel	= document.getElementById('execute-button-panel');
		if( buttonPanel ) { buttonPanel.innerHTML = ''; }
		// パッケージを順にインストール・更新
		var packageId	= systemPackageInstallExecPackageIdArray.shift();
		var installedCount	= systemPackageInstallPackageCount - systemPackageInstallExecPackageIdArray.length;
		var url	= './execute.php';
		systemPackageInstallHttpObject.open("GET",url,true);
		FormerCommon.displayGrayOut(9999);
		// スクロールをトップに移動
		window.scrollTo(0,0);
		FormerCommon.displayGrayoutMessage(installedCount + '/' + systemPackageInstallPackageCount + 'パッケージをインストール中<br />'
			+ packageId + 'パッケージをインストールしています...');
		systemPackageInstallHttpObject.send(null);
		
	} else {
		alert('サーバー通信を開始できません!');
	}
}
function system_package_installRequestResult() {
	if ((systemPackageInstallHttpObject.readyState == 4) && (systemPackageInstallHttpObject.status == 200)){
		var resultText	= systemPackageInstallHttpObject.responseText;
	    var lines		= resultText.cr2lf().split(LF);
	    var result		= lines.shift();
		if( result == 'OK' ) {
			// エラーがないなら次のリクエスト
			var totalCount	= parseInt(lines.shift());
			var remainCount	= parseInt(lines.shift());
			var installedCount	= totalCount - remainCount;
			if( remainCount == 0 ) {
				// 残り数がない場合は終了
				FormerCommon.displayGrayoutMessage(installedCount + ' / ' + String(totalCount) + 'パッケージをインストールしました。');
				var installPanel	= document.getElementById('install-panel');
				var backBtnPanel	= document.getElementById('back-button-panel');
				if( installPanel ) {
					installPanel.style.display	= 'none';
					installPanel.style.visibility	= 'hidden';
					installPanel.style.position		= 'absolute';
					installPanel.style.top			= '0px';
					installPanel.style.left			= '0px';
				}
				if( backBtnPanel ) {
					backBtnPanel.style.display	= 'block';
					backBtnPanel.style.visibility	= 'visible';
				}
				setTimeout(FormerCommon.displayWhiteIn, 3000);
			} else {
				system_package_installRequest();
			}
		} else {
			// エラーなら結果をそのまま表示して終了
			setTimeout(FormerCommon.displayWhiteIn, 3000);
			alert(resultText);
		}
	} else if ((systemPackageInstallHttpObject.readyState == 4) && (systemPackageInstallHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 3000);
		alert('サーバー通信でエラーが発生しました。');
	} else {
	}
}
/**
 * ページ初期化
 */
function systemPackageInstallInit() {
	systemPackageInstallPackageIdArray		= new Array();
	systemPackageInstallExecPackageIdArray	= new Array();
	{foreach:system.package.install.install_object_hash packageObject}
	systemPackageInstallPackageIdArray.push('{write:packageObject->getPackageId()}');
	systemPackageInstallExecPackageIdArray.push('{write:packageObject->getPackageId()}');
	{/foreach}
	if( systemPackageInstallPackageIdArray.length > 0 ) {
		var firstPackageId	= systemPackageInstallPackageIdArray.shift();
		systemPackageInstallGetInputForm( firstPackageId );
		systemPackageInstallPackageCount	= systemPackageInstallPackageIdArray.length;
		FormerCommon.displayGrayOut(9999);
	}
}
if(window.attachEvent){
	window.attachEvent('onload',systemPackageInstallInit);
}else{
	window.addEventListener('DOMContentLoaded',systemPackageInstallInit,false);
}
//--></script>
		
	{/if}
<style type="text/css">
#install-panel table {
	border-collapse: collapse;
	border : solid 1px #808080;
}
#install-panel table thead tr th {
	border : solid 1px #808080;
	background-color : #c0c0c0;
	color : #606060;
	vertical-align: top;
	padding: 2px;
}
#install-panel table tbody tr th {
	border : solid 1px #808080;
	background-color : #c0c0c0;
	color : #606060;
	vertical-align: top;
	padding: 2px;
}
#install-panel table tbody tr td {
	border : solid 1px #808080;
	color : #606060;
	vertical-align: top;
	padding: 2px;
}
</style>