<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.UnLock}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 編集ロック解除'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		&gt; <a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">{write:shopping.product.product_object->'product_name'}</a>
		&gt; 編集ロック解除
	</div>

	<h1>{write:SHOPPING_LABEL_PRODUCT}管理 &gt; {write:shopping.product.product_object->'product_name'} &gt; 編集ロック解除</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}
	<p>
		この{write:SHOPPING_LABEL_PRODUCT}の編集ロックを解除しました。
	</p>
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shopping.product.product_object->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shopping.product.product_object->'product_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名フリガナ</th>
		<td>{write:shopping.product.product_object->'product_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">所属カテゴリ</th>
		<td>
			{foreach:shopping.category.data_array num categoryObject}
			{set:child_category_array categoryObject->'child_category_object_array'}
				{if:in_array(categoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}<br />{/if}
				{foreach:child_category_array childCategoryObject}
				{set:grand_child_category_array childCategoryObject->'child_category_object_array'}
					{if:in_array(childCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}<br />{/if}
					{foreach:grand_child_category_array grandChildCategoryObject}
						{if:in_array(grandChildCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}&nbsp;-&nbsp;{write:grandChildCategoryObject->'category_name'}<br />{/if}
					{/foreach}
				{/foreach}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">公開設定</th>
		<td>
			<table style="text-align:center;">
			<thead>
			<tr>
				<th style="width:6em;">会員種別</th>
				{foreach:MEMBER_MEMBER_CLASS_HASH key value}
				<th style="width:3em;" title="{write:value}">{write:mb_substr(value,0,1)}</th>
				{/foreach}
			</tr>
			</thead>
			<tbody>
			<tr>
				<th style="width:6em;">閲覧</th>
				{foreach:MEMBER_MEMBER_CLASS_HASH key value}
				<td style="width:3em;"><input type="checkbox" name="member_viewable[]" value="{write:key}"{if:in_array(key,shopping.product.product_object->'memberViewableArray')} checked{/if} disabled="disabled" /></td>
				{/foreach}
			</tr>
			<tr>
				<th style="width:6em;">{write:SHOPPING_LABEL_ORDER}</th>
				{foreach:MEMBER_MEMBER_CLASS_HASH key value}
				<td style="width:3em;"><input type="checkbox" name="member_purchasable[]" value="{write:key}"{if:in_array(key,shopping.product.product_object->'memberPurchasableArray')} checked{/if} disabled="disabled" /></td>
				{/foreach}
			</tr>
			</tbody>
			</table>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">商品種別<span class="required">※</span></th>
		<td>
			{write:SHOPPING_DELIVERY_TYPE_HASH[shopping.product.product_object->'delivery_type']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			{if:'1'==shopping.product.product_object->'delivery_type'}
				個別カレンダー利用
			{else}
				全体カレンダー利用
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">検索キーワード</th>
		<td>{write:shopping.product.product_object->'keywords'}</td>
	</tr>
	<tr>
		<th style="width:12em;">キャッチコピー</th>
		<td>{write:nl2br(shopping.product.product_object->'catch_copy')}</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号</th>
		<td>{write:shopping.product.product_object->'order_number'}</td>
	</tr>
	<tr>
		<th style="width:12em;">公式紹介URL</th>
		<td>{write:shopping.product.product_object->'product_url'}</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文</th>
		<td>{write:nl2br(shopping.product.product_object->'description')}</td>
	</tr>
	<tr>
		<th style="width:12em;">詳細コメント</th>
		<td>{write:nl2br(shopping.product.product_object->'detail_comment')}</td>
	</tr>
	
	
	{set:fileIdArray shopping.product.product_object::fileIdArray}
	<tr>
		<th style="width:12em;">添付ファイル1</th>
		<td>
			{if:isset(fileIdArray[0])}
				<img src="/file/download.php?fi={write:fileIdArray[0]}&amp;w=180&amp;h=180" /><br />
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">添付ファイル2</th>
		<td>
			{if:isset(fileIdArray[1])}
				<img src="/file/download.php?fi={write:fileIdArray[1]}&amp;w=180&amp;h=180" /><br />
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">添付ファイル3</th>
		<td>
			{if:isset(fileIdArray[2])}
				<img src="/file/download.php?fi={write:fileIdArray[2]}&amp;w=180&amp;h=180" /><br />
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{if:strlen(shopping.product.product_object->'option1_name')>0 || strlen(shopping.product.product_object->'option2_name')>0 || strlen(shopping.product.product_object->'option3_name')>0 || strlen(shopping.product.product_object->'option4_name')>0 || strlen(shopping.product.product_object->'option5_name')>0}

	<h2 class="global">{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.product_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
	{if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>{write:shopping.product.product_object->optionVarName}</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			{if:optionType=='__INPUT_TYPE_TEXT__'}
				[テキスト] 入力欄サイズ：{write:optionCols}
			{else-if:optionType=='__INPUT_TYPE_TEXTAREA__'}
				[複数行テキスト] 横幅：{write:optionCols} 行数：{write:optionRows}
			{else-if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
				[選択ボックス]<br />
				{write:nl2br(shopping.product.product_object->optionItemsName)}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明URL</th>
		<td>{write:shopping.product.product_object->optionUrlName}</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	
	{/if}
	
	<h2 class="global">卸元情報</h2>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">卸業者名</th>
		<td>{write:shopping.product.product_object->'wholesaler_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メールアドレス</th>
		<td>{write:shopping.product.product_object->'wholesaler_email'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メモ</th>
		<td>{write:nl2br(shopping.product.product_object->'wholesaler_note')}</td>
	</tr>
	</tbody>
	</table>
	<br />

{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:strlen(shopping.product.product_object->'product_number')==0}
		{else}
		<a href="./detail.php?shpdn={write:shopping.product.product_object->'product_number'}">&gt;&gt; {write:shopping.product.product_object->'product_name'}の詳細へ戻る</a>
		&nbsp;&nbsp;
		{/if}
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>