<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.Load}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > ' . SHOPPING_LABEL_PRODUCT . 'の詳細'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		{if:is_object(shopping.product.product_object->'searchDataObject')}
		&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}</a>
		&gt; <a href="./?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		&gt; {write:shopping.product.product_object->'product_name'}
	</div>

	<h1>
		{write:SHOPPING_LABEL_PRODUCT}管理
		{if:is_object(shopping.product.product_object->'searchDataObject')}
			&gt; {write:shopping.product.product_object->'searchDataObject'->'subject'}
		{/if}
		&gt; {write:shopping.product.product_object->'product_name'}
	</h1>
	{if:is_object(shopping.product.product_object->'searchDataObject')}
	<div style="width:95%;margin:0 auto;text-align:right;">
		&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細に戻る</a>
	</div>
	{/if}

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}
	
	{if:shopping.product.product_object->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この{write:SHOPPING_LABEL_PRODUCT}は現在非公開です。{write:SHOPPING_LABEL_ORDER}可能にするには状態を「掲載中」に変更してください。
	</div>
	{/if}
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:shopping.product.product_object->'delivery_type'>=200}
		<a href="../calendar/?shpdi={write:shopping.product.product_object->'product_id'}"
		>個別営業日設定</a>
		&nbsp;
		{/if}
		<a href="javascript:shopping_modify_product({write:shopping.product.product_object->'product_number'});">&gt;&gt; 編集</a>
		&nbsp;&nbsp;
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>
	
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}基本情報</h2>
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shopping.product.product_object->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shopping.product.product_object->'product_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名フリガナ</th>
		<td>{write:shopping.product.product_object->'product_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>{write:shopping.product.product_object->'unit_string'}</td>
	</tr>
	<tr>
		<th style="width:12em;">所属カテゴリ</th>
		<td>
			{foreach:shopping.category.data_array num categoryObject}
			{set:child_category_array categoryObject->'child_category_object_array'}
				{if:in_array(categoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}<br />{/if}
				{foreach:child_category_array childCategoryObject}
				{set:grand_child_category_array childCategoryObject->'child_category_object_array'}
					{if:in_array(childCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}<br />{/if}
					{foreach:grand_child_category_array grandChildCategoryObject}
						{if:in_array(grandChildCategoryObject->'category_id',shopping.product.product_object->'categoryIdArray')}{write:categoryObject->'category_name'}&nbsp;-&nbsp;{write:childCategoryObject->'category_name'}&nbsp;-&nbsp;{write:grandChildCategoryObject->'category_name'}<br />{/if}
					{/foreach}
				{/foreach}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">状態</th>
		<td>
			<select name="status_flag_{write:shopping.product.product_object->'product_number'}"
			onchange="shoppingProductStatusChange({write:shopping.product.product_object->'product_number'},this.options[this.selectedIndex].value)">
			{foreach:SHOPPING_PRODUCT_STATUS_HASH key status_name}
				<option value="{write:key}"
					{if:key==shopping.product.product_object->'status_flag'} selected{/if}
					>{write:status_name}</option>
			{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:in_array(key,shopping.product.product_object->'memberViewableArray')} checked{/if}
			onclick="shoppingProductOpenChange()"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:in_array(key,shopping.product.product_object->'memberPurchasableArray')} checked{/if}
			onclick="shoppingProductOpenChange()"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">商品種別<span class="required">※</span></th>
		<td>
			{write:SHOPPING_DELIVERY_TYPE_HASH[shopping.product.product_object->'delivery_type']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			{if:'1'==shopping.product.product_object->'calendar_type'}
				個別カレンダー利用
			{else}
				全体カレンダー利用
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">検索キーワード</th>
		<td>{write:shopping.product.product_object->'keywords'}</td>
	</tr>
	<tr>
		<th style="width:12em;">キャッチコピー</th>
		<td>{write:nl2br(shopping.product.product_object->'catch_copy')}</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号</th>
		<td>{write:shopping.product.product_object->'order_number'}</td>
	</tr>
	<tr>
		<th style="width:12em;">公式紹介URL</th>
		<td>{write:shopping.product.product_object->'product_url'}</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文</th>
		<td>{write:nl2br(shopping.product.product_object->'description')}</td>
	</tr>
	<tr>
		<th style="width:12em;">関連商品</th>
		<td>
			{if:is_array(shopping.product.relatedProductObjectArray)}
			{foreach:shopping.product.relatedProductObjectArray relatedProductObject}
			{write:relatedProductObject->'product_id'}:{write:relatedProductObject->'product_name'}<br />
			{/foreach}
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{set:fileIdArray shopping.product.product_object->'fileIdArray'}
	{if:isset(fileIdArray[0]) || isset(fileIdArray[1]) || isset(fileIdArray[2])}
	<h2>{write:SHOPPING_LABEL_PRODUCT}画像</h2>
	<div style="width:96%;margin:0 auto;text-align:center;">
		<?php for( $GLOBALS['num']=0; $GLOBALS['num']<10; $GLOBALS['num']++ ){ ?>
		{if:isset(fileIdArray[num])}
			<img src="/file/download.php?fi={write:fileIdArray[num]}&amp;w=240&amp;h=240" />
		{/if}
		<?php } ?>
	</div>
	<br />
	{/if}
	
	{if:strlen(shopping.product.product_object->'detail_comment')>0}
	<h2>追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;border:solid 1px #808080;padding:3px;">
		{write:shopping.product.product_object->'detail_comment' noescape}
	</div>
	<br />
	{/if}
	
	{if:strlen(shopping.product.product_object->'option1_name')>0 || strlen(shopping.product.product_object->'option2_name')>0 || strlen(shopping.product.product_object->'option3_name')>0 || strlen(shopping.product.product_object->'option4_name')>0 || strlen(shopping.product.product_object->'option5_name')>0}
	<h2 class="global">{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']		= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.product_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
	{if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>{write:shopping.product.product_object->optionVarName}</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			{if:optionType=='__INPUT_TYPE_TEXT__'}
				[テキスト] 入力欄サイズ：{write:optionCols}
			{else-if:optionType=='__INPUT_TYPE_TEXTAREA__'}
				[複数行テキスト] 横幅：{write:optionCols} 行数：{write:optionRows}
			{else-if:strlen(trim(shopping.product.product_object->optionItemsName))>0}
				[選択ボックス]<br />
				{write:nl2br(shopping.product.product_object->optionItemsName)}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			{write:shopping.product.product_object->optionExpName}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			{if:'1'!=shopping.product.product_object->optionCalcName}注文数で乗算する{/if}
			{if:'1'==shopping.product.product_object->optionCalcName}注文数で乗算しない{/if}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	
	{/if}
	
	{if:strlen(shopping.product.product_object->'wholesaler_name')>0 || strlen(shopping.product.product_object->'wholesaler_email')>0 || strlen(shopping.product.product_object->'wholesaler_note')>0}
	<h2 class="global">卸元情報</h2>
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">卸業者名</th>
		<td>{write:shopping.product.product_object->'wholesaler_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メールアドレス</th>
		<td>{write:shopping.product.product_object->'wholesaler_email'}</td>
	</tr>
	<tr>
		<th style="width:12em;">卸業者メモ</th>
		<td>{write:nl2br(shopping.product.product_object->'wholesaler_note')}</td>
	</tr>
	</tbody>
	</table>
	<br />
	{/if}
	
	<h2 class="global">販売単位</h2>
	{set:unitObjectArray shopping.product.product_object->'unitObjectArray'}
	<table class="detail" style="width:96%;margin:0 auto;">
	<thead>
	<tr>
		<th style="white-space:nowrap;">販売単位名</th>
		<th style="white-space:nowrap;">通常価格</th>
		<th style="white-space:nowrap;">販売価格</th>
		<th style="white-space:nowrap;">在庫数</th>
		<th style="white-space:nowrap;">付与Pt.</th>
		<th style="white-space:nowrap;">状態</th>
		<th style="white-space:nowrap;">権限</th>
		<th style="white-space:nowrap;">操作</th>
	</tr>
	</thead>
	<tbody>
	{foreach:unitObjectArray unitObject}
	<tr{if:unitObject->'status_flag'<100} style="background-color:#c0c0c0;"{/if}>
		<td style="vertical-align:top;">
			<a href="./unit/detail.php?shpdi={write:shopping.product.product_object->'product_id'}&amp;shpun={write:unitObject->'unit_number'}">{write:unitObject->'unit_name'}</a>
			{if:unitObject->'discount_exception'=='1'}<br />※割引除外{/if}
		</td>
		<td style="white-space:nowrap;text-align:right;width:30%;">&yen;{write:number_format(unitObject->'price_standard')}-</td>
		<td style="white-space:nowrap;text-align:right;width:30%;">
			&yen;{write:number_format(unitObject->'price_sell')}-
			{if:unitObject->'price_monthly'>0}<br />(月額課金:&yen;{write:number_format(unitObject->'price_monthly')}-){/if}
		</td>
		<td style="white-space:nowrap;text-align:right;width:20%;">
			{if:unitObject->'stock'==-1}
				無制限
			{else}
				{write:unitObject->'stock_view'}
			{/if}
		</td>
		<td style="white-space:nowrap;text-align:right;">
			{write:number_format(unitObject->'present_point')}Pt.
		</td>
		<td style="white-space:nowrap;">
			<select name="status_flag_{write:shopping.product.product_object->'product_number'}_{write:unitObject->'unit_number'}"
			onchange="shoppingProductUnitStatusChange({write:unitObject->'unit_number'},this.options[this.selectedIndex].value)">
			{foreach:SHOPPING_PRODUCT_STATUS_HASH key status_name}
				<option value="{write:key}"
					{if:key==unitObject->'status_flag'} selected{/if}
					>{write:status_name}</option>
			{/foreach}
			</select>
		</td>
		<td style="font-size:x-small;white-space:nowrap;">
			閲覧<span style="background-color:#ffffff;line-height:1.8em;vertical-align:middle;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_viewable_{write:unitObject->'unit_number'}"
			value="{write:key}"{if:in_array(key,unitObject->'memberViewableArray')} checked{/if}
			style="vertical-align:middle;"
			onclick="shoppingProductUnitOpenChange({write:unitObject->'unit_number'})"
			/>{write:mb_substr(value,0,1)}
			{/foreach}
			</span><br />
			{write:SHOPPING_LABEL_ORDER}<span style="background-color:#ffffff;line-height:1.8em;vertical-align:middle;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_purchasable_{write:unitObject->'unit_number'}" value="{write:key}"
			{if:in_array(key,unitObject->'memberPurchasableArray')} checked{/if}
			style="vertical-align:middle;"
			onclick="shoppingProductUnitOpenChange({write:unitObject->'unit_number'})"
			/>{write:mb_substr(value,0,1)}
			{/foreach}
			</span>
		</td>
		<td style="white-space:nowrap;">
			<a href="./unit/form.php?shpdi={write:shopping.product.product_object->'product_id'}&amp;shpun={write:unitObject->'unit_number'}">編集</a>
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./unit/form.php?shpdi={write:shopping.product.product_object->'product_id'}">+販売単位の追加</a>
	</div>
	<br />

<script type="text/javascript"><!--
var shoppingProductStatusHttpObject;
//
// {write:SHOPPING_LABEL_PRODUCT}の状態を変更する
//
function shoppingProductStatusChange(productNumber,statusFlag) {
	var contents	= 'product_number='+productNumber
	+'&status_flag='+statusFlag;
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductStatusChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./status.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductStatusChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//
// 販売単位の状態を変更する
//
function shoppingProductUnitStatusChange(unitNumber,statusFlag) {
	var contents	= 'unit_number='+unitNumber
	+'&status_flag='+statusFlag;
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductUnitStatusChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./unit/status.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductUnitStatusChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//
// {write:SHOPPING_LABEL_PRODUCT}の権限を変更する
//
function shoppingProductOpenChange() {
	var contents	= 'product_number={write:shopping.product.product_object->'product_number'}';
	var checkName	= 'member_viewable[]';
	var viewCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<viewCheckArray.length; num++ ) {
		if( viewCheckArray[num] && viewCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_viewable[]')+'='+viewCheckArray[num].value;
		}
	}
	checkName	= 'member_purchasable[]';
	var purchaseCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<purchaseCheckArray.length; num++ ) {
		if( purchaseCheckArray[num] && purchaseCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_purchasable[]')+'='+purchaseCheckArray[num].value;
		}
	}
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductOpenChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./memberclass.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductOpenChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//
// {write:SHOPPING_LABEL_PRODUCT}販売単位の権限を変更する
//
function shoppingProductUnitOpenChange(unitNumber) {
	var contents	= 'unit_number='+unitNumber;
	var checkName	= 'member_viewable_'+unitNumber;
	var viewCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<viewCheckArray.length; num++ ) {
		if( viewCheckArray[num] && viewCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_viewable[]')+'='+viewCheckArray[num].value;
		}
	}
	checkName	= 'member_purchasable_'+unitNumber;
	var purchaseCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<purchaseCheckArray.length; num++ ) {
		if( purchaseCheckArray[num] && purchaseCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_purchasable[]')+'='+purchaseCheckArray[num].value;
		}
	}
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductUnitOpenChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./unit/memberclass.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductUnitOpenChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//--></script>
{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="javascript:shopping_modify_product({write:shopping.product.product_object->'product_number'});">&gt;&gt; 編集</a>
		{if:is_object(shopping.product.product_object->'searchDataObject')}
		&nbsp;&nbsp;
		&gt;&gt; <a href="../../search/data/detail.php?schdi={write:shopping.product.product_object->'searchDataObject'->'data_id'}">{write:shopping.product.product_object->'searchDataObject'->'subject'}の詳細に戻る</a>
		{/if}
		&nbsp;&nbsp;
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_PRODUCT}一覧へ戻る</a>
	</div>