<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.order.settlement.LoadList}
{module:shopping.order.Load}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_ORDER . '情報詳細'}


	{set:memberObject shopping.order.orderObject->'memberObject'}
	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">ショップ管理</a>
		&gt; <a href="./">{write:SHOPPING_LABEL_ORDER}一覧</a>
		{if:!is_null(shopping.order.orderObject) && strlen(shopping.order.orderObject->'order_id')>0}
		&gt; {write:shopping.order.orderObject->'order_id'}
		{else}
		{/if}
	</div>

	<h1>ショップ管理 &gt; {write:SHOPPING_LABEL_ORDER}一覧 &gt; {write:shopping.order.orderObject->'order_id'}の{write:SHOPPING_LABEL_ORDER}情報</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<br />
{else}

	{if:shopping.order.enableSynchronize}{else}
	{if:shopping.order.orderObject->'settle_price'>shopping.order.orderObject->'payment_total'}
	<div style="width:96%;margin:0 auto;color:#ee0000;background-color:#fffafa;font-weight:bold;border:dotted 1px #ff0000;margin-bottom:1em;">
		※過払いが発生しています！
		<div style="padding:5px;font-weight:100;">
			お支払い金額とお支払い済金額に差分が発生しています。<br />
			経理的な処理をおこなった後に実際のお支払い金額を修正してください。
		</div>
	</div>
	{else-if:shopping.order.orderObject->'settle_price'<shopping.order.orderObject->'payment_total'}
	<div style="width:96%;margin:0 auto;color:#ee0000;background-color:#fffafa;font-weight:bold;border:dotted 1px #ff0000;margin-bottom:1em;">
		※お支払い金額が合計金額に達していません！
		<div style="padding:5px;font-weight:100;">
			お支払い金額とお支払い済金額に差分が発生しています。<br />
			経理的な処理をおこなった後に実際のお支払い金額を修正してください。
		</div>
	</div>
	{else}
	<div style="width:96%;margin:0 auto;color:#800000;font-weight:bold;background-color:#fffefa;font-weight:bold;border:dotted 1px #800000;margin-bottom:1em;">
	この{write:SHOPPING_LABEL_ORDER}の決済方法は決済状態同期機能に未対応の為、<br />
	実際の決済金額と相違が発生していても判別されませんのでご注意ください。
	</div>
	{/if}
	{/if}
	
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}ID</th>
		<td>
			{write:shopping.order.orderObject->'order_id'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}日時</th>
		<td>
			{write:shopping.order.orderObject->'registered_date'}
		</td>
	</tr>
	</tbody>
	</table><br />

	<h2 class="global">ご{write:SHOPPING_LABEL_ORDER}者の情報</h2>

	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	{if:in_array('name',MEMBER_REGIST_ITEM)}
	<tr>
		<th style="width:12em;">お名前</th>
		<td>
			{write:memberObject->'family_name'} {write:memberObject->'first_name'}
		</td>
	</tr>
	{/if}
	{if:in_array('name_kana',MEMBER_REGIST_ITEM)}
	<tr>
		<th style="width:12em;">フリガナ</th>
		<td>
			{write:memberObject->'family_kana'} {write:memberObject->'first_kana'}
		</td>
	</tr>
	{/if}
	<tr>
		<th style="width:12em;">種別</th>
		<td>
			{write:MEMBER_MEMBER_CLASS_HASH[memberObject->'member_class']}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">メールアドレス</th>
		<td>
			{if:strlen(memberObject->'pc_mail')>0}
			{write:memberObject->'pc_mail'}
			<br />
			{/if}
			{if:strlen(memberObject->'mb_mail')>0}
			{write:memberObject->'mb_mail'}
			{/if}
		</td>
	</tr>
	</tbody>
	</table>
	
	{if:in_array('zip_code',MEMBER_REGIST_ITEM) || in_array('prefecture',MEMBER_REGIST_ITEM) || in_array('address',MEMBER_REGIST_ITEM) || in_array('telephone',MEMBER_REGIST_ITEM) || in_array('faximili',MEMBER_REGIST_ITEM) || in_array('mobile',MEMBER_REGIST_ITEM)}
	{if:in_array('zip_code',MEMBER_REGIST_ITEM)}
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">郵便番号</th>
		<td>
			〒{write:memberObject->'zip_code'}
		</td>
	</tr>
	{/if}
	{if:in_array('prefecture',MEMBER_REGIST_ITEM)}
	<tr>
		<th style="width:12em;">都道府県</th>
		<td style="padding:5px;{if:array_key_exists('prefecture_number',columnErrorHash)}background-color:#ffa0a0;{/if}">
			{if:strlen(memberObject->'prefecture_number')>0}{write:PREFECTURE_HASH[memberObject->'prefecture_number']}{/if}
		</td>
	</tr>
	{/if}
	{if:in_array('address',MEMBER_REGIST_ITEM)}
	<tr>
		<th>住所・番地</th>
		<td>
			{write:memberObject->'address'}
		</td>
	</tr>
	<tr>
		<th>建物名・部屋番号</th>
		<td>
			{write:memberObject->'building'}
		</td>
	</tr>
	{/if}
	{if:in_array('telephone',MEMBER_REGIST_ITEM)}
	<tr>
		<th>お電話番号</th>
		<td>
			{write:memberObject->'telephone_number'}
		</td>
	</tr>
	{/if}
	{if:in_array('faximili',MEMBER_REGIST_ITEM)}
	<tr>
		<th>FAX番号</th>
		<td>
			{write:memberObject->'faximili_number'}
		</td>
	</tr>
	{/if}
	{if:in_array('mobile',MEMBER_REGIST_ITEM)}
	<tr>
		<th>携帯電話番号</th>
		<td>
			{write:memberObject->'mobile_number'}
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	{/if}
	<p style="text-align:right;">
		<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/member/member/detail.php?mi={write:memberObject->'member_id'}">&gt;&gt; {write:SHOPPING_LABEL_ORDER}者情報の詳細と編集</a>
	</p>
	
	<h2 class="global">お支払いと状態</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="padding:5px;width:12em;">小計(税込)</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'price_total')}-
		</td>
	</tr>
	{if:shopping.order.orderObject->'wrapping_price'>0}
	<tr>
		<th style="padding:5px;width:12em;">包装代</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'wrapping_price')}-
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'delivery_price'>0}
	<tr>
		<th style="padding:5px;width:12em;">配送料</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'delivery_price')}-
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'settle_fee'>0}
	<tr>
		<th style="padding:5px;width:12em;">決済手数料</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'settle_fee')}-
		</td>
	</tr>
	{/if}
	{if:shopping.order.orderObject->'discount_price'>0}
	<tr>
		<th style="padding:5px;width:12em;">{if:is_object(shopping.order.promotionInformation)}{write:shopping.order.promotionInformation->'promotion_name'}様からの{/if}ご紹介割引</th>
		<td style="text-align:right;color:#ff0000;">
			-&yen;{write:number_format(shopping.order.orderObject->'discount_price')}-
		</td>
	</tr>
	{/if}
	<tr>
		<th style="padding:5px;width:12em;">{write:SHOPPING_LABEL_ORDER}合計金額</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'purchase_total')}-
		</td>
	</tr>
	{if:memberObject->'member_class'>0}
	<tr>
		<th style="padding:5px;width:12em;">利用ポイント</th>
		<td style="text-align:right;">
			{write:number_format(shopping.order.orderObject->'point_use')}Pt.
		</td>
	</tr>
	{/if}
	<tr>
		<th style="padding:5px;width:12em;">お支払い金額(税込)</th>
		<td style="text-align:right;">
			&yen;{write:number_format(shopping.order.orderObject->'payment_total')}-
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">管理者調整金額</th>
		<td style="text-align:right;">
		<form name="discountAdminForm" action="./savesettleadmin.php" method="post">
			<input type="hidden" name="order_id" value="{write:shopping.order.orderObject->'order_id'}" />
			&yen;<input type="text" name="discount_admin" size="10" style="text-align:right;"
			value="{write:shopping.order.orderObject->'discount_admin'}" /><input type="submit" value="変更" />
		</form>
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;{if:shopping.order.orderObject->'settle_price'==shopping.order.orderObject->'payment_total'}{else}background-color:#fff0f0;{/if}">お支払い済金額</th>
		<td style="text-align:right;{if:shopping.order.orderObject->'settle_price'==shopping.order.orderObject->'payment_total'}{else}background-color:#fff0f0;{/if}">
		<form name="settlePriceForm" action="./savesettleprice.php" method="post">
			<input type="hidden" name="order_id" value="{write:shopping.order.orderObject->'order_id'}" />
			&yen;<input type="text" name="settle_price" size="10" style="text-align:right;"
			value="{write:shopping.order.orderObject->'settle_price'}" /><input type="submit" value="変更" />
		</form>
		</td>
	</tr>
	{if:memberObject->'member_class'>0}
	<tr>
		<th style="padding:5px;width:12em;">付与ポイント</th>
		<td style="text-align:right;">
			{write:number_format(shopping.order.orderObject->'point_total')}Pt.
		</td>
	</tr>
	{/if}
	<tr>
		<th style="padding:5px;width:12em;">お支払い方法</th>
		<td style="padding:5px;">
			{foreach:shopping.order.settlement.methodObjectArray settleMethodObject}
				{if:strlen(shopping.order.orderObject->'settle_method')>0 && settleMethodObject->getMethodNumber()==shopping.order.orderObject->'settle_method'}{write:settleMethodObject->getMethodViewName()}{/if}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">{write:SHOPPING_LABEL_ORDER}状態</th>
		<td style="padding:5px;">
		<form name="status_form" action="#" method="get">
			<select id="order_status_flag" name="status_flag" style="width:100%;"
			onchange="shoppingOrderChangeStatus(this,{write:shopping.order.orderObject->'order_number'},'flag')"
			onfocus="shoppingOrderSetPrevStatus(this);"
			>
				{foreach:SHOPPING_ORDER_STATUS_HASH key val}
				<option value="{write:key}"
					{if:strlen(shopping.order.orderObject->'status_flag')>0 && key==shopping.order.orderObject->'status_flag'} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select>
		</form>
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">お支払い状態</th>
		<td style="padding:5px;">
		<form name="status_settle_form" action="#" method="get">
			<select id="ssettle_{write:shopping.order.orderObject->'order_number'}"
				style="width:100%;"
				onchange="shoppingOrderChangeStatus(this,{write:shopping.order.orderObject->'order_number'},'settle')"
				onfocus="shoppingOrderSetPrevStatus(this);"
			>
				{foreach:SHOPPING_ORDER_STATUS_SETTLE_HASH key val}
				<option value="{write:key}"
					{if:strlen(shopping.order.orderObject->'status_flag')>0 && key==shopping.order.orderObject->'status_settle'} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select>
		</form>
		</td>
	</tr>
	{if:strlen(shopping.order.orderObject->'promotion_code')>0}
	<tr>
		<th style="padding:5px;width:12em;">プロモーション状態</th>
		<td style="padding:5px;">
		<form name="status_promotion_form" action="#" method="get">
			<select id="spromo_{write:shopping.order.orderObject->'order_number'}"
				class="status_settle_a{write:shopping.order.orderObject->'status_promotion'}"
				style="width:100%;"
				onchange="shoppingOrderChangeStatus(this,{write:shopping.order.orderObject->'order_number'},'promotion')"{if:shopping.order.orderObject->'status_settle'<100} disabled="desabled"{/if}
				onfocus="shoppingOrderSetPrevStatus(this);"
				>
				{foreach:SHOPPING_ORDER_STATUS_PROMOTION_HASH key val}
				<option value="{write:key}" class="status_settle_a{write:key}"
					{if:strlen(shopping.order.orderObject->'status_promotion')>0 && key==shopping.order.orderObject->'status_promotion'} selected{/if}
					>{write:val}</option>
				{/foreach}
			</select>
		</form>
		</td>
	</tr>
	{/if}
	</tbody>
	</table>
	<br />

	{foreach:shopping.order.orderObject::shoppingOrderAddressObjectArray addressOrder shoppingOrderAddressObject}
	<h2 class="global">{write:SHOPPING_LABEL_ORDER}内容:配送先{write:(addressOrder+1)}</h2>
	<div class="admin_cart">
	<table style="width:96%;margin:0 auto;border-collapse:collapse;">
	<thead>
	<tr>
		<th colspan="2">情報</th>
		<th>単価</th>
		<th>{write:SHOPPING_LABEL_ORDER}数</th>
		<th>金額</th>
	</tr>
	</thead>
	<tbody>
	{foreach:shoppingOrderAddressObject::shoppingOrderItemObjectArray orderItemObject}
	{set:unitObject orderItemObject->'shoppingProductUnitObject'}
	{set:productObject unitObject->'shoppingProductObject'}
	<tr>
		<td {if:count(orderItemObject->'shoppingOrderOptionObjectArray')>0} rowspan="{write:count(orderItemObject->'shoppingOrderOptionObjectArray')+1}"{/if}style="width:120px;height:120px;text-align:center;vertical-align:middle;padding:3px;">
			{set:fileIdArray productObject::fileIdArray}
			{if:strlen(fileIdArray[0])>0}
				<img src="/file/download.php?fi={write:fileIdArray[0]}&amp;w=120&amp;h=120" />
			{else}
				画像なし
			{/if}
		</td>
		<td style="vertical-align:top;padding:3px;">
			<form name="orderItemForm_{write:orderItemObject->'item_id'}" action="./changeterm.php" method="post">
			<input type="hidden" name="item_id" value="{write:orderItemObject->'item_id'}" />
			{write:productObject->'product_name'} {write:unitObject->'unit_name'}
			{if:strlen(orderItemObject->'used_unit_id')>0}
				{write:orderItemObject->'usedUnitObject'->'unit_name'}
			{/if}
			{if:900==orderItemObject->'delivery_type'}
				{set:checkInTime strtotime(orderItemObject->'svc_start_date')}
				{set:checkOutTime strtotime(orderItemObject->'svc_limit_date')}
				<table style="border:none;">
				<tbody>
				<tr>
					<td style="border:none;padding:0px;">チェックイン日</td><td style="border:none;padding:0px;">:</td>
					<td style="border:none;padding:0px;">
					<select name="svc_start_date">
						<?php for( $GLOBALS['num']=$GLOBALS['checkInTime']-60*60*24*60; $GLOBALS['num']<=$GLOBALS['checkOutTime']+60*60*24*60; $GLOBALS['num']+=60*60*24 ) { ?>
						<option value="{write:date('Y-m-d H:i:s',num)}"
							{if:num==checkInTime} selected{/if}
							>{write:date('Y年m月d日',num)}({write:WEEK_DAY_NAME_ARRAY[date('w',num)]})</option>
						<?php } ?>
					</select>
					</td>
				</tr>
				<tr>
					<td style="border:none;padding:0px;">チェックアウト日</td><td style="border:none;padding:0px;">：</td>
					<td style="border:none;padding:0px;">
						<select name="svc_limit_date">
							<?php for( $GLOBALS['num']=$GLOBALS['checkInTime']-60*60*24*60; $GLOBALS['num']<=$GLOBALS['checkOutTime']+60*60*24*60; $GLOBALS['num']+=60*60*24 ) { ?>
							<option value="{write:date('Y-m-d',num)} {write:date('H:i:s',checkOutTime)}"
								{if:date('Ymd',num)==date('Ymd',checkOutTime)} selected{/if}
								>{write:date('Y年m月d日',num)}({write:WEEK_DAY_NAME_ARRAY[date('w',num)]})</option>
							<?php } ?>
						</select>
					</td>
				</tr>
				</tbody>
				</table>
				<input type="submit" value="期間変更" />
			{else-if:200<=orderItemObject->'delivery_type'}
				<br />
				{write:date('Y年m月d日',strtotime(orderItemObject->'svc_start_date'))}({write:WEEK_DAY_NAME_ARRAY[date('w',strtotime(orderItemObject->'svc_start_date'))]})<br />
				<select name="svc_start_date">
					<?php for( $GLOBALS['num']=0; $GLOBALS['num']<=24; $GLOBALS['num']++ ) { ?>
					<option value="{write:date('Y-m-d',strtotime(orderItemObject->'svc_start_date'))} {write:sprintf('%02d',num)}:00"
						{if:date('H:i',strtotime(orderItemObject->'svc_start_date'))==sprintf('%02d',num) . ':00'} selected{/if}
						>{write:sprintf('%02d',num)}:00</option>
					<?php } ?>
				</select>
				～
				<select name="svc_limit_date">
					<?php for( $GLOBALS['num']=0; $GLOBALS['num']<=24; $GLOBALS['num']++ ) { ?>
					<option value="{write:date('Y-m-d',strtotime(orderItemObject->'svc_start_date'))} {write:sprintf('%02d',num)}:00"
						{if:date('H:i',strtotime(orderItemObject->'svc_limit_date'))==sprintf('%02d',num) . ':00'} selected{/if}
						>{write:sprintf('%02d',num)}:00</option>
					<?php } ?>
				</select><input type="submit" value="時間変更" />
			{else-if:20<=orderItemObject->'delivery_type'}
				{write:date('Y年m月d日',strtotime(orderItemObject->'svc_start_date'))}～{write:date('Y年m月d日',strtotime(orderItemObject->'svc_limit_date'))}
			{/if}
			</form>
			<?php if( defined('SHOPPING_ORDER_ITEM_FILE_USE') && '1' == SHOPPING_ORDER_ITEM_FILE_USE ){ ?>
			[<a href="./file/index.php?shpon={write:shopping.order.orderObject->'order_number'}&amp;shpoin={write:orderItemObject->'item_number'}">アップロードファイル</a>]
			<?php } ?>

		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			&yen;{write:number_format(orderItemObject->'price_unit')}-
		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			{write:orderItemObject->'order_count'}
		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			&yen;{write:number_format(orderItemObject->getTotalUnitPrice(request))}-
		</td>
	</tr>
	{if:count(orderItemObject->'shoppingOrderOptionObjectArray')>0}
	{foreach:orderItemObject::shoppingOrderOptionObjectArray orderOptionObject}
	<tr>
		<td style="vertical-align:top;padding:3px;">
			{write:orderOptionObject->'option_name'}
			{write:orderOptionObject->'option_value'}
		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			&yen;{write:orderOptionObject->'option_price'}-
		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			{write:orderOptionObject->'order_count'}
		</td>
		<td style="vertical-align:top;text-align:right;padding:3px;">
			&yen;{write:number_format(orderOptionObject->getTotalPrice( request ))}-
		</td>
	</tr>
	{/foreach}
	{/if}
	{/foreach}
	{if:shoppingOrderAddressObject->'delivery_price'>0}
	<tr>
		<th colspan="4" style="text-align:right;">
			配送料
		</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'delivery_price')}-
		</td>
	</tr>
	{/if}
	{if:shoppingOrderAddressObject->'wrapping_price'>0}
	<tr>
		<th colspan="4" style="text-align:right;">
			包装代
		</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'wrapping_price')}-
		</td>
	</tr>
	{/if}
	{if:shoppingOrderAddressObject->'settle_fee'>0}
	<tr>
		<th colspan="4" style="text-align:right;">
			決済手数料
		</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->'settle_fee')}-
		</td>
	</tr>
	{/if}
	<tr>
		<th colspan="4" style="text-align:right;">
			配送先{write:(addressOrder+1)} 小計
		</th>
		<td style="text-align:right;border:solid 1px #999;padding:3px;font-weight:bold;background-color:#eee;">
			&yen;{write:number_format(shoppingOrderAddressObject->getTotalPaymentPrice( request ))}-
		</td>
	</tr>
	</tbody>
	</table>
	</div>
	<br />
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="padding:5px;width:12em;">宛名</th>
		<td style="padding:5px;">{write:shoppingOrderAddressObject->'address_name'}</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">宛先住所</th>
		<td style="padding:5px;">
			〒{write:shoppingOrderAddressObject->'zip_code'}
			{if:strlen(shoppingOrderAddressObject->'prefecture_number')>0}{write:PREFECTURE_HASH[shoppingOrderAddressObject->'prefecture_number']}{/if}
			{write:shoppingOrderAddressObject->'address'}
			{write:shoppingOrderAddressObject->'building'}
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">宛先電話番号</th>
		<td style="padding:5px;">{write:shoppingOrderAddressObject->'telephone_number'}</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">お届け希望日時</th>
		<td style="padding:5px;">
			{write:shoppingOrderAddressObject->'wishful_date'}
			{write:shoppingOrderAddressObject->'wishful_time'}
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">包装</th>
		<td style="padding:5px;">
			{if:shoppingOrderAddressObject->'wrapping_type'==99}
				なし
			{else}
				{write:shopping.order.deliveryRappingHash[shoppingOrderAddressObject->'wrapping_type']['name']}
			{/if}
			<br />
			{if:strlen(shoppingOrderAddressObject->'wrapping_words1')>0}
			{write:shoppingOrderAddressObject->'wrapping_words1'}<br />
			{/if}
			{if:strlen(shoppingOrderAddressObject->'wrapping_words2')>0}
			{write:shoppingOrderAddressObject->'wrapping_words2'}<br />
			{/if}
		</td>
	</tr>
	<tr>
		<th style="padding:5px;width:12em;">配送伝票番号</th>
		<td style="padding:5px;">
			{write:shoppingOrderAddressObject->'delivery_code' nl2br}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/foreach}
	
	{if:count(shopping.order.orderObject->'shoppingOrderOptionObjectArray')>0}
	<h2 class="global">{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	{foreach:shopping.order.orderObject::shoppingOrderOptionObjectArray optionOrder orderOptionObject}
	<tr>
		<th style="width:12em;vertical-align:top;">{write:orderOptionObject->'option_name'}</th>
		<td style="vertical-align:top;">{write:orderOptionObject->'option_value'}</td>
		<td style="vertical-align:top;">&yen;{write:number_format(orderOptionObject->getTotalPrice( request ))}-</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<br />
	{/if}
	
	<h2>管理者メモ</h2>
	<form name="adminNoteForm_{write:shopping.order.orderObject->'order_id'}" action="./saveadminnote.php" method="post">
	<input type="hidden" name="order_id" value="{write:shopping.order.orderObject->'order_id'}" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<textarea name="admin_note" cols="90" rows="20" style="width:100%;"
		>{write:shopping.order.orderObject->'admin_note'}</textarea><br />
		<input type="submit" value="管理者メモ保存" />
	</div>
	</form>

	<h2 class="global">通信欄</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<td style="padding:5px;">
			{write:shopping.order.orderObject->'order_comment' nl2br}
		</td>
	</tr>
	</tbody>
	</table><br />
	
	<h2>変更履歴</h2>
	<pre style="width:100%;height:10em;;overflow:scroll;border:solid 1px #808080;">{write:shopping.order.orderObject->'history_note'}</pre>

<script language="JavaScript" type="text/javascript"><!--
var shoppingOrderStatusHttpObject;
var shoppingOrderCurOrderNumber;
var shoppingOrderCurTargetString;
var shoppingOrderCurStatusNumber;
var shoppingOrderPrevStatusIndex;
function shoppingOrderSetPrevStatus(selectElement) {
	shoppingOrderPrevStatusIndex	= selectElement.selectedIndex;
}
function shoppingOrderChangeStatus(selectElement,orderNumber,targetString) {
	if( !selectElement ) {
		alert('システムエラー！');
		return;
	} else if( !targetString ) {
		alert('システムエラー！');
		return;
	} else if( !orderNumber ) {
		alert('システムエラー！');
		return;
	}
	var statusNumber;
	if( selectElement.options && selectElement.selectedIndex >= 0 ) {
		statusNumber	= selectElement.options[selectElement.selectedIndex].value;
	} else {
		alert('システムエラー！');
		return;
	}
	
	var contents	= encodeURIComponent('target_status')+"="+encodeURIComponent(targetString);
	contents	+= '&' + encodeURIComponent('status_number')+"="+encodeURIComponent(statusNumber);
	if( !confirm('状態を変更します!\nこの操作は元に戻せなくなる場合があります!\n本当に実行してよろしいですか？') ) {
		selectElement.selectedIndex	= shoppingOrderPrevStatusIndex;
		return;
	}

	shoppingOrderCurOrderNumber		= orderNumber;
	shoppingOrderCurTargetString	= targetString;
	shoppingOrderCurStatusNumber	= statusNumber;
	
	shoppingOrderStatusHttpObject	= FormerCommon.createHttpRequest(shoppingOrderChangeStatusResult);
	if( shoppingOrderStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingOrderStatusHttpObject.open("POST",'./ajax/status.php?shpon='+orderNumber,true);
		shoppingOrderStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingOrderStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingOrderChangeStatusResult() {
	if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
	    var lines	= shoppingOrderStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    	// 決済情報が変更になった場合にプロモーション状態があれば連動させる
	    	if( 'settle' == shoppingOrderCurTargetString ) {
	    		var promoStatusSelect	= document.getElementById('spromo_'+shoppingOrderCurOrderNumber);
	    		if( promoStatusSelect ) {
	    			if( shoppingOrderCurStatusNumber < 100 ) {
	    				// 未決済の場合
	    				promoStatusSelect.selectedIndex	= 0;
	    				shoppingOrderChangeStatus(promoStatusSelect,shoppingOrderCurOrderNumber,'promotion');
	    				promoStatusSelect.disabled		= 'disabled';
	    			} else {
	    				// 決済済みになったら
	    				promoStatusSelect.selectedIndex	= 1;
	    				shoppingOrderChangeStatus(promoStatusSelect,shoppingOrderCurOrderNumber,'promotion');
	    				promoStatusSelect.disabled		= '';
	    			}
	    		}
	    	}
	    } else {
	    	alert(shoppingOrderStatusHttpObject.responseText);
	    }
	} else if ((shoppingOrderStatusHttpObject.readyState == 4) && (shoppingOrderStatusHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 500);
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
function shoppingOrderOpenPromotion(promotionId) {
	window.location.href='./promotion/detail.php?shppi='+promotionId;
}
//--></script>
{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />

	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:!is_null(shopping.order.orderObject) && strlen(shopping.order.orderObject->'order_id')>0}
		<a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/shopping/order/modify/purchaser.php?shpoi={write:shopping.order.orderObject->'order_id'}">&gt;&gt; {write:SHOPPING_LABEL_ORDER}情報の編集</a>
		&nbsp;&nbsp;
		{/if}
		<a href="./">&gt;&gt; {write:SHOPPING_LABEL_ORDER}一覧へ戻る</a>
	</div>