<?php
/*
 * system/package/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : システムパッケージ インストール済みパッケージ一覧取得用アクションモジュールクラス
 * 
 * spiderのページから呼び出して実行します。
 * 
 * @package system
 * @subpackage package
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 * @abstract
 */
class system_package_LoadList extends system_login_ModuleBase {
	function system_package_LoadList() {
		// 存在するパッケージ読み込みモジュールを先に実行
		array_push($this->require_module_array,'system.package.LoadListExists');
	}
	function execute( & $request ) {
		// 存在するパッケージを確認
		$existsPackageHash	= $request->getAttribute('system.package.existsPackageObjectHash');
		// インストール済みパッケージオブジェクトのハッシュ
		$installedPackageIdArray	= array();
		$installedPackageObjectHash	= array();
		// インストール済みかどうかは設定ファイルが存在するかどうかで確認
		if( is_array($existsPackageHash) ) {
			foreach( $existsPackageHash as $packageId => $packageConfigObject ) {
				$definitionFilePath	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.$packageId.'.define.inc.php';
				if( file_exists($definitionFilePath) && filesize($definitionFilePath) > 0 ) {
					array_push($installedPackageIdArray,$packageId);
					$installedPackageObjectHash[$packageId]	= $packageConfigObject;
				}
			}
		}
		// 属性に設定
		$request->setAttribute( 'system.package.installedPackageIdArray', $installedPackageIdArray );
		$request->setAttribute( 'system.package.installedPackageObjectHash', $installedPackageObjectHash );
		// 下位互換
		$request->setAttribute( 'system.package.installedPackageObjectHash', $installedPackageObjectHash );
	}
}
?>